/*
 * Decompiled with CFR 0.152.
 */
package splar.core.fm.randomization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import splar.core.constraints.BooleanVariable;
import splar.core.constraints.BooleanVariableInterface;
import splar.core.constraints.CNFClause;
import splar.core.constraints.CNFFormula;
import splar.core.constraints.CNFGenerator;
import splar.core.constraints.PropositionalFormula;
import splar.core.fm.FeatureGroup;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureModelException;
import splar.core.fm.FeatureTreeNode;
import splar.core.fm.GroupedFeature;
import splar.core.fm.RootNode;
import splar.core.fm.SolitaireFeature;
import splar.core.fm.TreeNodeRendererFactory;
import splar.core.fm.randomization.LevelConstraintGenerator;

public class RandomFeatureModel2
extends FeatureModel {
    private static final long serialVersionUID = 637877082231222395L;
    private int numberOfFeaturesToCreate;
    private int maxChildrenPerNode;
    private int minChildrenPerNode;
    private int mandatoryOdds;
    private int optionalOdds;
    private int group1NOdds;
    private int group11Odds;
    private int maxGroupCardinality;
    private int balanceFactor;
    private static CNFGenerator cnfGenerator;

    public RandomFeatureModel2(String name, int numberOfFeaturesToCreate, int mandatoryOdds, int optionalOdds, int group1NOdds, int group11Odds, int minChildrenPerNode, int maxChildrenPerNode, int maxGroupCardinality, int balanceFactor) {
        this.setName(name);
        this.numberOfFeaturesToCreate = numberOfFeaturesToCreate - 1;
        this.maxChildrenPerNode = maxChildrenPerNode;
        this.minChildrenPerNode = minChildrenPerNode;
        this.mandatoryOdds = (2 + (maxGroupCardinality - 2) / 2) * mandatoryOdds;
        this.optionalOdds = (2 + (maxGroupCardinality - 2) / 2) * optionalOdds;
        this.group1NOdds = group1NOdds;
        this.group11Odds = group11Odds;
        this.maxGroupCardinality = maxGroupCardinality;
        this.balanceFactor = balanceFactor;
        cnfGenerator = new CNFGenerator();
    }

    @Override
    protected FeatureTreeNode createNodes() throws FeatureModelException {
        ArrayList<FeatureTreeNode> fmNodes = new ArrayList<FeatureTreeNode>();
        String featureName = "R";
        RootNode root = new RootNode(featureName, featureName, TreeNodeRendererFactory.createRootRenderer());
        root.attachData(new Integer(this.numberOfFeaturesToCreate - 1));
        fmNodes.add(root);
        FeatureTreeNode parentNode = null;
        int countCreatedFeatures = 0;
        while (countCreatedFeatures < this.numberOfFeaturesToCreate) {
            parentNode = (FeatureTreeNode)fmNodes.get(0);
            fmNodes.remove(0);
            int numberOfDescendants = (Integer)parentNode.getAttachedData();
            int numberOfChildNodesToCreate = Math.min(numberOfDescendants, Math.abs(new Random().nextInt()) % (this.maxChildrenPerNode - this.minChildrenPerNode + 1) + this.minChildrenPerNode);
            if (parentNode.getParent() == null) {
                numberOfChildNodesToCreate = this.maxChildrenPerNode;
            } else if (this.isRoot((FeatureTreeNode)parentNode.getParent())) {
                numberOfChildNodesToCreate = this.maxChildrenPerNode;
            }
            if (numberOfChildNodesToCreate <= 0) continue;
            ArrayList<FeatureTreeNode> createdNodes = new ArrayList<FeatureTreeNode>();
            int i = 0;
            while (createdNodes.size() < numberOfChildNodesToCreate && countCreatedFeatures < this.numberOfFeaturesToCreate) {
                int availableNodes = this.numberOfFeaturesToCreate - countCreatedFeatures;
                String childFeatureName = parentNode.getID().substring(1) + "_" + (i + 1);
                FeatureTreeNode randomNode = this.createRandomNode(childFeatureName, this.randonlyChooseNodeTypeToCreate(availableNodes), availableNodes);
                parentNode.add(randomNode);
                if (randomNode instanceof FeatureGroup) {
                    FeatureGroup groupRandomNode = (FeatureGroup)randomNode;
                    int countGroupedNodes = groupRandomNode.getChildCount();
                    for (int j = 0; j < countGroupedNodes; ++j) {
                        FeatureTreeNode groupedNode = (FeatureTreeNode)groupRandomNode.getChildAt(j);
                        fmNodes.add(groupedNode);
                    }
                    countCreatedFeatures += countGroupedNodes;
                } else {
                    fmNodes.add(randomNode);
                    ++countCreatedFeatures;
                }
                createdNodes.add(randomNode);
                ++i;
            }
            this.distributeChildrenNodes(createdNodes, numberOfDescendants - createdNodes.size());
            for (FeatureTreeNode createdNode : createdNodes) {
                if (!(createdNode instanceof FeatureGroup)) continue;
                int d = (Integer)createdNode.getAttachedData() / createdNode.getChildCount();
                for (int j = 0; j < createdNode.getChildCount(); ++j) {
                    FeatureTreeNode groupedNode = (FeatureTreeNode)createdNode.getChildAt(j);
                    groupedNode.attachData(new Integer(d));
                }
            }
        }
        return root;
    }

    private void distributeChildrenNodes(List<FeatureTreeNode> nodes, int numberOfDescendants) {
        int numChildren = nodes.size();
        if (numberOfDescendants <= 0) {
            for (FeatureTreeNode node : nodes) {
                node.attachData(new Integer(0));
            }
        } else if (numChildren == 1) {
            nodes.get(0).attachData(new Integer(numberOfDescendants));
        } else if (numberOfDescendants < numChildren) {
            for (int i = 0; i < numChildren; ++i) {
                nodes.get(i).attachData(i <= numberOfDescendants ? new Integer(1) : new Integer(0));
            }
        } else {
            int i;
            int[] children = new int[numChildren];
            int fixedNumDescendants = Math.round((float)numberOfDescendants * (1.0f - (float)this.balanceFactor / 100.0f));
            int variableNumDescendants = numberOfDescendants - fixedNumDescendants;
            if (variableNumDescendants > 0) {
                float total = 0.0f;
                for (i = 0; i < numChildren; ++i) {
                    int range;
                    children[i] = range = 2 * (i + 1);
                    total += (float)children[i];
                }
                for (i = 0; i < numChildren; ++i) {
                    float x = (float)children[i] / total * (float)variableNumDescendants;
                    children[i] = Math.round(x);
                }
            } else {
                for (int i2 = 0; i2 < numChildren; ++i2) {
                    children[i2] = 0;
                }
            }
            int childIndex = 0;
            for (i = 0; i < fixedNumDescendants; ++i) {
                int n = childIndex;
                children[n] = children[n] + 1;
                childIndex = (childIndex + 1) % numChildren;
            }
            for (i = 0; i < numChildren; ++i) {
                FeatureTreeNode node = nodes.get(i);
                node.attachData(new Integer(children[i]));
            }
        }
    }

    private String randonlyChooseNodeTypeToCreate(int availableNodes) {
        if (availableNodes >= 2) {
            int randomIndex = Math.abs(new Random().nextInt()) % (this.mandatoryOdds + this.optionalOdds + this.group1NOdds + this.group11Odds);
            if (randomIndex < this.mandatoryOdds) {
                return "mandatory";
            }
            if (randomIndex < this.mandatoryOdds + this.optionalOdds) {
                return "optional";
            }
            if (randomIndex < this.mandatoryOdds + this.optionalOdds + this.group1NOdds) {
                return "group1N";
            }
            return "group11";
        }
        int randomIndex = Math.abs(new Random().nextInt()) % (this.mandatoryOdds + this.optionalOdds);
        if (randomIndex < this.mandatoryOdds) {
            return "mandatory";
        }
        return "optional";
    }

    private FeatureTreeNode createRandomNode(String childFeatureName, String nodeType, int numAvailableNodes) {
        FeatureTreeNode node;
        block5: {
            String featureName;
            block7: {
                block6: {
                    block4: {
                        node = null;
                        featureName = "";
                        if (nodeType.compareToIgnoreCase("optional") != 0) break block4;
                        featureName = "o" + childFeatureName;
                        node = new SolitaireFeature(true, featureName, featureName, TreeNodeRendererFactory.createOptionalRenderer());
                        break block5;
                    }
                    if (nodeType.compareToIgnoreCase("mandatory") != 0) break block6;
                    featureName = "m" + childFeatureName;
                    node = new SolitaireFeature(false, featureName, featureName, TreeNodeRendererFactory.createOptionalRenderer());
                    break block5;
                }
                if (nodeType.compareToIgnoreCase("group1N") != 0) break block7;
                int groupSize = Math.min(Math.abs(new Random().nextInt()) % this.maxGroupCardinality + 1, numAvailableNodes);
                if (groupSize <= 1) {
                    groupSize = 2;
                }
                int lower = 1;
                int upper = -1;
                String groupName = "_Gi_" + childFeatureName;
                node = new FeatureGroup(groupName, groupName, lower, upper, TreeNodeRendererFactory.createFeatureGroupRenderer());
                for (int i = 0; i < groupSize; ++i) {
                    featureName = "g" + childFeatureName + "_" + (i + 1);
                    node.add(new GroupedFeature(featureName, featureName, TreeNodeRendererFactory.createGroupedRenderer()));
                }
                break block5;
            }
            if (nodeType.compareToIgnoreCase("group11") != 0) break block5;
            int groupSize = Math.min(Math.abs(new Random().nextInt()) % this.maxGroupCardinality + 1, numAvailableNodes);
            if (groupSize <= 1) {
                groupSize = 2;
            }
            int lower = 1;
            int upper = 1;
            String groupName = "_Ge_" + childFeatureName;
            node = new FeatureGroup(groupName, groupName, lower, upper, TreeNodeRendererFactory.createFeatureGroupRenderer());
            for (int i = 0; i < groupSize; ++i) {
                featureName = "g" + childFeatureName + "_" + (i + 1);
                node.add(new GroupedFeature(featureName, featureName, TreeNodeRendererFactory.createGroupedRenderer()));
            }
        }
        return node;
    }

    public static int expand3CNFClauses(FeatureModel fm, float clauseDensity, String prefix) {
        CNFFormula cnf = fm.EC2CNF();
        LinkedList<BooleanVariableInterface> vars = new LinkedList<BooleanVariableInterface>(cnf.getVariables());
        LinkedList<CNFClause> clauses = new LinkedList<CNFClause>(cnf.getClauses());
        List<CNFClause> allClauses = cnfGenerator.generateCNFInstance(vars, clauses, clauseDensity, 3);
        int i = 0;
        for (CNFClause clause : allClauses) {
            try {
                fm.addConstraint(new PropositionalFormula(prefix + i++, clause.toPropositionalFormula()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return allClauses.size();
    }

    public static int createExtraConstraints(FeatureModel fm, int numVars, int numConstraints, int maxArity, int[][] modularityParameters) {
        return RandomFeatureModel2.createExtraConstraints(fm, numVars, numConstraints, maxArity, modularityParameters, 100, 100);
    }

    public static int createExtraConstraints(FeatureModel fm, int numVars, int numConstraints, int maxArity, int[][] modularityParameters, int percVar3cnf, int percForm3cnf) {
        int levelsToConsider = modularityParameters.length;
        int depth = fm.depth() - 1;
        levelsToConsider = levelsToConsider > depth ? depth : levelsToConsider;
        for (int i = 0; i < levelsToConsider; ++i) {
            modularityParameters[i][0] = Math.round((float)modularityParameters[i][0] / 100.0f * (float)depth);
            modularityParameters[i][1] = Math.round((float)modularityParameters[i][1] / 100.0f * (float)numVars);
        }
        fm.resetNodesAttachedData();
        int countLevelsWithContraints = 0;
        LinkedList<PropositionalFormula> createdFormulas = new LinkedList<PropositionalFormula>();
        for (int i = levelsToConsider - 1; i >= 0; --i) {
            if (modularityParameters[i][1] < 2) continue;
            int numConstraintsLevel = numConstraints * Math.round((float)modularityParameters[i][1] / 100.0f) / numVars;
            LevelConstraintGenerator constraintGenerator = new LevelConstraintGenerator(fm, modularityParameters[i][0], modularityParameters[i][1], numConstraintsLevel, maxArity, modularityParameters[i][2], modularityParameters[i][3]);
            List<PropositionalFormula> levelFormulas = constraintGenerator.createExtraConstraints();
            countLevelsWithContraints = levelFormulas.size() > 0 ? countLevelsWithContraints + 1 : countLevelsWithContraints;
            createdFormulas.addAll(levelFormulas);
        }
        RandomFeatureModel2.enrichFormulas(createdFormulas, percVar3cnf, percForm3cnf);
        for (PropositionalFormula formula : createdFormulas) {
            fm.addConstraint(formula);
        }
        return countLevelsWithContraints;
    }

    @Override
    public void saveNodes() {
    }

    private static void enrichFormulas(List<PropositionalFormula> fmConstraints, int percVars, int percFormulas) {
        LinkedList<PropositionalFormula> pickedFormulas = new LinkedList<PropositionalFormula>();
        pickedFormulas.addAll(fmConstraints);
        Collections.shuffle(pickedFormulas);
        int formulasToEliminate = (int)((1.0 - (double)percFormulas / 100.0) * (double)pickedFormulas.size());
        for (int i = 0; i < formulasToEliminate; ++i) {
            pickedFormulas.remove(0);
        }
        LinkedList<BooleanVariable> pickedVariables = new LinkedList<BooleanVariable>();
        for (PropositionalFormula constraint : fmConstraints) {
            for (BooleanVariable var : constraint.getVariables()) {
                if (pickedVariables.contains(var)) continue;
                pickedVariables.add(var);
            }
        }
        Collections.shuffle(pickedVariables);
        int variablesToEliminate = (int)((1.0 - (double)percVars / 100.0) * (double)pickedVariables.size());
        for (int i = 0; i < variablesToEliminate; ++i) {
            pickedVariables.remove(0);
        }
        int varIndex = 0;
        for (PropositionalFormula pickedFormula : pickedFormulas) {
            BooleanVariable pickedVariable = (BooleanVariable)pickedVariables.get(varIndex);
            int breakcounter = 0;
            while (pickedFormula.getVariables().contains(pickedVariable)) {
                varIndex = (varIndex + 1) % pickedVariables.size();
                pickedVariable = (BooleanVariable)pickedVariables.get(varIndex);
                if (++breakcounter != pickedVariables.size()) continue;
            }
            if (breakcounter < pickedVariables.size()) {
                RandomFeatureModel2.addNewVariableToFormula(pickedFormula, pickedVariable);
            }
            varIndex = (varIndex + 1) % pickedVariables.size();
        }
    }

    private static void addNewVariableToFormula(PropositionalFormula pickedFormula, BooleanVariable pickedVariable) {
        String literal = new Random().nextBoolean() ? "~" + pickedVariable.getID() : pickedVariable.getID();
        pickedFormula.appendToFormula(" OR " + literal);
        pickedFormula.appendToVariables(pickedVariable);
    }
}

