/*
 * Decompiled with CFR 0.152.
 */
package splar.core.heuristics;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import splar.core.constraints.BooleanVariable;
import splar.core.constraints.BooleanVariableInterface;
import splar.core.constraints.CNFClause;
import splar.core.constraints.CNFFormula;
import splar.core.constraints.CNFLiteral;
import splar.core.constraints.PropositionalFormula;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureTreeNode;
import splar.core.heuristics.FTPreOrderTraversalHeuristic;
import splar.core.heuristics.NodeCluster;
import splar.core.heuristics.NodeClusterManager;

public class FTPreOrderSortedECTraversalHeuristic
extends FTPreOrderTraversalHeuristic {
    public static final int SIZE_SORT = 10;
    public static final int FORCE_SORT = 20;
    private int sortType = 10;

    public FTPreOrderSortedECTraversalHeuristic(String name, FeatureModel featureModel, int sortType) {
        super(name, featureModel);
        this.sortType = sortType;
    }

    @Override
    protected FeatureTreeNode[] orderChildNodes(FeatureTreeNode node) {
        ArrayList<FeatureTreeNode> orderedNodes = new ArrayList<FeatureTreeNode>();
        List clauses = (List)node.getAttachedData();
        NodeClusterManager clusterManager = new NodeClusterManager(this.featureModel);
        NodeCluster[] clusters = clusterManager.processCluster(node, clauses);
        node.setProperty("clusters", clusters);
        for (NodeCluster cluster : clusters) {
            FeatureTreeNode[] nodes = null;
            if (this.sortType == 10 || cluster.countNodes() <= 2) {
                nodes = cluster.sortedNodes();
            } else if (this.sortType == 20) {
                nodes = cluster.sortedNodesbyFORCE(clauses);
            }
            for (FeatureTreeNode sortedNode : nodes) {
                orderedNodes.add(sortedNode);
            }
        }
        return orderedNodes.toArray(new FeatureTreeNode[0]);
    }

    @Override
    protected void runPreProcessing(CNFFormula cnf) {
        this.featureModel.resetNodesAttachedData();
        for (PropositionalFormula pf : this.featureModel.getConstraints()) {
            for (CNFClause cnfClause : pf.toCNFClauses()) {
                CNFClause createdClause = new CNFClause();
                FeatureTreeNode node = this.createClause(cnfClause, createdClause);
                if (createdClause.countVariables() <= 1) continue;
                Vector<CNFClause> nodeAttachedList = (Vector<CNFClause>)node.getAttachedData();
                if (nodeAttachedList == null) {
                    nodeAttachedList = new Vector<CNFClause>();
                    node.attachData(nodeAttachedList);
                }
                nodeAttachedList.add(createdClause);
            }
        }
    }

    protected FeatureTreeNode createClause(CNFClause clause, CNFClause returnClause) {
        boolean bl;
        int index;
        FeatureTreeNode ancestorNode;
        Vector ancestorsList = new Vector();
        for (BooleanVariableInterface var : clause.getVariables()) {
            ArrayList<FeatureTreeNode> arrayList = new ArrayList<FeatureTreeNode>();
            FeatureTreeNode node = this.featureModel.getNodeByID(var.getID());
            if (node == null) continue;
            arrayList.add(0, node);
            for (ancestorNode = (FeatureTreeNode)node.getParent(); ancestorNode != null; ancestorNode = (FeatureTreeNode)ancestorNode.getParent()) {
                arrayList.add(0, ancestorNode);
            }
            ancestorsList.add(arrayList);
        }
        int minSize = Integer.MAX_VALUE;
        for (List list : ancestorsList) {
            int listSize = list.size();
            if (listSize >= minSize) continue;
            minSize = listSize;
        }
        FeatureTreeNode commonAncestor = null;
        boolean bl2 = false;
        for (index = 0; index < minSize && !bl; ++index) {
            ancestorNode = null;
            for (List list : ancestorsList) {
                FeatureTreeNode tempNode = (FeatureTreeNode)list.get(index);
                if (ancestorNode == null) {
                    ancestorNode = tempNode;
                    continue;
                }
                if (tempNode == ancestorNode) continue;
                bl = true;
            }
            if (bl) continue;
            commonAncestor = ancestorNode;
        }
        LinkedHashSet<BooleanVariable> variables = new LinkedHashSet<BooleanVariable>();
        for (List list : ancestorsList) {
            if (list.size() < index) continue;
            variables.add(new BooleanVariable(((FeatureTreeNode)list.get(index - 1)).getID()));
        }
        if (variables.size() > 1) {
            for (BooleanVariableInterface booleanVariableInterface : variables) {
                returnClause.addLiteral(new CNFLiteral(booleanVariableInterface, true));
            }
        }
        return commonAncestor;
    }
}

