/*
 * Decompiled with CFR 0.152.
 */
package splar.plugins.configuration.bdd.javabdd;

import au.com.bytecode.opencsv.CSVReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureTreeNode;
import splar.core.fm.configuration.ConfigurationEngine;
import splar.core.fm.configuration.ConfigurationEngineException;
import splar.core.fm.configuration.ConfigurationStep;
import splar.core.heuristics.FTPreOrderTraversalHeuristic;
import splar.core.heuristics.VariableOrderingHeuristic;
import splar.core.heuristics.VariableOrderingHeuristicsManager;
import splar.plugins.configuration.bdd.javabdd.catalog.Product;
import splar.plugins.configuration.bdd.javabdd.catalog.ProductCatalog;
import splar.plugins.configuration.bdd.javabdd.catalog.ProductComponent;
import splar.plugins.reasoners.bdd.javabdd.FMReasoningWithBDD;

public class BDDConfigurationEngine
extends ConfigurationEngine {
    protected ProductCatalog productCatalog = null;
    protected FMReasoningWithBDD reasoner = null;
    protected int bddNodeNum;
    protected int bddCacheSize;
    protected String loadFromFilePath = null;
    protected String loadFromFileFileName = null;

    public BDDConfigurationEngine(String featureModelURL, String loadFromFilePath, String loadFromFileFileName) throws ConfigurationEngineException {
        super(featureModelURL);
        this.initParameters();
        this.loadFromFilePath = loadFromFilePath;
        this.loadFromFileFileName = loadFromFileFileName;
    }

    public BDDConfigurationEngine(String featureModelURL) throws ConfigurationEngineException {
        super(featureModelURL);
        this.initParameters();
    }

    public BDDConfigurationEngine(String featureModelURL, int bddNodeNum, int bddCacheSize) throws ConfigurationEngineException {
        super(featureModelURL);
        this.bddNodeNum = bddNodeNum;
        this.bddCacheSize = bddCacheSize;
    }

    public BDDConfigurationEngine(FeatureModel model) throws ConfigurationEngineException {
        super(model);
        this.initParameters();
    }

    protected void initParameters() {
        this.bddCacheSize = this.bddNodeNum = this.model.countFeatures() * 100;
    }

    public ProductCatalog getCatalog() {
        return this.productCatalog;
    }

    public void addProductCatalog(String csvCatalogFilePath) throws ConfigurationEngineException {
        try {
            FeatureModel featureModel = this.getModel();
            this.productCatalog = new ProductCatalog(featureModel);
            CSVReader reader = new CSVReader((Reader)new FileReader(csvCatalogFilePath));
            String[] header = reader.readNext();
            for (int i = 2; i < header.length; ++i) {
                if (header[i].startsWith("(") || header[i].startsWith("$") || this.productCatalog.containsComponent(header[i].trim())) continue;
                throw new ConfigurationEngineException("Error: Feature model '" + featureModel.getName() + "' does not contain component: '" + header[i] + "' referenced by a product in file '" + csvCatalogFilePath + "'");
            }
            String[] nextLine = reader.readNext();
            while (nextLine != null) {
                Product product = new Product(this.productCatalog, this.createProductId(nextLine[0].trim()), nextLine[1].trim());
                for (int i = 2; i < nextLine.length; ++i) {
                    if (header[i].startsWith("$")) {
                        product.addAttribute(header[i].substring(1).trim(), nextLine[i].trim());
                        continue;
                    }
                    if (header[i].startsWith("(")) continue;
                    String componentType = nextLine[i].trim();
                    if (componentType.length() > 0) {
                        product.addComponent(header[i], BDDConfigurationEngine.genID(header[i].trim(), componentType));
                        continue;
                    }
                    product.addComponent(header[i].trim(), "");
                }
                this.productCatalog.addProduct(product);
                nextLine = reader.readNext();
            }
            reader.close();
        }
        catch (IOException e2) {
            throw new ConfigurationEngineException("Error reading CSV file for creating BDD configuration engine", e2);
        }
        catch (Exception e3) {
            throw new ConfigurationEngineException("Error creating BDD configuration engine.", e3);
        }
    }

    private String createProductId(String productId) {
        String suffix = "abcdefghijklmnopqrsvwxyz";
        String id = productId;
        int counter = 0;
        while (this.productCatalog.containsProduct(id)) {
            id = productId + "-" + suffix.substring(counter, counter + 1);
            ++counter;
        }
        return id;
    }

    public static String genID(String header, String name) {
        String lex = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_";
        for (int i = 0; i < name.length(); ++i) {
            if (lex.indexOf(name.charAt(i)) != -1) continue;
            name = name.replace(name.charAt(i), '_');
        }
        return ("_" + header + "_" + name).toLowerCase();
    }

    public FMReasoningWithBDD getReasoner() {
        return this.reasoner;
    }

    protected void createReasoner() throws ConfigurationEngineException {
        try {
            new FTPreOrderTraversalHeuristic("_BDDVarOrderHeuristic2", this.getModel());
            VariableOrderingHeuristic heuristic = VariableOrderingHeuristicsManager.createHeuristicsManager().getHeuristic("_BDDVarOrderHeuristic2");
            if (this.loadFromFilePath != null) {
                this.reasoner = new FMReasoningWithBDD(this.getModel(), heuristic, this.bddNodeNum, this.bddCacheSize, 60000L, "pre-order");
                this.reasoner.init(this.loadFromFilePath, this.loadFromFileFileName);
            } else {
                this.reasoner = new FMReasoningWithBDD(this.getModel(), heuristic, this.bddNodeNum, this.bddCacheSize, 60000L, "pre-order"){

                    @Override
                    protected BDD createBDD(BDDFactory bddFactory, String orderingFormulasStrategy) throws Exception {
                        BDD bdd = super.createBDD(bddFactory, orderingFormulasStrategy);
                        if (BDDConfigurationEngine.this.productCatalog != null && BDDConfigurationEngine.this.productCatalog.getProducts().size() > 0) {
                            BDD catalogBDD = bddFactory.zero();
                            for (Product product : BDDConfigurationEngine.this.productCatalog.getProducts().values()) {
                                BDD productBDD = bddFactory.one();
                                for (String productComponentId : product.getComponents().keySet()) {
                                    String productComponentType = product.getComponent(productComponentId);
                                    ProductComponent concreteComponent = BDDConfigurationEngine.this.productCatalog.getComponent(productComponentId);
                                    for (String componentType : concreteComponent.getTypes()) {
                                        if (componentType.compareToIgnoreCase(productComponentType) == 0) {
                                            productBDD.andWith(bddFactory.ithVar(super.getVariableIndex(componentType).intValue()));
                                            continue;
                                        }
                                        productBDD.andWith(bddFactory.nithVar(super.getVariableIndex(componentType).intValue()));
                                    }
                                }
                                catalogBDD.orWith(productBDD);
                            }
                            return bdd.andWith(catalogBDD);
                        }
                        return bdd;
                    }
                };
                this.reasoner.init();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationEngineException("Problems creating BDD reasoner for interactive configuration", e);
        }
    }

    @Override
    protected int getVariableIndex(String varName) {
        return this.reasoner.getVariableIndex(varName);
    }

    @Override
    protected String getVariableName(int varIndex) {
        return this.reasoner.getVariableName(varIndex);
    }

    @Override
    protected ConfigurationStep resetConfiguration() throws ConfigurationEngineException {
        try {
            this.createReasoner();
            this.createConfigurationStep(this.model.getRoot().getID(), 1, "propagated");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationEngineException("Problems reseting configuration", e);
        }
        return this.getLastStep();
    }

    @Override
    protected Map<String, Boolean[]> createConfigurationStep(String featureId, int featureValue, String decisionType) throws Exception {
        Map<String, Boolean[]> domainTable = null;
        long start = System.currentTimeMillis();
        String stateName = "bdd_state_" + (this.steps.size() + 1);
        this.reasoner.saveState(stateName);
        this.reasoner.restrict(featureId, featureValue == 1);
        domainTable = super.createConfigurationStep(featureId, featureValue, decisionType);
        ConfigurationStep newConfStep = this.getLastStep();
        newConfStep.addAttribute("step_Stat", "" + this.reasoner.getBDD().nodeCount());
        newConfStep.addAttribute("step_runTime", "" + (System.currentTimeMillis() - start));
        return domainTable;
    }

    @Override
    public ConfigurationStep autoComplete(boolean valueOrder) throws ConfigurationEngineException {
        return null;
    }

    @Override
    protected Map<String, Boolean[]> computeValidDomains() throws ConfigurationEngineException {
        try {
            return this.reasoner.allValidDomains(new HashMap<String, String>());
        }
        catch (Exception e) {
            throw new ConfigurationEngineException(e);
        }
    }

    @Override
    public List<FeatureTreeNode> detectConflicts(String featureId) throws ConfigurationEngineException {
        return null;
    }

    @Override
    public List<ConfigurationStep> toggleDecision(String featureId) throws ConfigurationEngineException {
        return null;
    }

    @Override
    public List<ConfigurationStep> undo(int undoStep) throws ConfigurationEngineException {
        try {
            if (undoStep > 1 && undoStep <= this.steps.size()) {
                for (int i = undoStep + 1; i <= this.steps.size(); ++i) {
                    this.reasoner.discardState("bdd_state_" + i);
                }
                this.reasoner.restoreState("bdd_state_" + undoStep);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationEngineException("Problems undoing configuration step " + undoStep, e);
        }
        return super.undo(undoStep);
    }
}

