/*
 * Decompiled with CFR 0.152.
 */
package splar.plugins.configuration.bdd.javabdd.catalog;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureTreeNode;
import splar.core.fm.GroupedFeature;
import splar.plugins.configuration.bdd.javabdd.catalog.Product;
import splar.plugins.configuration.bdd.javabdd.catalog.ProductComponent;

public class ProductCatalog {
    protected FeatureModel featureModel;
    protected Map<String, ProductComponent> concreteComponents;
    protected Map<String, Product> products;

    public ProductCatalog(FeatureModel featureModel) {
        this.featureModel = featureModel;
        this.concreteComponents = new HashMap<String, ProductComponent>();
        this.products = new LinkedHashMap<String, Product>();
        this.extractComponentsFromFeatureModel(featureModel.getRoot());
    }

    public boolean containsComponent(String componentID) {
        return this.concreteComponents.containsKey(componentID);
    }

    public boolean containsProduct(String productId) {
        return this.products.containsKey(productId);
    }

    public ProductComponent getComponent(String componentID) {
        return this.concreteComponents.get(componentID);
    }

    public Map<String, Product> getProducts() {
        return this.products;
    }

    public Map<String, ProductComponent> getComponents() {
        return this.concreteComponents;
    }

    public List<Product> filterProductsBasedOnFeatureModelSelection() {
        LinkedList<Product> filteredProducts = new LinkedList<Product>();
        filteredProducts.addAll(this.products.values());
        for (ProductComponent component : this.concreteComponents.values()) {
            for (String componentType : component.getTypes()) {
                FeatureTreeNode featureNode = this.featureModel.getNodeByID(componentType);
                if (!featureNode.isInstantiated()) continue;
                Iterator it = filteredProducts.iterator();
                while (it.hasNext()) {
                    Product product = (Product)it.next();
                    String productComponentType = product.getComponent(component.getID());
                    try {
                        if (featureNode.getValue() == 1 && componentType.compareToIgnoreCase(productComponentType) != 0) {
                            it.remove();
                            continue;
                        }
                        if (featureNode.getValue() != 0 || componentType.compareToIgnoreCase(productComponentType) != 0) continue;
                        it.remove();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return filteredProducts;
    }

    protected void extractComponentsFromFeatureModel(FeatureTreeNode featureNode) {
        if (featureNode.isLeaf() && this.getParentNode(featureNode) != null) {
            String componentKey = this.getParentNode(featureNode).getID();
            String componentName = this.getParentNode(featureNode).getName();
            ProductComponent component = this.concreteComponents.get(componentKey);
            if (component == null) {
                component = new ProductComponent(componentKey, componentName);
                this.concreteComponents.put(componentKey, component);
            }
            component.addComponentType(featureNode.getID());
        }
        for (int i = 0; i < featureNode.getChildCount(); ++i) {
            this.extractComponentsFromFeatureModel((FeatureTreeNode)featureNode.getChildAt(i));
        }
    }

    protected FeatureTreeNode getParentNode(FeatureTreeNode featureNode) {
        if (featureNode instanceof GroupedFeature) {
            return (FeatureTreeNode)featureNode.getParent().getParent();
        }
        return (FeatureTreeNode)featureNode.getParent();
    }

    public void addProduct(Product product) throws Exception {
        this.products.put(product.getID(), product);
    }

    public String toString() {
        String toString = "Product Catalog: " + this.featureModel.getName() + " [" + this.concreteComponents.size() + " components, " + this.products.size() + " products]----------------- \r\n";
        toString = toString + "- Concrete Components \r\n";
        for (ProductComponent component : this.concreteComponents.values()) {
            toString = toString + component.toString();
            toString = toString + "\r\n";
        }
        toString = toString + "- Products ------ \r\n";
        for (Product product : this.products.values()) {
            toString = toString + product.toString();
            toString = toString + "\r\n";
        }
        return toString;
    }
}

