/*
 * Decompiled with CFR 0.152.
 */
package splar.plugins.reasoners.bdd.javabdd;

import java.util.ArrayList;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;
import splar.plugins.reasoners.bdd.javabdd.BDDGenerationStatisticsRecord;

public class BDDGenerationStatistics {
    private ArrayList<BDDGenerationStatisticsRecord> stats = new ArrayList();
    private double pathCount = -1.0;
    private int bvoIndex = -1;
    private int wvoIndex = -1;
    private double wvoCountNodes = -1.0;
    private double bvoCountNodes = 2.147483647E9;
    private int index = 0;

    public BDDGenerationStatistics(int countVars) {
    }

    public void addStats(BDDFactory bddFactory, BDD bdd, String[] varOrder) {
        int bddNodeCount;
        if (this.pathCount == -1.0) {
            this.pathCount = bdd.pathCount();
        }
        if ((double)(bddNodeCount = bdd.nodeCount()) < this.bvoCountNodes) {
            this.bvoCountNodes = bddNodeCount;
            this.bvoIndex = this.index;
        }
        if ((double)bddNodeCount > this.wvoCountNodes) {
            this.wvoCountNodes = bddNodeCount;
            this.wvoIndex = this.index;
        }
        this.stats.add(this.index, new BDDGenerationStatisticsRecord(bddFactory, bdd, varOrder, bddNodeCount));
        ++this.index;
    }

    public int countStats() {
        return this.stats.size();
    }

    public BDD getBDD(int index) {
        return this.stats.get((int)index).bdd;
    }

    public double getPathsCount() {
        return this.pathCount;
    }

    public String[] getVariableOrder(int index) {
        return this.stats.get((int)index).varOrder;
    }

    public double getNodesCount(int index) {
        return this.stats.get((int)index).nodesCount;
    }

    public int getBestVariableOrderIndex() {
        return this.bvoIndex;
    }

    public int getWorstVariableOrderIndex() {
        return this.wvoIndex;
    }
}

