/*
 * Decompiled with CFR 0.152.
 */
package splar.plugins.reasoners.bdd.javabdd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.javabdd.BDD;
import splar.core.constraints.Assignment;
import splar.core.constraints.BooleanVariable;

public class BDDSolutionsIterator<T>
implements Iterator<T> {
    private Iterator bit;
    private String[] index2varMap;
    private List<Assignment> assignments;
    private Assignment assignmentDC;
    int j = 0;

    public BDDSolutionsIterator(BDD bdd, String[] index2varMap) {
        this.bit = bdd.allsat();
        this.index2varMap = index2varMap;
        this.assignments = new ArrayList<Assignment>();
        this.assignmentDC = new Assignment();
    }

    @Override
    public boolean hasNext() {
        if (this.assignments.size() == 0 && !this.bit.hasNext()) {
            return false;
        }
        if (this.assignments.size() == 0) {
            this.expandAssignments((byte[])this.bit.next());
        }
        return true;
    }

    @Override
    public T next() {
        Assignment next = null;
        if (this.hasNext()) {
            next = this.assignments.get(0);
            this.assignments.remove(0);
        }
        return (T)next;
    }

    public boolean hasNextSol() {
        return this.bit.hasNext();
    }

    public T nextSol() {
        if (this.hasNextSol()) {
            this.expandAssignmentSol();
            return (T)this.assignmentDC;
        }
        return null;
    }

    @Override
    public void remove() {
    }

    private void expandAssignments(byte[] bb) {
        this.assignments.clear();
        this.assignments.add(new Assignment());
        for (int i = 0; i < bb.length; ++i) {
            if (bb[i] != -1) {
                for (Assignment as : this.assignments) {
                    BooleanVariable va = new BooleanVariable(this.index2varMap[i], bb[i]);
                    as.add(va);
                }
                continue;
            }
            ArrayList<Assignment> tempAssign = new ArrayList<Assignment>();
            for (Assignment as1 : this.assignments) {
                Assignment as2 = (Assignment)as1.clone();
                as1.add(new BooleanVariable(this.index2varMap[i], 0));
                as2.add(new BooleanVariable(this.index2varMap[i], 1));
                tempAssign.add(as2);
            }
            this.assignments.addAll(tempAssign);
        }
        if (this.assignments.get(0).size() == 0) {
            this.assignments.clear();
        }
    }

    private void expandAssignmentSol() {
        byte[] bb = (byte[])this.bit.next();
        this.assignmentDC.clear();
        for (int i = 0; i < bb.length; ++i) {
            if (bb[i] == -1) continue;
            this.assignmentDC.add(new BooleanVariable(this.index2varMap[i], bb[i]));
        }
    }
}

