/*
 * Decompiled with CFR 0.152.
 */
package splar.plugins.reasoners.bdd.javabdd;

import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;
import splar.core.constraints.CNFClause;
import splar.core.constraints.CNFFormula;
import splar.core.constraints.CNFLiteral;
import splar.core.constraints.PropositionalFormula;
import splar.core.fm.FeatureGroup;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureTreeNode;
import splar.core.fm.SolitaireFeature;
import splar.core.fm.clustering.FeatureModelClustersManager;
import splar.core.fm.clustering.NodeCluster;
import splar.core.heuristics.VariableOrderingHeuristic;
import splar.plugins.reasoners.bdd.javabdd.BDDExceededBuildingTimeException;
import splar.plugins.reasoners.bdd.javabdd.FTReasoningWithBDD;
import splar.plugins.reasoners.bdd.javabdd.PF2BDDParser;

public class FMReasoningWithBDD
extends FTReasoningWithBDD {
    public FMReasoningWithBDD(FeatureModel featureModel, VariableOrderingHeuristic voHeuristic, int nodeNum, int cacheSize, long maxBuildingtime, String orderingFormulasStrategy) {
        this(featureModel, voHeuristic, nodeNum, cacheSize, maxBuildingtime, BDDFactory.REORDER_NONE, orderingFormulasStrategy);
    }

    public FMReasoningWithBDD(FeatureModel featureModel, VariableOrderingHeuristic voHeuristic, int nodeNum, int cacheSize, long maxBuildingtime, BDDFactory.ReorderMethod reorderMethod, String orderingFormulasStrategy) {
        super(featureModel, voHeuristic, nodeNum, cacheSize, maxBuildingtime, reorderMethod, orderingFormulasStrategy);
    }

    @Override
    protected BDD createBDDStructure(long startTime, String orderingFormulasStrategy) throws BDDExceededBuildingTimeException {
        BDD bdd = null;
        if (orderingFormulasStrategy.compareToIgnoreCase("pre-order-cluster") == 0) {
            FeatureModelClustersManager clustersManager = new FeatureModelClustersManager(this.featureModel);
            clustersManager.createClusters();
            bdd = this.preOrderClusterFormulaOrdering(clustersManager, this.featureModel.getRoot(), startTime);
        } else {
            long start = System.nanoTime();
            bdd = super.createBDDStructure(startTime, orderingFormulasStrategy);
            long end = System.nanoTime();
            start = System.nanoTime();
            for (PropositionalFormula pf : this.featureModel.getConstraints()) {
                String formula = pf.getFormula();
                if (formula == null || formula.trim().length() <= 0) continue;
                long maxParsingTime = startTime + this.maxBuildingTime - System.currentTimeMillis();
                PF2BDDParser parser = new PF2BDDParser(this.bddFactory, this.varName2IndexMap, maxParsingTime);
                try {
                    BDD tempBDD = parser.parse(formula);
                    if (tempBDD == null) continue;
                    bdd.andWith(tempBDD);
                }
                catch (Exception e) {}
            }
            end = System.nanoTime();
        }
        return bdd;
    }

    protected BDD preOrderClusterFormulaOrdering(FeatureModelClustersManager clustersManager, FeatureTreeNode curNode, long startTime) throws BDDExceededBuildingTimeException {
        BDD bdd = this.bddFactory.one();
        BDD parentNodeBDD = this.bddFactory.ithVar(((Integer)this.varName2IndexMap.get(curNode.getID())).intValue());
        int count = curNode.getChildCount();
        if (count > 0) {
            BDD childBDD = null;
            for (int i = 0; i < count; ++i) {
                FeatureTreeNode childNode = (FeatureTreeNode)curNode.getChildAt(i);
                if (childNode instanceof SolitaireFeature) {
                    SolitaireFeature solitaireNode = (SolitaireFeature)childNode;
                    childBDD = this.bddFactory.ithVar(((Integer)this.varName2IndexMap.get(childNode.getID())).intValue());
                    if (solitaireNode.isOptional()) {
                        bdd.andWith(childBDD.imp(parentNodeBDD.id()));
                    } else {
                        bdd.andWith(childBDD.biimp(parentNodeBDD.id()));
                    }
                    BDD subtreeBDD = this.preOrderClusterFormulaOrdering(clustersManager, childNode, startTime);
                    bdd.andWith(subtreeBDD);
                    continue;
                }
                if (childNode instanceof FeatureGroup) {
                    FeatureGroup fGroup = (FeatureGroup)childNode;
                    BDD fgBDD = this.createFeatureGroupBDDStructure(parentNodeBDD.id(), fGroup, null, this.bddFactory, startTime);
                    bdd.andWith(fgBDD);
                    for (int j = 0; j < fGroup.getChildCount(); ++j) {
                        FeatureTreeNode groupedNode = (FeatureTreeNode)fGroup.getChildAt(j);
                        BDD subtreeBDD = this.preOrderClusterFormulaOrdering(clustersManager, groupedNode, startTime);
                        bdd.andWith(subtreeBDD);
                    }
                    continue;
                }
                System.out.println("Error: Other type of node!");
            }
        }
        for (NodeCluster cluster : clustersManager.sortClusterAscendingOrder(curNode)) {
            if (cluster.getECClauses() == null) continue;
            long start = System.nanoTime();
            System.out.println(">>>>>  Generating BDD for Extra Constraint relations..." + curNode.getID());
            for (CNFClause clause : cluster.getECClauses()) {
                BDD clauseBDD = this.bddFactory.zero();
                for (CNFLiteral literal : clause.getLiterals()) {
                    if (literal.isPositive()) {
                        clauseBDD.orWith(this.bddFactory.ithVar(((Integer)this.varName2IndexMap.get(literal.getVariable().getID())).intValue()));
                        continue;
                    }
                    clauseBDD.orWith(this.bddFactory.nithVar(((Integer)this.varName2IndexMap.get(literal.getVariable().getID())).intValue()));
                }
                bdd.andWith(clauseBDD);
            }
            long end = System.nanoTime();
            System.out.println(">>>>>  Done Generating BDD for Extra Constraint relations..." + curNode.getID() + " (" + (double)(end - start) / 1000000.0 + "ms)");
        }
        return bdd;
    }

    @Override
    protected CNFFormula toCNF() {
        return this.featureModel.FM2CNF();
    }
}

