/*
 * Decompiled with CFR 0.152.
 */
package splar.plugins.reasoners.bdd.javabdd;

import java.util.ArrayList;
import java.util.Map;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;
import splar.core.constraints.BooleanVariable;
import splar.core.constraints.BooleanVariableInterface;
import splar.plugins.reasoners.bdd.javabdd.BDDExceededBuildingTimeException;

public class PF2BDDParser {
    private long maxParsingTimeAllowed;
    private long parsingTime;
    private int index = 0;
    private static final int AND = 1;
    private static final int OR = 2;
    private static final int IMP = 3;
    private static final int BIIMP = 4;
    private static String letters = "_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static String digits = "0123456789";
    private static String others = "_";
    private String all = letters + digits + others;
    private BDDFactory bddFactory;
    protected Map<String, Integer> variable2indexMap;
    protected ArrayList<BooleanVariableInterface> variables;

    public PF2BDDParser(BDDFactory bddFactory, Map<String, Integer> variable2indexMap, long maxParsingTimeAllowed) {
        this.bddFactory = bddFactory;
        this.variable2indexMap = variable2indexMap;
        this.variables = new ArrayList();
        this.maxParsingTimeAllowed = maxParsingTimeAllowed;
        this.parsingTime = -1L;
    }

    public long getPFParsingTime() {
        return this.parsingTime;
    }

    public BDD parse(String formula) throws Exception {
        this.index = 0;
        long start = System.currentTimeMillis();
        BDD bdd = this.F(formula.trim(), start);
        this.parsingTime = System.currentTimeMillis() - start;
        return bdd;
    }

    private String currentChar(String formula) {
        return formula.substring(this.index, this.index + 1);
    }

    private BDD F(String formula, long start) throws Exception {
        BDD bdd = this.bddFactory.one();
        long elapsedTime = System.currentTimeMillis() - start;
        if (elapsedTime > this.maxParsingTimeAllowed) {
            throw new BDDExceededBuildingTimeException("PF2BDDParser: Maximum time allowed for BDD construction exceeded: " + this.maxParsingTimeAllowed + " ms", "");
        }
        if (!this.EOF(formula)) {
            if (this.currentChar(formula).equals("~")) {
                BDD tempBDD1;
                this.incrementIndex(formula);
                this.skipBlanks(formula);
                if (this.isLetter(this.currentChar(formula))) {
                    int varIndex = this.extractVar(formula, false);
                    if (varIndex == -1) {
                        throw new Exception("Error on formula: " + formula + " at index (" + this.index + ")");
                    }
                    tempBDD1 = this.bddFactory.ithVar(varIndex);
                } else {
                    tempBDD1 = this.F(formula, start);
                }
                tempBDD1 = tempBDD1.not();
                this.skipBlanks(formula);
                if (!this.EOF(formula)) {
                    if (this.isLetter(this.currentChar(formula)) || this.currentChar(formula).equals("&") || this.currentChar(formula).equals("|") || this.currentChar(formula).equals("-") || this.currentChar(formula).equals("<")) {
                        int op = this.operator(formula);
                        this.skipBlanks(formula);
                        BDD tempBDD2 = this.F(formula, start);
                        bdd.andWith(this.applyBDDOp(tempBDD1, tempBDD2, op, start));
                    } else {
                        bdd.andWith(tempBDD1);
                    }
                } else {
                    bdd.andWith(tempBDD1);
                }
            } else if (this.currentChar(formula).equals("(")) {
                this.incrementIndex(formula);
                this.skipBlanks(formula);
                BDD tempBDD1 = this.F(formula, start);
                if (!this.currentChar(formula).equals(")")) {
                    throw new Exception("Error on formula: " + formula + " at index (" + this.index + ")");
                }
                this.incrementIndex(formula);
                if (!this.EOF(formula)) {
                    this.skipBlanks(formula);
                    if (this.isLetter(this.currentChar(formula)) || this.currentChar(formula).equals("&") || this.currentChar(formula).equals("|") || this.currentChar(formula).equals("-") || this.currentChar(formula).equals("<")) {
                        int op = this.operator(formula);
                        this.skipBlanks(formula);
                        BDD tempBDD2 = this.F(formula, start);
                        bdd.andWith(this.applyBDDOp(tempBDD1, tempBDD2, op, start));
                    } else {
                        if (!this.currentChar(formula).equals(")")) {
                            throw new Exception("Error on formula: " + formula + " at index (" + this.index + ")");
                        }
                        bdd.andWith(tempBDD1);
                    }
                } else {
                    bdd.andWith(tempBDD1);
                }
            } else {
                int varIndex = this.extractVar(formula, true);
                if (varIndex == -1) {
                    throw new Exception("Error on formula: " + formula + " at index (" + this.index + ")");
                }
                BDD tempBDD1 = this.bddFactory.ithVar(varIndex);
                this.skipBlanks(formula);
                if (!this.EOF(formula) && !this.currentChar(formula).startsWith(")")) {
                    int op = this.operator(formula);
                    this.skipBlanks(formula);
                    BDD tempBDD2 = this.F(formula, start);
                    bdd.andWith(this.applyBDDOp(tempBDD1, tempBDD2, op, start));
                } else {
                    bdd.andWith(tempBDD1);
                }
            }
        }
        return bdd;
    }

    private BDD applyBDDOp(BDD bdd1, BDD bdd2, int op, long start) throws Exception {
        long elapsedTime = System.currentTimeMillis() - start;
        if (elapsedTime > this.maxParsingTimeAllowed) {
            throw new BDDExceededBuildingTimeException("PF2BDDParser: Maximum time allowed for BDD construction exceeded: " + this.maxParsingTimeAllowed + " ms", "");
        }
        BDD resultBDD = this.bddFactory.one();
        switch (op) {
            case 1: {
                resultBDD.andWith(bdd1.and(bdd2));
                break;
            }
            case 2: {
                resultBDD.andWith(bdd1.or(bdd2));
                break;
            }
            case 3: {
                resultBDD.andWith(bdd1.imp(bdd2));
                break;
            }
            case 4: {
                resultBDD.andWith(bdd1.biimp(bdd2));
            }
        }
        return resultBDD;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int operator(String formula) throws Exception {
        int op = -1;
        if (this.isLetter(this.currentChar(formula))) {
            String opStr = this.extractOperator(formula);
            if (opStr.compareToIgnoreCase("and") == 0) {
                return 1;
            }
            if (opStr.compareToIgnoreCase("or") == 0) {
                return 2;
            }
            if (opStr.compareToIgnoreCase("imp") == 0) {
                return 3;
            }
            if (opStr.compareToIgnoreCase("biimp") != 0) throw new Exception("Error on formula: " + formula + " at index (" + this.index + ")");
            return 4;
        }
        if (this.currentChar(formula).startsWith("|")) {
            this.incrementIndex(formula);
            return 2;
        }
        if (this.currentChar(formula).startsWith("&")) {
            this.incrementIndex(formula);
            return 1;
        }
        if (this.currentChar(formula).startsWith("-")) {
            this.incrementIndex(formula);
            if (!this.currentChar(formula).startsWith(">")) {
                throw new Exception("Error on formula: " + formula + " at index (" + this.index + ")");
            }
            this.incrementIndex(formula);
            return 3;
        }
        if (!this.currentChar(formula).startsWith("<")) throw new Exception("Error on formula: " + formula + " at index (" + this.index + ")");
        this.incrementIndex(formula);
        if (!this.currentChar(formula).startsWith("-")) {
            throw new Exception("Error on formula: " + formula + " at index (" + this.index + ")");
        }
        this.incrementIndex(formula);
        if (!this.currentChar(formula).startsWith(">")) {
            throw new Exception("Error on formula: " + formula + " at index (" + this.index + ")");
        }
        this.incrementIndex(formula);
        return 4;
    }

    private String extractOperator(String formula) {
        StringBuffer opName = new StringBuffer();
        if (this.isLetter(this.currentChar(formula))) {
            opName.append(this.currentChar(formula));
            this.incrementIndex(formula);
            while (!this.EOF(formula) && this.isValidChar(this.currentChar(formula))) {
                opName.append(this.currentChar(formula));
                this.incrementIndex(formula);
            }
        }
        return opName.toString();
    }

    private int extractVar(String formula, boolean varState) {
        StringBuffer varName = new StringBuffer();
        if (this.isLetter(this.currentChar(formula))) {
            varName.append(this.currentChar(formula));
            this.incrementIndex(formula);
            while (!this.EOF(formula) && this.isValidChar(this.currentChar(formula))) {
                varName.append(this.currentChar(formula));
                this.incrementIndex(formula);
            }
            int index = this.createVarIndex(varName.toString());
            if (index != -1) {
                BooleanVariable variable = new BooleanVariable(varName.toString());
                variable.setState(varState);
                this.variables.add(variable);
            }
            return index;
        }
        return -1;
    }

    public ArrayList<BooleanVariableInterface> getVariables() {
        return this.variables;
    }

    private int createVarIndex(String varName) {
        Integer index = this.variable2indexMap.get(varName);
        if (index != null) {
            return index;
        }
        return -1;
    }

    private boolean EOF(String formula) {
        return this.index >= formula.length();
    }

    private boolean isLetter(String str) {
        return letters.indexOf(str) != -1;
    }

    private boolean isValidChar(String str) {
        return this.all.indexOf(str) != -1;
    }

    private void skipBlanks(String formula) {
        if (!this.EOF(formula)) {
            while (this.currentChar(formula).startsWith(" ")) {
                this.incrementIndex(formula);
            }
        }
    }

    private void incrementIndex(String formula) {
        ++this.index;
    }
}

