/*
 * Decompiled with CFR 0.152.
 */
package splar.plugins.reasoners.bdd.javabdd;

import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;
import net.sf.javabdd.JFactory;
import splar.core.constraints.Assignment;
import splar.core.fm.reasoning.FMReasoningInterface;
import splar.core.heuristics.VariableOrderingHeuristic;
import splar.plugins.reasoners.bdd.javabdd.BDDSolutionsIterator;
import splar.plugins.reasoners.bdd.javabdd.ReasoningWithBDDState;

public abstract class ReasoningWithBDD
extends FMReasoningInterface {
    protected BDDFactory bddFactory;
    protected BDD theOriginalBDD;
    protected BDD theWorkingBDD;
    protected int nodeNum;
    protected int cacheSize;
    protected BDDFactory.ReorderMethod reorderMethod;
    protected VariableOrderingHeuristic variableOrderingHeuristic;
    protected long maxBuildingTime;
    protected long heuristicRunningTime;
    protected long bddBuildingTime;
    protected Map<String, ReasoningWithBDDState> states;
    protected int[] variables = null;
    protected boolean newAssignmentsMade = false;
    protected String orderingFormulasStrategy;

    public ReasoningWithBDD(VariableOrderingHeuristic voHeuristic, int nodeNum, int cacheSize, long maxBuildingTime, BDDFactory.ReorderMethod reorderMethod, String orderingFormulasStrategy) {
        this.variableOrderingHeuristic = voHeuristic;
        this.nodeNum = nodeNum;
        this.cacheSize = cacheSize;
        this.reorderMethod = reorderMethod;
        this.states = new LinkedHashMap<String, ReasoningWithBDDState>();
        this.maxBuildingTime = maxBuildingTime;
        this.heuristicRunningTime = -1L;
        this.bddBuildingTime = -1L;
        this.orderingFormulasStrategy = orderingFormulasStrategy;
        this.bddFactory = JFactory.init((int)nodeNum, (int)cacheSize);
    }

    public ReasoningWithBDD(VariableOrderingHeuristic voHeuristic, int nodeNum, int cacheSize, long maxBuildingTime, BDDFactory.ReorderMethod reorderMethod) {
        this(voHeuristic, nodeNum, cacheSize, maxBuildingTime, reorderMethod, "undefined");
    }

    protected void initBDDReorder(int countNodes) {
        if (this.reorderMethod != BDDFactory.REORDER_NONE) {
            this.bddFactory.enableReorder();
            this.bddFactory.autoReorder(this.reorderMethod);
            if (this.reorderMethod == BDDFactory.REORDER_SIFT || this.reorderMethod == BDDFactory.REORDER_SIFTITE || this.reorderMethod == BDDFactory.REORDER_RANDOM) {
                for (int i = 0; i < countNodes; ++i) {
                    this.bddFactory.addVarBlock(this.bddFactory.ithVar(i), false);
                }
            }
        }
    }

    @Override
    public void init() throws Exception {
        this.clearStates();
        this.theOriginalBDD = this.createBDD(this.bddFactory, this.orderingFormulasStrategy);
        this.theWorkingBDD = this.theOriginalBDD.id();
        if (this.variables == null) {
            this.variables = this.initVars(this.theOriginalBDD.getFactory().varNum());
        }
    }

    public void init(String stateFilePath, String stateFileName) throws Exception {
        long start = System.currentTimeMillis();
        this.clearStates();
        this.theOriginalBDD = this.bddFactory.load(stateFilePath + stateFileName + ".bdd");
        this.theWorkingBDD = this.theOriginalBDD.id();
        LineNumberReader reader = new LineNumberReader(new FileReader(stateFilePath + stateFileName + ".keys"));
        int lineNum = 0;
        String line = reader.readLine();
        this.varName2IndexMap = new HashMap();
        while (line != null) {
            this.varName2IndexMap.put(line, lineNum++);
            line = reader.readLine();
        }
        reader.close();
        this.varIndex2NameMap = new String[this.varName2IndexMap.size()];
        Iterator i$ = this.varName2IndexMap.keySet().iterator();
        while (i$.hasNext()) {
            String varName;
            this.varIndex2NameMap[((Integer)this.varName2IndexMap.get((Object)varName)).intValue()] = varName = (String)i$.next();
        }
        this.variables = this.initVars(this.theOriginalBDD.getFactory().varNum());
        this.bddBuildingTime = System.currentTimeMillis() - start;
    }

    public void restoreFromFile(String stateFilePath, String stateFileName) throws Exception {
        this.init(stateFilePath, stateFileName);
    }

    public void saveToFile(String stateFilePath, String stateFileName) throws Exception {
        this.bddFactory.save(stateFilePath + stateFileName + ".bdd", this.theOriginalBDD);
        PrintWriter writer = new PrintWriter(new FileOutputStream(stateFilePath + stateFileName + ".keys"));
        for (int i = 0; i < this.varIndex2NameMap.length; ++i) {
            writer.println(this.varIndex2NameMap[i]);
        }
        writer.close();
    }

    public void clearStates() {
        for (ReasoningWithBDDState state : this.states.values()) {
            state.discard();
        }
        this.states.clear();
    }

    @Override
    public void end() {
    }

    public double getHeuristicRunningTime() {
        return this.variableOrderingHeuristic.getRunningTime();
    }

    public long getBDDBuildingTime() {
        return this.bddBuildingTime;
    }

    public void restrict(String variableID, boolean value) {
        BDD varBDD = value ? this.bddFactory.ithVar(this.getVariableIndex(variableID).intValue()).id() : this.bddFactory.nithVar(this.getVariableIndex(variableID).intValue()).id();
        this.theWorkingBDD.restrictWith(varBDD);
    }

    protected int[] initVars(int numVars) {
        int[] vars = new int[numVars];
        for (int i = 0; i < numVars; ++i) {
            vars[i] = -1;
        }
        return vars;
    }

    protected abstract BDD createBDD(BDDFactory var1, String var2) throws Exception;

    @Override
    public void saveState(String stateID) {
        ReasoningWithBDDState state = new ReasoningWithBDDState(this);
        state.save();
        this.states.put(stateID, state);
    }

    @Override
    public void restoreState(String stateID) {
        ReasoningWithBDDState state = this.states.get(stateID);
        state.restore();
        this.states.remove(stateID);
    }

    @Override
    public void discardState(String stateID) {
        ReasoningWithBDDState state = this.states.get(stateID);
        state.discard();
        this.states.remove(stateID);
    }

    public BDD getBDD() {
        return this.theWorkingBDD;
    }

    public BDDFactory getBDDFactory() {
        return this.bddFactory;
    }

    @Override
    public boolean isConsistent() throws OperationNotSupportedException {
        return !this.theWorkingBDD.isZero();
    }

    @Override
    public double countValidConfigurations() throws OperationNotSupportedException {
        return this.theWorkingBDD.satCount();
    }

    @Override
    public Iterator<Assignment> iterateOverValidConfigurations() throws OperationNotSupportedException {
        return new BDDSolutionsIterator<Assignment>(this.theWorkingBDD, this.varIndex2NameMap);
    }
}

