/*
 * Decompiled with CFR 0.152.
 */
package splar.samples;

import java.util.List;
import splar.core.fm.FeatureGroup;
import splar.core.fm.FeatureTreeNode;
import splar.core.fm.configuration.ConfigurationEngine;
import splar.core.fm.configuration.ConfigurationStep;
import splar.plugins.configuration.sat.sat4j.SATConfigurationEngine;

public class SATConfigurationExample {
    public static void main(String[] args) {
        new SATConfigurationExample().run();
    }

    public void run() {
        try {
            String featureModelURL = "file:///c:\\users\\marcilio\\eclipse\\splar\\resources\\models\\simple_bike_fm.xml";
            SATConfigurationEngine satConfEngine = new SATConfigurationEngine(featureModelURL);
            satConfEngine.reset();
            ConfigurationStep step = satConfEngine.configure("_pedal_pedalb", 1);
            System.out.println("> Feature '" + satConfEngine.getModel().getNodeByID("_pedal_pedalb").getName() + "' has been selected");
            for (FeatureTreeNode propagatedNode : step.getPropagations()) {
                System.out.println("--> Propagated: " + propagatedNode.getName() + " = " + propagatedNode.getValue());
            }
            List<FeatureTreeNode> conflicts = ((ConfigurationEngine)satConfEngine).detectConflicts("_frame_aluminium");
            System.out.println("> Conflicts if feature '" + satConfEngine.getModel().getNodeByID("_frame_aluminium").getName() + "' is toggled");
            if (conflicts.size() == 0) {
                System.out.println("No conflicts toggling feature " + satConfEngine.getModel().getNodeByID("_frame_aluminium").getName());
            } else {
                for (FeatureTreeNode conflictingFeature : ((ConfigurationEngine)satConfEngine).detectConflicts("_frame_aluminium")) {
                    System.out.println("---> Conflict: " + conflictingFeature.getName());
                }
            }
            System.out.println("> Toggling feature '" + satConfEngine.getModel().getNodeByID("_frame_aluminium").getName() + "'");
            ((ConfigurationEngine)satConfEngine).toggleDecision("_frame_aluminium");
            System.out.println("> Current State of the Feature Model ---------------------------");
            for (FeatureTreeNode featureNode : satConfEngine.getModel().getNodes()) {
                if (featureNode instanceof FeatureGroup) continue;
                System.out.println("--> " + featureNode.getName() + " = " + (featureNode.getValue() == 1 ? "true" : (featureNode.getValue() == 0 ? "false" : "undefined")));
            }
            satConfEngine.undoLastStep();
            System.out.println("> Undoing previous step");
            System.out.println("> Current State of the Feature Model ---------------------------");
            for (FeatureTreeNode featureNode : satConfEngine.getModel().getNodes()) {
                if (featureNode instanceof FeatureGroup) continue;
                System.out.println("--> " + featureNode.getName() + " = " + (featureNode.getValue() == 1 ? "true" : (featureNode.getValue() == 0 ? "false" : "undefined")));
            }
            ((ConfigurationEngine)satConfEngine).autoComplete(true);
            System.out.println("> Auto-completing configuration");
            System.out.println("> Current State of the Feature Model ---------------------------");
            for (FeatureTreeNode featureNode : satConfEngine.getModel().getNodes()) {
                if (featureNode instanceof FeatureGroup) continue;
                System.out.println("--> " + featureNode.getName() + " = " + (featureNode.getValue() == 1 ? "true" : (featureNode.getValue() == 0 ? "false" : "undefined")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

