/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.IVecInt;

public class CBClause
implements Constr,
Undoable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int falsified;
    private boolean learnt;
    protected final int[] lits;
    protected final ILits voc;
    private double activity;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static CBClause brandNewClause(UnitPropagationListener unitPropagationListener, ILits iLits, IVecInt iVecInt) {
        CBClause cBClause = new CBClause(iVecInt, iLits);
        cBClause.register();
        return cBClause;
    }

    public CBClause(IVecInt iVecInt, ILits iLits, boolean bl) {
        this.learnt = bl;
        this.lits = new int[iVecInt.size()];
        this.voc = iLits;
        iVecInt.moveTo(this.lits);
    }

    public CBClause(IVecInt iVecInt, ILits iLits) {
        this(iVecInt, iLits, false);
    }

    public void remove() {
        for (int i = 0; i < this.lits.length; ++i) {
            this.voc.attaches(this.lits[i] ^ 1).remove(this);
        }
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        this.voc.undos(n).push(this);
        ++this.falsified;
        if (!$assertionsDisabled && this.falsified == this.lits.length) {
            throw new AssertionError();
        }
        if (this.falsified == this.lits.length - 1) {
            for (int i = 0; i < this.lits.length; ++i) {
                if (this.voc.isFalsified(this.lits[i])) continue;
                return unitPropagationListener.enqueue(this.lits[i], this);
            }
            return false;
        }
        return true;
    }

    public boolean simplify() {
        int[] nArray = this.lits;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (!this.voc.isSatisfied(n2)) continue;
            return true;
        }
        return false;
    }

    public void undo(int n) {
        --this.falsified;
    }

    public void calcReason(int n, IVecInt iVecInt) {
        if (!$assertionsDisabled && iVecInt.size() != 0) {
            throw new AssertionError();
        }
        int[] nArray = this.lits;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            if (!$assertionsDisabled && !this.voc.isFalsified(n3) && n3 != n) {
                throw new AssertionError();
            }
            if (!this.voc.isFalsified(n3)) continue;
            iVecInt.push(n3 ^ 1);
        }
        if (!$assertionsDisabled && n != -1 && iVecInt.size() != this.lits.length - 1) {
            throw new AssertionError();
        }
    }

    public boolean learnt() {
        return this.learnt;
    }

    public void incActivity(double d) {
        this.activity += d;
    }

    public double getActivity() {
        return this.activity;
    }

    public boolean locked() {
        int[] nArray = this.lits;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (!this.voc.isSatisfied(n2)) continue;
            return this.voc.getReason(n2) == this;
        }
        return false;
    }

    public void setLearnt() {
        this.learnt = true;
    }

    public void register() {
        int n;
        int n2;
        int[] nArray = this.lits;
        int n3 = nArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            n = nArray[n2];
            this.voc.attach(n ^ 1, this);
        }
        if (this.learnt) {
            nArray = this.lits;
            n3 = nArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                n = nArray[n2];
                if (!this.voc.isFalsified(n)) continue;
                this.voc.undos(n ^ 1).push(this);
                ++this.falsified;
            }
            if (!$assertionsDisabled && this.falsified != this.lits.length - 1) {
                throw new AssertionError();
            }
        }
    }

    public void rescaleBy(double d) {
        this.activity *= d;
    }

    public int size() {
        return this.lits.length;
    }

    public int get(int n) {
        return this.lits[n];
    }

    public void assertConstraint(UnitPropagationListener unitPropagationListener) {
        if (!$assertionsDisabled && !this.voc.isUnassigned(this.lits[0])) {
            throw new AssertionError();
        }
        boolean bl = unitPropagationListener.enqueue(this.lits[0], this);
        if (!$assertionsDisabled && !bl) {
            throw new AssertionError();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.lits.length; ++i) {
            stringBuffer.append(this.lits[i]);
            stringBuffer.append("[");
            stringBuffer.append(this.voc.valueToString(this.lits[i]));
            stringBuffer.append("]");
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    static {
        $assertionsDisabled = !CBClause.class.desiredAssertionStatus();
    }
}

