/*
 * Decompiled with CFR 0.152.
 */
package splar.apps.experiments;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import splar.core.constraints.BooleanVariable;
import splar.core.constraints.CNFClause;
import splar.core.constraints.CNFLiteral;
import splar.core.constraints.PropositionalFormula;
import splar.core.fm.FeatureGroup;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureModelException;
import splar.core.fm.FeatureTreeNode;
import splar.core.fm.GroupedFeature;
import splar.core.fm.RootNode;
import splar.core.fm.SolitaireFeature;

public class JSONFeatureModel
extends FeatureModel {
    private String featureModelJSONString;
    Map<String, FeatureTreeNode> featuresMap;

    public JSONFeatureModel(String featureModelJSONString) {
        this.featureModelJSONString = featureModelJSONString;
        this.featuresMap = new HashMap<String, FeatureTreeNode>();
    }

    @Override
    protected FeatureTreeNode createNodes() throws FeatureModelException {
        try {
            String[] metaData;
            JSONObject featureModelJSON = new JSONObject(this.featureModelJSONString);
            FeatureTreeNode rootNode = null;
            JSONArray featureDiagramFeatures = featureModelJSON.getJSONArray("feature_diagram");
            int numberOfFeatures = featureDiagramFeatures.length();
            for (int i = 0; i < numberOfFeatures; ++i) {
                JSONArray featureAttributes = featureDiagramFeatures.getJSONArray(i);
                if (featureAttributes.length() <= 0) continue;
                String featureId = featureAttributes.getString(0);
                String featureName = featureAttributes.getString(1);
                String featureType = featureAttributes.getString(2);
                String parentId = featureAttributes.getString(3);
                FeatureTreeNode node = this.createNode(featureId, featureName, featureType);
                this.featuresMap.put(featureId, node);
                if (i == 0) {
                    rootNode = node;
                    continue;
                }
                FeatureTreeNode parentNode = this.featuresMap.get(parentId);
                parentNode.add(node);
            }
            String fmName = featureModelJSON.getString("feature_model_name").trim();
            this.setName(fmName.length() == 0 ? rootNode.getName() : fmName);
            Iterator it = featureModelJSON.getJSONObject("crosstree_constraints").keys();
            while (it.hasNext()) {
                String constraintId = (String)it.next();
                JSONArray literals = featureModelJSON.getJSONObject("crosstree_constraints").getJSONArray(constraintId);
                if (literals.length() <= 0) continue;
                CNFClause clause = new CNFClause();
                for (int i = 0; i < literals.length(); ++i) {
                    String literal;
                    clause.addLiteral(new CNFLiteral(new BooleanVariable(literal.substring((literal = literals.getString(i)).startsWith("~") ? 1 : 0)), !literal.startsWith("~")));
                }
                this.addConstraint(new PropositionalFormula(constraintId, clause.toString2()));
            }
            for (String metaDataString : metaData = new String[]{"fm_description:description", "fm_author:creator", "fm_author_address:address", "fm_author_email:email", "fm_author_phone:phone", "fm_author_website:website", "fm_author_organization:organization", "fm_author_department:department", "fm_creation_date:date", "fm_publication:reference"}) {
                this.addMetaData(metaDataString.split(":")[1], featureModelJSON.getJSONObject("additional_information").getString(metaDataString.split(":")[0]));
            }
            return rootNode;
        }
        catch (Exception e) {
            throw new FeatureModelException(e.toString());
        }
    }

    protected FeatureTreeNode createNode(String featureId, String featureName, String featureType) {
        FeatureTreeNode node = null;
        node = featureType.compareToIgnoreCase("root") == 0 ? new RootNode(featureId, featureName, null) : (featureType.compareToIgnoreCase("mandatory") == 0 ? new SolitaireFeature(false, featureId, featureName, null) : (featureType.compareToIgnoreCase("optional") == 0 ? new SolitaireFeature(true, featureId, featureName, null) : (featureType.compareToIgnoreCase("xor") == 0 ? new FeatureGroup(featureId, "", 1, 1, null) : (featureType.compareToIgnoreCase("or") == 0 ? new FeatureGroup(featureId, "", 1, -1, null) : new GroupedFeature(featureId, featureName, null)))));
        return node;
    }

    @Override
    protected void saveNodes() {
    }
}

