/*
 * Decompiled with CFR 0.152.
 */
package splar.core.fm;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import splar.core.constraints.BooleanVariableInterface;
import splar.core.fm.FeatureTreeNodeState;
import splar.core.fm.IFNodeRenderer;

public class FeatureTreeNode
extends DefaultMutableTreeNode
implements BooleanVariableInterface,
Cloneable {
    public static final int UNKNOWN = -1;
    public static final int DESELECTED = 0;
    public static final int SELECTED = 1;
    protected int value = -1;
    protected boolean isImmutable = false;
    protected Map<String, Object> properties;
    private IFNodeRenderer nodeRenderer = null;
    private String name = "";
    private String id = "";
    private HashMap<String, FeatureTreeNodeState> states;
    private List<FeatureTreeNode> propagatedNodes = new Vector<FeatureTreeNode>();
    private BooleanVariableInterface propagationVar = null;
    private Object attachedData;

    public FeatureTreeNode(String id, String name, IFNodeRenderer nodeRenderer) {
        this.id = id;
        this.name = name;
        this.nodeRenderer = nodeRenderer;
        this.states = new HashMap();
        this.reset();
    }

    public FeatureTreeNodeState getState(String stateID) {
        return this.states.get(stateID);
    }

    public void saveState(String stateID) {
        FeatureTreeNodeState state = new FeatureTreeNodeState(stateID, this);
        state.save();
        this.states.put(stateID, state);
    }

    public void restoreState(String stateID) {
        this.restoreState(stateID, true);
    }

    public void restoreState(String stateID, boolean discardState) {
        FeatureTreeNodeState state = this.states.get(stateID);
        if (state != null) {
            state.restore();
            if (discardState) {
                this.discardState(stateID);
            }
        }
    }

    public void discardState(String stateID) {
        FeatureTreeNodeState state = this.states.get(stateID);
        if (state != null) {
            state.discard();
            this.states.remove(stateID);
        }
    }

    public void reset() {
        this.value = -1;
        this.properties = new LinkedHashMap<String, Object>();
    }

    public void setProperty(String name, Object object) {
        this.properties.put(name, object);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setID(String ID) {
        this.id = ID;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isAncestorOf(FeatureTreeNode node) {
        FeatureTreeNode ancestor = node;
        do {
            if (this != (ancestor = (FeatureTreeNode)ancestor.getParent())) continue;
            return true;
        } while (ancestor != null);
        return false;
    }

    public void setPropagatedNodes(List<FeatureTreeNode> propagatedNodes) {
        this.propagatedNodes = propagatedNodes;
    }

    public List<FeatureTreeNode> getPropagatedNodes() {
        return this.propagatedNodes;
    }

    public IFNodeRenderer getRenderer() {
        return this.nodeRenderer;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.getName();
    }

    @Override
    public void setImmutable(boolean immutable) {
        this.isImmutable = immutable;
    }

    @Override
    public boolean isImmutable() {
        return this.isImmutable;
    }

    @Override
    public boolean isInstantiated() {
        return this.value != -1;
    }

    @Override
    public void resetValue() {
        if (!this.isImmutable) {
            this.value = -1;
        }
    }

    @Override
    public boolean isPropagation() {
        return this.propagationVar != null;
    }

    @Override
    public BooleanVariableInterface getPropagationVariable() {
        return this.propagationVar;
    }

    @Override
    public void assignValue(int value, BooleanVariableInterface propagationVar) {
        if (!this.isImmutable) {
            this.value = value;
            this.propagationVar = propagationVar;
        }
    }

    @Override
    public void assignValue(int value) {
        if (!this.isImmutable) {
            this.value = value;
        }
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object var) {
        if (var == null) {
            return false;
        }
        return this.id.equals(((BooleanVariableInterface)var).getID());
    }

    @Override
    public String toString() {
        return this.getName() + "(" + this.getID() + ")";
    }

    public void dump() {
        System.out.println(this.getName() + "(" + this.getID() + ") = " + this.value);
        System.out.println("Properties");
        for (String key : this.properties.keySet()) {
            System.out.println("-> " + key + " = " + this.properties.get(key));
        }
    }

    @Override
    public void attachData(Object object) {
        this.attachedData = object;
    }

    @Override
    public void resetAttachedData() {
        this.attachedData = null;
    }

    @Override
    public Object getAttachedData() {
        return this.attachedData;
    }
}

