/*
 * Decompiled with CFR 0.152.
 */
package splar.core.fm.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import splar.core.constraints.BooleanVariable;
import splar.core.constraints.BooleanVariableInterface;
import splar.core.constraints.CNFClause;
import splar.core.constraints.CNFLiteral;
import splar.core.constraints.PropositionalFormula;
import splar.core.fm.FeatureGroup;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureTreeNode;
import splar.core.fm.clustering.ClusterHypergraph;
import splar.core.fm.clustering.NodeCluster;
import splar.core.util.hypergraphs.Hyperedge;
import splar.core.util.hypergraphs.Hypergraph;
import splar.core.util.hypergraphs.Vertex;

public class FeatureModelClustersManager {
    private FeatureModel featureModel;
    private Map<FeatureTreeNode, List<NodeCluster>> clusters;

    public FeatureModelClustersManager(FeatureModel featureModel) {
        this.featureModel = featureModel;
        this.clusters = new LinkedHashMap<FeatureTreeNode, List<NodeCluster>>();
    }

    public FeatureModel getFeatureModel() {
        return this.featureModel;
    }

    public List<NodeCluster> getNodeClusters(FeatureTreeNode node) {
        return this.clusters.get(node);
    }

    public boolean clustersReady() {
        return this.clusters.size() > 0;
    }

    public void createClusters() {
        Map<FeatureTreeNode, Hypergraph> clustersHypergraphs = this.createHypergraphsForNodesInEC();
        this.createClustersForAllNodes(clustersHypergraphs);
    }

    private Map<FeatureTreeNode, Hypergraph> createHypergraphsForNodesInEC() {
        LinkedHashMap<FeatureTreeNode, Hypergraph> nodesClusters = new LinkedHashMap<FeatureTreeNode, Hypergraph>();
        for (PropositionalFormula pf : this.featureModel.getConstraints()) {
            for (CNFClause cnfClause : pf.toCNFClauses()) {
                CNFClause clusterClause;
                FeatureTreeNode node = this.createClusterClause(cnfClause, clusterClause = new CNFClause());
                Hypergraph hyperGraph = (Hypergraph)nodesClusters.get(node);
                if (hyperGraph == null) {
                    hyperGraph = new ClusterHypergraph();
                    Hyperedge hyperedge = null;
                    nodesClusters.put(node, hyperGraph);
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        FeatureTreeNode childNode = (FeatureTreeNode)node.getChildAt(i);
                        Vertex vertex = new Vertex(childNode.getID());
                        hyperGraph.addVertex(vertex);
                        if (node instanceof FeatureGroup) {
                            if (hyperedge == null) {
                                hyperedge = new Hyperedge();
                                hyperGraph.addHyperEdge(hyperedge);
                            }
                        } else {
                            hyperedge = new Hyperedge();
                            hyperGraph.addHyperEdge(hyperedge);
                        }
                        hyperedge.addVertex(vertex);
                    }
                }
                if (clusterClause.countVariables() <= 1) continue;
                ClusterHypergraph clauseHyperGraph = new ClusterHypergraph();
                Hyperedge clauseHyperEdge = new Hyperedge();
                for (CNFLiteral literal : clusterClause.getLiterals()) {
                    Vertex vertex = hyperGraph.getVertexByName(literal.getVariable().getID());
                    clauseHyperGraph.addVertex(vertex);
                    clauseHyperEdge.addVertex(vertex);
                }
                ArrayList<CNFClause> ECClauses = (ArrayList<CNFClause>)clauseHyperEdge.getProperty("EC_clauses");
                ArrayList<CNFClause> clusterClauses = (ArrayList<CNFClause>)clauseHyperEdge.getProperty("cluster_clauses");
                if (ECClauses == null) {
                    ECClauses = new ArrayList<CNFClause>();
                    clauseHyperEdge.setProperty("EC_clauses", ECClauses);
                }
                if (clusterClauses == null) {
                    clusterClauses = new ArrayList<CNFClause>();
                    clauseHyperEdge.setProperty("cluster_clauses", clusterClauses);
                }
                ECClauses.add(cnfClause);
                clusterClauses.add(clusterClause);
                clauseHyperGraph.addHyperEdge(clauseHyperEdge);
                hyperGraph.merge(clauseHyperGraph);
            }
        }
        return nodesClusters;
    }

    public NodeCluster[] sortClusterAscendingOrder(FeatureTreeNode clusterNodeRoot) {
        List<NodeCluster> nodeClusters = this.clusters.get(clusterNodeRoot);
        NodeCluster[] sortedClusters = null;
        if (nodeClusters != null) {
            sortedClusters = nodeClusters.toArray(new NodeCluster[0]);
            Comparator<NodeCluster> c = new Comparator<NodeCluster>(){

                @Override
                public int compare(NodeCluster cluster1, NodeCluster cluster2) {
                    int size2;
                    int size1 = cluster1.size();
                    return size1 > (size2 = cluster2.size()) ? 1 : (size1 < size2 ? -1 : 0);
                }
            };
            Arrays.sort(sortedClusters, c);
        }
        return sortedClusters;
    }

    public NodeCluster[] sortClusterDescendingOrder(FeatureTreeNode clusterNodeRoot) {
        List<NodeCluster> nodeClusters = this.clusters.get(clusterNodeRoot);
        NodeCluster[] sortedClusters = null;
        if (nodeClusters != null) {
            sortedClusters = nodeClusters.toArray(new NodeCluster[0]);
            Comparator<NodeCluster> c = new Comparator<NodeCluster>(){

                @Override
                public int compare(NodeCluster cluster1, NodeCluster cluster2) {
                    int size2;
                    int size1 = cluster1.size();
                    return size1 > (size2 = cluster2.size()) ? -1 : (size1 < size2 ? 1 : 0);
                }
            };
            Arrays.sort(sortedClusters, c);
        }
        return sortedClusters;
    }

    protected FeatureTreeNode createClusterClause(CNFClause clause, CNFClause returnClause) {
        boolean bl;
        int index;
        FeatureTreeNode ancestorNode;
        Vector ancestorsList = new Vector();
        for (BooleanVariableInterface var : clause.getVariables()) {
            ArrayList<FeatureTreeNode> arrayList = new ArrayList<FeatureTreeNode>();
            FeatureTreeNode node = this.featureModel.getNodeByID(var.getID());
            if (node == null) continue;
            arrayList.add(0, node);
            for (ancestorNode = (FeatureTreeNode)node.getParent(); ancestorNode != null; ancestorNode = (FeatureTreeNode)ancestorNode.getParent()) {
                arrayList.add(0, ancestorNode);
            }
            ancestorsList.add(arrayList);
        }
        int minSize = Integer.MAX_VALUE;
        for (List list : ancestorsList) {
            int listSize = list.size();
            if (listSize >= minSize) continue;
            minSize = listSize;
        }
        FeatureTreeNode commonAncestor = null;
        boolean bl2 = false;
        for (index = 0; index < minSize && !bl; ++index) {
            ancestorNode = null;
            for (List list : ancestorsList) {
                FeatureTreeNode tempNode = (FeatureTreeNode)list.get(index);
                if (ancestorNode == null) {
                    ancestorNode = tempNode;
                    continue;
                }
                if (tempNode == ancestorNode) continue;
                bl = true;
            }
            if (bl) continue;
            commonAncestor = ancestorNode;
        }
        LinkedHashSet<BooleanVariable> variables = new LinkedHashSet<BooleanVariable>();
        for (List list : ancestorsList) {
            if (list.size() < index) continue;
            variables.add(new BooleanVariable(((FeatureTreeNode)list.get(index - 1)).getID()));
        }
        if (variables.size() > 1) {
            for (BooleanVariableInterface booleanVariableInterface : variables) {
                returnClause.addLiteral(new CNFLiteral(booleanVariableInterface, true));
            }
        }
        return commonAncestor;
    }

    public void createClustersForAllNodes(Map<FeatureTreeNode, Hypergraph> clustersHypergraphs) {
        this.clusters.clear();
        Set<FeatureTreeNode> nodesWithClusters = clustersHypergraphs.keySet();
        for (FeatureTreeNode node : nodesWithClusters) {
            Hypergraph h = clustersHypergraphs.get(node);
            ArrayList<NodeCluster> nodeClusters = new ArrayList<NodeCluster>();
            for (Hyperedge hyperedge : h.getHyperedges()) {
                NodeCluster cluster = new NodeCluster(this.featureModel, node);
                for (Vertex vertex : hyperedge.getVertices()) {
                    cluster.addNode(this.featureModel.getNodeByID(vertex.getName()));
                }
                cluster.addECClauses((List)hyperedge.getProperty("EC_clauses"));
                cluster.addClusterClauses((List)hyperedge.getProperty("cluster_clauses"));
                nodeClusters.add(cluster);
            }
            this.clusters.put(node, nodeClusters);
        }
        for (FeatureTreeNode node : this.featureModel.getNodes()) {
            if (nodesWithClusters.contains(node)) continue;
            ArrayList<NodeCluster> nodeClusters = new ArrayList<NodeCluster>();
            if (node instanceof FeatureGroup) {
                NodeCluster cluster = new NodeCluster(this.featureModel, node);
                for (int i = 0; i < node.getChildCount(); ++i) {
                    FeatureTreeNode groupedNode = (FeatureTreeNode)node.getChildAt(i);
                    cluster.addNode(groupedNode);
                }
                nodeClusters.add(cluster);
            } else {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    FeatureTreeNode childNode = (FeatureTreeNode)node.getChildAt(i);
                    NodeCluster cluster = new NodeCluster(this.featureModel, node);
                    cluster.addNode(childNode);
                    nodeClusters.add(cluster);
                }
            }
            this.clusters.put(node, nodeClusters);
        }
    }

    public void dump() {
        for (FeatureTreeNode node : this.clusters.keySet()) {
            List<NodeCluster> nodeClusters = this.clusters.get(node);
            for (NodeCluster cluster : nodeClusters) {
                cluster.dump();
            }
        }
    }
}

