/*
 * Decompiled with CFR 0.152.
 */
package splar.core.fm.configuration;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureTreeNode;
import splar.core.fm.XMLFeatureModel;
import splar.core.fm.configuration.ConfigurationEngineException;
import splar.core.fm.configuration.ConfigurationStep;

public abstract class ConfigurationEngine {
    protected FeatureModel model;
    protected List<ConfigurationStep> steps = new LinkedList<ConfigurationStep>();

    public ConfigurationEngine(String featureModelURL) throws ConfigurationEngineException {
        this.model = this.loadFeatureModelFromURL(featureModelURL);
    }

    public ConfigurationEngine(FeatureModel model) throws ConfigurationEngineException {
        this.model = model;
    }

    protected FeatureModel loadFeatureModelFromURL(String featureModelURL) throws ConfigurationEngineException {
        XMLFeatureModel model = null;
        try {
            model = new XMLFeatureModel(featureModelURL, 20);
            model.loadModel();
        }
        catch (Exception e) {
            throw new ConfigurationEngineException("Problems loading model. Please check if model follows SXFM specification");
        }
        model.saveState("initial_state");
        return model;
    }

    public synchronized List<ConfigurationStep> getSteps() {
        return this.steps;
    }

    public synchronized FeatureModel getModel() {
        return this.model;
    }

    public String toString() {
        String toString = "Model: " + this.model.getName() + "\r\n";
        for (ConfigurationStep step : this.steps) {
            toString = toString + "  Step " + step.toString() + "\r\n";
        }
        return toString;
    }

    public synchronized ConfigurationStep getLastStep() {
        return this.steps.get(this.steps.size() - 1);
    }

    public synchronized boolean isDone() {
        return this.model.getUninstantiatedNodes().size() == 0;
    }

    public synchronized ConfigurationStep reset() throws ConfigurationEngineException {
        try {
            this.steps.clear();
            this.model.restoreState("initial_state", false);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationEngineException("Problems reseting configuration", e);
        }
        return this.resetConfiguration();
    }

    protected abstract ConfigurationStep resetConfiguration() throws ConfigurationEngineException;

    public ConfigurationStep undoLastStep() throws ConfigurationEngineException {
        List<ConfigurationStep> undoneSteps = this.undo(this.steps.size());
        return undoneSteps.get(0);
    }

    public List<ConfigurationStep> undo(ConfigurationStep step) throws ConfigurationEngineException {
        return this.undo(this.steps.indexOf(step) + 1);
    }

    public List<ConfigurationStep> undo(int undoStep) throws ConfigurationEngineException {
        LinkedList<ConfigurationStep> undoneSteps = new LinkedList<ConfigurationStep>();
        try {
            if (undoStep > 1 && undoStep <= this.steps.size()) {
                while (this.steps.size() >= undoStep) {
                    ConfigurationStep undoStepObj = this.steps.get(undoStep - 1);
                    undoneSteps.add(undoStepObj);
                    this.steps.remove(undoStep - 1);
                }
            } else {
                throw new ConfigurationEngineException("Cannot undo specified configuration step");
            }
            this.model.restoreState("state_step" + undoStep, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationEngineException("Problems undoing configuration step", e);
        }
        return undoneSteps;
    }

    protected abstract Map<String, Boolean[]> computeValidDomains() throws ConfigurationEngineException;

    protected abstract String getVariableName(int var1);

    protected abstract int getVariableIndex(String var1);

    protected Map<String, Boolean[]> createConfigurationStep(String featureId, int featureValue, String decisionType) throws Exception {
        ConfigurationStep newConfStep = null;
        Map<String, Boolean[]> domainTable = null;
        int curConfStep = this.steps.size() + 1;
        try {
            this.model.saveState("state_step" + curConfStep);
            FeatureTreeNode currentDecidedFeature = this.model.getNodeByID(featureId);
            if (currentDecidedFeature == null) {
                throw new ConfigurationEngineException("Feature Id not found in the feature model: " + featureId);
            }
            if (currentDecidedFeature.isInstantiated() && currentDecidedFeature.getValue() != featureValue) {
                throw new ConfigurationEngineException("Feature configuration value conflicts with current assignment");
            }
            currentDecidedFeature.assignValue(featureValue);
            currentDecidedFeature.setProperty("decisionStep", "" + curConfStep);
            currentDecidedFeature.setProperty("decisionType", decisionType);
            domainTable = this.computeValidDomains();
            newConfStep = new ConfigurationStep("" + curConfStep);
            newConfStep.addManualDecisionFeature(currentDecidedFeature);
            int index = 0;
            for (String featureIdentifier : domainTable.keySet()) {
                Boolean[] domain;
                FeatureTreeNode featureNode = this.model.getNodeByID(featureIdentifier);
                if (!featureNode.isInstantiated() && (domain = domainTable.get(featureIdentifier)).length == 1) {
                    this.model.assignValue(featureNode, domain[0] != false ? 1 : 0);
                    featureNode.setProperty("decisionStep", "" + curConfStep);
                    featureNode.setProperty("decisionType", "propagated");
                    newConfStep.addPropagatedFeature(featureNode);
                }
                ++index;
            }
            ConfigurationStep.computeStepAttributes(newConfStep, this.steps, this.model);
            this.steps.add(newConfStep);
        }
        catch (Exception e) {
            this.model.restoreState("state_step" + curConfStep);
            throw e;
        }
        return domainTable;
    }

    public abstract ConfigurationStep autoComplete(boolean var1) throws ConfigurationEngineException;

    public synchronized ConfigurationStep configure(String featureId, int decision) throws ConfigurationEngineException {
        try {
            this.createConfigurationStep(featureId, decision, "manual");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationEngineException("Problems configuring model: ", e);
        }
        return this.getLastStep();
    }

    public abstract List<FeatureTreeNode> detectConflicts(String var1) throws ConfigurationEngineException;

    public abstract List<ConfigurationStep> toggleDecision(String var1) throws ConfigurationEngineException;
}

