/*
 * Decompiled with CFR 0.152.
 */
package splar.core.fm.configuration;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureTreeNode;

public class ConfigurationStep {
    private String stepId;
    private Set<FeatureTreeNode> decisions;
    private Set<FeatureTreeNode> propagations;
    private Map<String, String> attributes;

    public ConfigurationStep(String stepId) {
        this.stepId = stepId;
        this.propagations = new LinkedHashSet<FeatureTreeNode>();
        this.decisions = new LinkedHashSet<FeatureTreeNode>();
        this.attributes = new HashMap<String, String>();
    }

    public int hashCode() {
        return this.stepId.hashCode();
    }

    public boolean equals(Object step) {
        if (this == step) {
            return true;
        }
        if (step == null || step.getClass() != this.getClass()) {
            return false;
        }
        return this.stepId.equals(((ConfigurationStep)step).stepId);
    }

    public String toString() {
        String toString = "[" + this.stepId + ": ";
        for (FeatureTreeNode featureNode : this.decisions) {
            toString = toString + "*" + featureNode.getName() + "=" + featureNode.getValue() + ",";
        }
        toString = toString + "(";
        for (FeatureTreeNode featureNode : this.propagations) {
            toString = toString + featureNode.getName() + "=" + featureNode.getValue() + ",";
        }
        toString = toString + ")]";
        return toString;
    }

    public String getId() {
        return this.stepId;
    }

    public int countDecisions() {
        return this.countManualDecisions() + this.countPropagations();
    }

    public int countManualDecisions() {
        return this.decisions.size();
    }

    public int countPropagations() {
        return this.propagations.size();
    }

    public void addManualDecisionFeature(FeatureTreeNode decidedFeature) {
        this.decisions.add(decidedFeature);
    }

    public void addPropagatedFeature(FeatureTreeNode propagatedFeature) {
        this.propagations.add(propagatedFeature);
    }

    public Set<FeatureTreeNode> getPropagations() {
        return this.propagations;
    }

    public Set<FeatureTreeNode> getDecisions() {
        return this.decisions;
    }

    public boolean removeManualDecision(FeatureTreeNode featureNode) {
        return this.decisions.remove(featureNode);
    }

    public boolean removePropagatedDecision(FeatureTreeNode featureNode) {
        return this.propagations.remove(featureNode);
    }

    public void addAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Map<String, String> getAttributesMap() {
        return this.attributes;
    }

    public static void computeStepAttributes(ConfigurationStep step, List<ConfigurationStep> stepsList, FeatureModel model) {
        int previousStepCountCummulativeDecisions = 0;
        if (!stepsList.isEmpty()) {
            ConfigurationStep previousStep = stepsList.get(stepsList.size() - 1);
            previousStepCountCummulativeDecisions = Integer.valueOf(previousStep.getAttribute("step_countCummulativeDecisions"));
        }
        int curStepCountCummulativeDecisions = step.countDecisions() + previousStepCountCummulativeDecisions;
        step.addAttribute("step_countCummulativeDecisions", String.valueOf(curStepCountCummulativeDecisions));
        DecimalFormat format = new DecimalFormat("#0.0");
        step.addAttribute("step_percentageCummulativeDecisions", format.format((float)curStepCountCummulativeDecisions * 100.0f / (float)model.countFeatures()));
    }
}

