/*
 * Decompiled with CFR 0.152.
 */
package splar.core.heuristics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import splar.core.constraints.BooleanVariableInterface;
import splar.core.constraints.CNFClause;
import splar.core.constraints.CNFFormula;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureTreeNode;
import splar.core.heuristics.FORCEVariableOrderingHeuristic;

class NodeCluster {
    private FeatureModel featureModel;
    private List<FeatureTreeNode> nodes;
    private int size = -1;
    private List<CNFClause> identifiedClauses;

    public NodeCluster(FeatureModel featureModel) {
        this.featureModel = featureModel;
        this.nodes = new ArrayList<FeatureTreeNode>();
        this.identifiedClauses = null;
    }

    public int countNodes() {
        return this.nodes.size();
    }

    public List<CNFClause> identifyClauses(List<CNFClause> clauses) {
        if (this.identifiedClauses != null) {
            return this.identifiedClauses;
        }
        this.identifiedClauses = new ArrayList<CNFClause>();
        for (CNFClause clause : clauses) {
            boolean clauseFound = false;
            Iterator<FeatureTreeNode> it1 = this.nodes.iterator();
            while (it1.hasNext() && !clauseFound) {
                FeatureTreeNode clusterNode = it1.next();
                Iterator<BooleanVariableInterface> it2 = clause.getVariables().iterator();
                while (it2.hasNext() && !clauseFound) {
                    BooleanVariableInterface clauseVar = it2.next();
                    if (!clauseVar.getID().equals(clusterNode.getID())) continue;
                    this.identifiedClauses.add(clause);
                    clauseFound = true;
                }
            }
        }
        return this.identifiedClauses;
    }

    public void addNode(String nodeID) {
        this.nodes.add(this.featureModel.getNodeByID(nodeID));
    }

    public int size() {
        if (this.size == -1) {
            for (FeatureTreeNode node : this.nodes) {
                this.size += this.featureModel.countNodes(node);
            }
        }
        return this.size;
    }

    public FeatureTreeNode[] sortedNodes() {
        FeatureTreeNode[] sortedNodes = new FeatureTreeNode[this.nodes.size()];
        int index = 0;
        for (FeatureTreeNode node : this.nodes) {
            sortedNodes[index++] = node;
        }
        if (sortedNodes.length > 1) {
            Comparator<FeatureTreeNode> c = new Comparator<FeatureTreeNode>(){

                @Override
                public int compare(FeatureTreeNode node1, FeatureTreeNode node2) {
                    int size2;
                    int size1 = NodeCluster.this.featureModel.countNodes(node1);
                    return size1 > (size2 = NodeCluster.this.featureModel.countNodes(node2)) ? 1 : (size1 < size2 ? -1 : 0);
                }
            };
            Arrays.sort(sortedNodes, c);
        }
        return sortedNodes;
    }

    public FeatureTreeNode[] sortedNodesbyFORCE(List<CNFClause> allClauses) {
        FORCEVariableOrderingHeuristic force = new FORCEVariableOrderingHeuristic("", 1);
        CNFFormula cnf = new CNFFormula();
        this.identifiedClauses = this.identifyClauses(allClauses);
        cnf.addClauses(this.identifiedClauses);
        String[] vo = force.run(cnf);
        FeatureTreeNode[] voNodes = new FeatureTreeNode[vo.length];
        int index = 0;
        for (String nodeID : vo) {
            voNodes[index++] = this.featureModel.getNodeByID(nodeID);
        }
        return voNodes;
    }
}

