/*
 * Decompiled with CFR 0.152.
 */
package splar.core.heuristics;

import java.util.LinkedHashMap;
import java.util.Map;
import splar.core.constraints.CNFFormula;
import splar.core.heuristics.VariableOrderingHeuristic;

public class VariableOrderingHeuristicsManager {
    private Map<String, VariableOrderingHeuristic> heuristics = new LinkedHashMap<String, VariableOrderingHeuristic>();
    public static VariableOrderingHeuristicsManager manager = null;

    public static VariableOrderingHeuristicsManager createHeuristicsManager() {
        if (manager == null) {
            manager = new VariableOrderingHeuristicsManager();
        }
        return manager;
    }

    private VariableOrderingHeuristicsManager() {
    }

    public String[] run(String name, CNFFormula cnf) {
        VariableOrderingHeuristic heuristic = this.heuristics.get(name);
        if (heuristic != null) {
            return heuristic.run(cnf);
        }
        return null;
    }

    public void registerHeuristic(String name, VariableOrderingHeuristic heuristic) {
        this.heuristics.put(name, heuristic);
    }

    public VariableOrderingHeuristic getHeuristic(String name) {
        return this.heuristics.get(name);
    }

    public String[] getHeuristicNames() {
        String[] names = new String[this.heuristics.size()];
        int i = 0;
        for (VariableOrderingHeuristic heuristic : this.heuristics.values()) {
            names[i++] = heuristic.getName();
        }
        return names;
    }
}

