/*
 * Decompiled with CFR 0.152.
 */
package splar.plugins.configuration.bdd.javabdd.catalog;

import java.util.LinkedHashMap;
import java.util.Map;
import splar.plugins.configuration.bdd.javabdd.catalog.ProductCatalog;

public class Product {
    protected ProductCatalog catalog;
    protected String name;
    protected String id;
    protected Map<String, String> attributes;
    protected Map<String, String> components;

    public Product(ProductCatalog catalog, String id, String name) {
        this.catalog = catalog;
        this.id = id;
        this.name = name;
        this.attributes = new LinkedHashMap<String, String>();
        this.components = new LinkedHashMap<String, String>();
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void addAttribute(String attName, String attValue) {
        this.attributes.put(attName, attValue);
    }

    public String getComponent(String absComponentID) {
        return this.components.get(absComponentID);
    }

    public void addComponent(String compID, String compType) throws Exception {
        if (!this.catalog.containsComponent(compID)) {
            throw new Exception("Product refers to a component not described in the catalog: " + compID);
        }
        if (!this.catalog.getComponent(compID).getTypes().contains(compType) && compType.length() > 0) {
            throw new Exception("Component type " + compType + " is not valid for component " + compID);
        }
        this.components.put(compID, compType);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getComponents() {
        return this.components;
    }

    public String toString() {
        String toString = "Product: " + this.name + " [id=" + this.id + "]\r\n";
        toString = toString + "   * Attributes:\r\n";
        for (String attKey : this.attributes.keySet()) {
            toString = toString + "     - " + attKey + ": " + this.attributes.get(attKey) + "\r\n";
        }
        toString = toString + "   * Concrete Components:\r\n";
        for (String componentKey : this.components.keySet()) {
            toString = toString + "     - " + componentKey + ": " + this.components.get(componentKey) + "\r\n";
        }
        return toString;
    }
}

