/*
 * Decompiled with CFR 0.152.
 */
package splar.plugins.reasoners.sat.sat4j;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.Solver;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.ModelIterator;
import splar.core.fm.reasoning.FMReasoningException;
import splar.core.fm.reasoning.FMReasoningInterface;
import splar.plugins.reasoners.sat.sat4j.StaticVariableOrderSAT;

public abstract class ReasoningWithSAT
extends FMReasoningInterface {
    protected ISolver satSolver;
    protected String solverName;
    protected int timeout;
    protected List<IConstr> constrList = null;

    public ReasoningWithSAT(String solverName, int timeout) {
        this.solverName = solverName;
        this.timeout = timeout;
    }

    public ISolver getSolver() {
        return this.satSolver;
    }

    @Override
    public String getVariableName(int index) {
        return super.getVariableName(index - 1);
    }

    public void setVariableOrder(String[] order) {
        ((Solver)this.satSolver).setOrder((IOrder)new StaticVariableOrderSAT(order, false, this.varName2IndexMap, this.varIndex2NameMap));
    }

    public void setVariableOrderObject(IOrder order) {
        ((Solver)this.satSolver).setOrder(order);
    }

    protected abstract void addSolverClauses(ISolver var1) throws Exception;

    @Override
    public void init() throws Exception {
        this.satSolver = SolverFactory.instance().createSolverByName(this.solverName);
        this.satSolver.setTimeout(this.timeout);
        this.addSolverClauses(this.satSolver);
    }

    @Override
    public void end() {
    }

    @Override
    public boolean isConsistent() throws FMReasoningException {
        try {
            return this.satSolver.isSatisfiable();
        }
        catch (TimeoutException e) {
            throw new FMReasoningException(e);
        }
    }

    @Override
    public double countValidConfigurations() throws FMReasoningException {
        if (this.isConsistent()) {
            ModelIterator solver = new ModelIterator(this.satSolver);
            double countSat = 0.0;
            long start = System.nanoTime();
            try {
                while (solver.isSatisfiable()) {
                    solver.model();
                    countSat += 1.0;
                    if (!((double)(System.nanoTime() - start) / 1000000.0 > (double)this.timeout)) continue;
                    return -1.0;
                }
            }
            catch (Exception e) {
                throw new FMReasoningException(e);
            }
            return countSat;
        }
        throw new FMReasoningException("Operation does not apply to inconsistent feature models");
    }

    @Override
    public boolean isDeadFeature(String featureId) throws FMReasoningException {
        try {
            if (this.isConsistent()) {
                if (((Solver)this.satSolver).assume(LiteralsUtils.posLit((int)this.getVariableIndex(featureId)))) {
                    return !this.isConsistent();
                }
                return true;
            }
            throw new FMReasoningException("Operation does not apply to inconsistent feature models");
        }
        catch (Exception e) {
            throw new FMReasoningException(e);
        }
    }

    @Override
    public boolean isCoreFeature(String featureId) throws FMReasoningException {
        try {
            if (this.isConsistent()) {
                if (((Solver)this.satSolver).assume(LiteralsUtils.negLit((int)this.getVariableIndex(featureId)))) {
                    return !this.isConsistent();
                }
                return true;
            }
            throw new FMReasoningException("Operation does not apply to inconsistent feature models");
        }
        catch (Exception e) {
            throw new FMReasoningException(e);
        }
    }

    @Override
    public boolean isFreeFeature(String featureId) throws FMReasoningException {
        return !this.isDeadFeature(featureId) && !this.isCoreFeature(featureId);
    }

    @Override
    public Boolean[] validDomain(String featureId) throws FMReasoningException {
        if (this.isConsistent()) {
            if (this.isDeadFeature(featureId)) {
                return new Boolean[]{false};
            }
            if (this.isCoreFeature(featureId)) {
                return new Boolean[]{true};
            }
            return new Boolean[]{true, false};
        }
        throw new FMReasoningException("Operation does not apply to inconsistent feature models");
    }

    @Override
    public List<String> allDeadFeatures(Map<String, String> stats) throws FMReasoningException {
        if (this.isConsistent()) {
            LinkedList<String> features = new LinkedList<String>();
            boolean[] optimizations = new boolean[]{true, true, true, true, true};
            int[] domainSearch = new int[]{1};
            byte[][] domainTable = this.computeValidDomains(domainSearch, optimizations, stats);
            for (int i = 0; i < domainTable.length; ++i) {
                if (domainTable[i][1] != 3) continue;
                features.add(this.getVariableName(i + 1));
            }
            return features;
        }
        throw new FMReasoningException("Operation does not apply to inconsistent feature models");
    }

    @Override
    public List<String> allCoreFeatures(Map<String, String> stats) throws OperationNotSupportedException, FMReasoningException {
        if (this.isConsistent()) {
            LinkedList<String> features = new LinkedList<String>();
            boolean[] optimizations = new boolean[]{true, true, true, true, true};
            int[] domainSearch = new int[]{0};
            byte[][] domainTable = this.computeValidDomains(domainSearch, optimizations, stats);
            for (int i = 0; i < domainTable.length; ++i) {
                if (domainTable[i][0] != 3) continue;
                features.add(this.getVariableName(i + 1));
            }
            return features;
        }
        throw new FMReasoningException("Operation does not apply to inconsistent feature models");
    }

    @Override
    public List<String> allFreeFeatures(Map<String, String> stats) throws OperationNotSupportedException, FMReasoningException {
        if (this.isConsistent()) {
            LinkedList<String> features = new LinkedList<String>();
            boolean[] optimizations = new boolean[]{true, true, true, true, true};
            int[] domainSearch = new int[]{0, 1};
            byte[][] domainTable = this.computeValidDomains(domainSearch, optimizations, stats);
            for (int i = 0; i < domainTable.length; ++i) {
                if (domainTable[i][0] != 2 || domainTable[i][1] != 2) continue;
                features.add(this.getVariableName(i + 1));
            }
            return features;
        }
        throw new FMReasoningException("Operation does not apply to inconsistent feature models");
    }

    @Override
    public Map<String, Boolean[]> allValidDomains(Map<String, String> stats) throws OperationNotSupportedException, FMReasoningException {
        if (this.isConsistent()) {
            HashMap<String, Boolean[]> allDomains = new HashMap<String, Boolean[]>();
            boolean[] optimizations = new boolean[]{true, true, true, true, true};
            int[] domainSearch = new int[]{1, 0};
            byte[][] domainTable = this.computeValidDomains(domainSearch, optimizations, stats);
            for (int i = 0; i < domainTable.length; ++i) {
                LinkedList<Boolean> domain = new LinkedList<Boolean>();
                if (domainTable[i][0] == 2) {
                    domain.add(false);
                }
                if (domainTable[i][1] == 2) {
                    domain.add(true);
                }
                allDomains.put(this.getVariableName(i + 1), domain.toArray(new Boolean[0]));
            }
            return allDomains;
        }
        throw new FMReasoningException("Operation does not apply to inconsistent feature models");
    }

    public abstract byte[][] computeValidDomains(int[] var1, boolean[] var2, Map<String, String> var3);
}

