/*
 * Decompiled with CFR 0.152.
 */
package splar.samples;

import splar.core.fm.FeatureModel;
import splar.core.fm.XMLFeatureModel;
import splar.core.heuristics.FTPreOrderSortedECTraversalHeuristic;
import splar.core.heuristics.VariableOrderingHeuristic;
import splar.core.heuristics.VariableOrderingHeuristicsManager;
import splar.plugins.reasoners.bdd.javabdd.FMReasoningWithBDD;
import splar.plugins.reasoners.bdd.javabdd.ReasoningWithBDD;

public class BDDReasoningExample {
    public static void main(String[] args) {
        new BDDReasoningExample().run();
    }

    public void run() {
        try {
            String featureModelPath = "c:\\users\\marcilio\\eclipse\\fmrlib\\resources\\fm_samples\\simple_bike_fm.xml";
            XMLFeatureModel featureModel = new XMLFeatureModel(featureModelPath, 10);
            featureModel.loadModel();
            new FTPreOrderSortedECTraversalHeuristic("Pre-CL-MinSpan", featureModel, 20);
            VariableOrderingHeuristic heuristic = VariableOrderingHeuristicsManager.createHeuristicsManager().getHeuristic("Pre-CL-MinSpan");
            int bddNodeNum = 10000;
            int bddCacheSize = 10000;
            FMReasoningWithBDD reasoner = new FMReasoningWithBDD((FeatureModel)featureModel, heuristic, 50000, 50000, 60000L, "pre-order");
            ((ReasoningWithBDD)reasoner).init();
            System.out.println("BDD has " + reasoner.getBDD().nodeCount() + " nodes and was built in " + reasoner.getBDDBuildingTime() + " ms");
            System.out.println("Feature model is " + (reasoner.isConsistent() ? "" : " NOT ") + "consistent!");
            System.out.println("Feature model has " + reasoner.countValidConfigurations() + " possible configurations");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

