/*
 * Decompiled with CFR 0.152.
 */
package pledge.core.techniques.generation;

import java.util.List;
import java.util.Random;
import pledge.core.ModelPLEDGE;
import pledge.core.Product;
import pledge.core.techniques.generation.GenerationTechnique;
import pledge.core.techniques.generation.Individual;
import pledge.core.techniques.prioritization.PrioritizationTechnique;

public class EvolutionaryAlgorithm1Plus1
implements GenerationTechnique {
    public static final String NAME = "(1+1) Evolutionary Algorithm";
    private static final Random random = new Random();

    @Override
    public List<Product> generateProducts(ModelPLEDGE model, int nbProducts, long timeAllowed, PrioritizationTechnique prioritizationTechnique) throws Exception {
        long startTimeMS = System.currentTimeMillis();
        Individual indiv = new Individual(model, model.getUnpredictableProducts(nbProducts), prioritizationTechnique);
        indiv.fitnessAndOrdering();
        int nbIter = 0;
        while (System.currentTimeMillis() - startTimeMS < timeAllowed) {
            model.setCurrentAction("Iteration number " + (nbIter + 1));
            Individual newIndiv = new Individual(model, indiv, prioritizationTechnique);
            newIndiv.mutate(0, model);
            newIndiv.fitnessAndOrdering();
            if (newIndiv.getFitness() > indiv.getFitness()) {
                indiv = newIndiv;
            }
            ++nbIter;
            model.setProgress((int)((double)(System.currentTimeMillis() - startTimeMS) / (double)timeAllowed * 100.0));
        }
        return indiv.getProducts();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

