/*
 * Decompiled with CFR 0.152.
 */
package pledge.core.techniques.prioritization;

import java.util.ArrayList;
import java.util.List;
import pledge.core.ModelPLEDGE;
import pledge.core.Product;
import pledge.core.techniques.DistancesUtil;
import pledge.core.techniques.prioritization.PrioritizationTechnique;

public class SimilarityNearOptimal
implements PrioritizationTechnique {
    public static final String NAME = "Similarity / NearOptimal";
    private double fitnessSum;

    @Override
    public List<Product> prioritize(ModelPLEDGE model, List<Product> products) throws Exception {
        int size = products.size();
        ArrayList<Product> prioritizedProducts = new ArrayList<Product>(size);
        ArrayList<Product> productsCopy = new ArrayList<Product>(products);
        double[][] distancesMatrix = new double[size][size];
        this.fitnessSum = 0.0;
        double total = products.size() * (products.size() - 1) / 2;
        double done = 0.0;
        for (int i = 0; i < distancesMatrix.length; ++i) {
            for (int j = 0; j < distancesMatrix.length; ++j) {
                double dist;
                distancesMatrix[i][j] = -1.0;
                if (j <= i) continue;
                distancesMatrix[i][j] = dist = DistancesUtil.getJaccardDistance((Product)productsCopy.get(i), (Product)productsCopy.get(j));
                this.fitnessSum += dist;
                done += 1.0;
            }
        }
        ArrayList<Integer> possibleIndices = new ArrayList<Integer>();
        ArrayList<Integer> doneIndices = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            possibleIndices.add(i);
        }
        double maxDistance = -1.0;
        int toAddIIndex = -1;
        int toAddJIndex = -1;
        for (int i = 0; i < distancesMatrix.length; ++i) {
            for (int j = 0; j < distancesMatrix.length; ++j) {
                if (j <= i || !(distancesMatrix[i][j] > maxDistance)) continue;
                maxDistance = distancesMatrix[i][j];
                toAddIIndex = i;
                toAddJIndex = j;
            }
        }
        Product pi = products.get(toAddIIndex);
        Product pj = products.get(toAddJIndex);
        prioritizedProducts.add(pi);
        prioritizedProducts.add(pj);
        productsCopy.remove(pi);
        productsCopy.remove(pj);
        possibleIndices.remove((Object)toAddIIndex);
        possibleIndices.remove((Object)toAddJIndex);
        doneIndices.add(toAddIIndex);
        doneIndices.add(toAddJIndex);
        while (!productsCopy.isEmpty()) {
            if (possibleIndices.size() > 1) {
                double maxDist = -1.0;
                int toAdd = -1;
                for (Integer i : possibleIndices) {
                    double distance = 0.0;
                    for (Integer j : doneIndices) {
                        distance += j > i ? distancesMatrix[i][j] : distancesMatrix[j][i];
                    }
                    if (!(distance > maxDist)) continue;
                    maxDist = distance;
                    toAdd = i;
                }
                Product p = products.get(toAdd);
                prioritizedProducts.add(p);
                productsCopy.remove(p);
                possibleIndices.remove((Object)toAdd);
                doneIndices.add(toAdd);
                continue;
            }
            prioritizedProducts.add(products.get((Integer)possibleIndices.get(0)));
            productsCopy.clear();
        }
        return prioritizedProducts;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public double getFitnessSum() {
        return this.fitnessSum;
    }
}

