/*
 * Decompiled with CFR 0.152.
 */
package pledge.gui.views;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import pledge.core.ModelPLEDGE;
import pledge.core.techniques.generation.GenerationTechnique;
import pledge.core.techniques.prioritization.PrioritizationTechnique;

public class ViewMenuBar
extends JMenuBar
implements Observer {
    private static final String FILE = "File";
    private static final String CONFIGURATION = "Configuration";
    private static final String EXECUTE = "Execute";
    private static final String HELP = "Help";
    private static final String LOAD_FEATURE_MODEL = "Load a Feature Model...";
    private static final String LOAD_PRODUCTS = "Load Products...";
    private static final String LOAD_PRODUCTS_FM = "Load Products after Feature Model...";
    private static final String QUIT = "Quit";
    public static final String GENERATE = "Generate products";
    public static final String PRIORITIZE = "Prioritize products";
    public static final String STOP = "Stop the execution";
    public static final String SAVE_PRODUCTS = "Save the products";
    public static final String COMPUTE_PAIRWISE = "Compute the pairwise coverage";
    public static final String DOC = "Documentation";
    public static final String ABOUT = "About PLEDGE...";
    public static final String PRIORITIZATION_TECHNIQUE = "Prioritization technique";
    public static final String GENERATION_TECHNIQUE = "Generation technique";
    private ModelPLEDGE model;
    private JMenu file;
    private JMenu execute;
    private JMenu configuration;
    private JMenu help;
    private JMenu generationTechnique;
    private JMenu prioritizationTechnique;
    private JMenuItem loadFeatureModel;
    private JMenuItem loadProducts;
    private JMenuItem loadProductsFM;
    private JMenuItem quit;
    private JMenuItem generate;
    private JMenuItem prioritize;
    private JMenuItem coverage;
    private JMenuItem stop;
    private JMenuItem saveProducts;
    private JMenuItem about;
    private JMenuItem doc;
    private ImageIcon loadFMIcon;
    private ImageIcon loadProductsIcon;
    private ImageIcon quitIcon;
    private ImageIcon saveProductsIcon;
    private ImageIcon stopIcon;
    private ImageIcon generateIcon;
    private ImageIcon prioritizeIcon;
    private List<JRadioButtonMenuItem> generationTechniqueButtons = new ArrayList<JRadioButtonMenuItem>();
    private List<JRadioButtonMenuItem> prioritizationTechniqueButtons = new ArrayList<JRadioButtonMenuItem>();
    private final URL urlLoadFM = this.getClass().getResource("icons/load_fm.png");
    private final URL urlLoadProducts = this.getClass().getResource("icons/load_products.png");
    private final URL urlQuit = this.getClass().getResource("icons/exit.png");
    private final URL urlSaveProducts = this.getClass().getResource("icons/save_products.png");
    private final URL urlGenerate = this.getClass().getResource("icons/generate.png");
    private final URL urlPrioritize = this.getClass().getResource("icons/prioritize.png");
    private final URL urlStop = this.getClass().getResource("icons/stop.png");

    public ViewMenuBar(ModelPLEDGE model) {
        this.model = model;
        model.addObserver(this);
        this.loadFMIcon = new ImageIcon(this.urlLoadFM);
        this.loadProductsIcon = new ImageIcon(this.urlLoadProducts);
        this.quitIcon = new ImageIcon(this.urlQuit);
        this.saveProductsIcon = new ImageIcon(this.urlSaveProducts);
        this.generateIcon = new ImageIcon(this.urlGenerate);
        this.prioritizeIcon = new ImageIcon(this.urlPrioritize);
        this.stopIcon = new ImageIcon(this.urlStop);
        this.loadFeatureModel = new JMenuItem(LOAD_FEATURE_MODEL, this.loadFMIcon);
        this.loadFeatureModel.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.loadProducts = new JMenuItem(LOAD_PRODUCTS, this.loadProductsIcon);
        this.loadProducts.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.loadProductsFM = new JMenuItem(LOAD_PRODUCTS_FM);
        this.loadProductsFM.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.quit = new JMenuItem(QUIT, this.quitIcon);
        this.quit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.generate = new JMenuItem(GENERATE, this.generateIcon);
        this.generate.setAccelerator(KeyStroke.getKeyStroke(71, 8));
        this.prioritize = new JMenuItem(PRIORITIZE, this.prioritizeIcon);
        this.prioritize.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        this.coverage = new JMenuItem(COMPUTE_PAIRWISE);
        this.stop = new JMenuItem(STOP, this.stopIcon);
        this.stop.setAccelerator(KeyStroke.getKeyStroke(75, 8));
        this.saveProducts = new JMenuItem(SAVE_PRODUCTS, this.saveProductsIcon);
        this.saveProducts.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        this.doc = new JMenuItem(DOC);
        this.doc.setAccelerator(KeyStroke.getKeyStroke(68, 8));
        this.about = new JMenuItem(ABOUT);
        this.about.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        this.generationTechnique = new JMenu(GENERATION_TECHNIQUE);
        ButtonGroup generationGroup = new ButtonGroup();
        for (GenerationTechnique gt : model.getGenerationTechniques()) {
            JRadioButtonMenuItem button = new JRadioButtonMenuItem(gt.getName());
            this.generationTechniqueButtons.add(button);
            if (gt.getName().equals(model.getGenerationTechnique().getName())) {
                button.setSelected(true);
            }
            generationGroup.add(button);
            this.generationTechnique.add(button);
        }
        this.prioritizationTechnique = new JMenu(PRIORITIZATION_TECHNIQUE);
        ButtonGroup prioritizationGroup = new ButtonGroup();
        for (PrioritizationTechnique pt : model.getPrioritizationTechniques()) {
            JRadioButtonMenuItem button = new JRadioButtonMenuItem(pt.getName());
            this.prioritizationTechniqueButtons.add(button);
            if (pt.getName().equals(model.getPrioritizationTechnique().getName())) {
                button.setSelected(true);
            }
            prioritizationGroup.add(button);
            this.prioritizationTechnique.add(button);
        }
        this.file = new JMenu(FILE);
        this.file.setMnemonic(70);
        this.file.add(this.loadFeatureModel);
        this.file.add(this.loadProducts);
        this.file.add(this.loadProductsFM);
        this.file.addSeparator();
        this.file.add(this.quit);
        this.add(this.file);
        this.execute = new JMenu(EXECUTE);
        this.execute.setMnemonic(69);
        this.execute.add(this.generate);
        this.execute.add(this.prioritize);
        this.execute.add(this.coverage);
        this.execute.add(this.stop);
        this.execute.addSeparator();
        this.execute.add(this.saveProducts);
        this.add(this.execute);
        this.configuration = new JMenu(CONFIGURATION);
        this.configuration.setMnemonic(67);
        this.configuration.add(this.generationTechnique);
        this.configuration.add(this.prioritizationTechnique);
        this.add(this.configuration);
        this.help = new JMenu(HELP);
        this.help.setMnemonic(72);
        this.help.add(this.doc);
        this.help.addSeparator();
        this.help.add(this.about);
        this.add(this.help);
        this.setEnabled();
    }

    public JMenuItem getLoadFeatureModel() {
        return this.loadFeatureModel;
    }

    public JMenuItem getQuit() {
        return this.quit;
    }

    public JMenuItem getLoadProducts() {
        return this.loadProducts;
    }

    public JMenuItem getLoadProductsFM() {
        return this.loadProductsFM;
    }

    public List<JRadioButtonMenuItem> getGenerationTechniqueButtons() {
        return this.generationTechniqueButtons;
    }

    public List<JRadioButtonMenuItem> getPrioritizationTechniqueButtons() {
        return this.prioritizationTechniqueButtons;
    }

    public JMenuItem getAbout() {
        return this.about;
    }

    public JMenuItem getGenerate() {
        return this.generate;
    }

    public JMenuItem getPrioritize() {
        return this.prioritize;
    }

    public JMenuItem getDoc() {
        return this.doc;
    }

    public JMenuItem getCoverage() {
        return this.coverage;
    }

    public JMenuItem getSaveProducts() {
        return this.saveProducts;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.setEnabled();
    }

    public String getSelectedGenerationTechnique() {
        for (JRadioButtonMenuItem button : this.generationTechniqueButtons) {
            if (!button.isSelected()) continue;
            return button.getText();
        }
        return null;
    }

    public String getSelectedPrioritizationTechnique() {
        for (JRadioButtonMenuItem button : this.prioritizationTechniqueButtons) {
            if (!button.isSelected()) continue;
            return button.getText();
        }
        return null;
    }

    private void setEnabled() {
        Runnable code = new Runnable(){

            @Override
            public void run() {
                ViewMenuBar.this.generate.setEnabled(ViewMenuBar.this.model.getSolver() != null && !ViewMenuBar.this.model.isRunning());
                ViewMenuBar.this.prioritize.setEnabled(ViewMenuBar.this.model.getProducts() != null && !ViewMenuBar.this.model.isRunning());
                ViewMenuBar.this.coverage.setEnabled(ViewMenuBar.this.model.getProducts() != null && !ViewMenuBar.this.model.isRunning());
                ViewMenuBar.this.saveProducts.setEnabled(ViewMenuBar.this.model.getProducts() != null);
                ViewMenuBar.this.stop.setEnabled(ViewMenuBar.this.model.isRunning());
                ViewMenuBar.this.loadFeatureModel.setEnabled(!ViewMenuBar.this.model.isRunning());
                ViewMenuBar.this.loadProducts.setEnabled(!ViewMenuBar.this.model.isRunning());
                ViewMenuBar.this.execute.setEnabled(ViewMenuBar.this.generate.isEnabled() || ViewMenuBar.this.prioritize.isEnabled() || ViewMenuBar.this.stop.isEnabled());
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            SwingUtilities.invokeLater(code);
        }
    }
}

