/*
 * Decompiled with CFR 0.152.
 */
package multiobj;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import multiobj.Individual;
import multiobj.TSet;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.orders.RandomLiteralSelectionStrategy;
import org.sat4j.minisat.orders.RandomWalkDecorator;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.reader.DimacsReader;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.ModelIterator;
import splar.core.constraints.CNFClause;
import splar.core.constraints.CNFFormula;
import splar.core.constraints.CNFLiteral;
import splar.core.fm.FeatureModel;
import splar.core.fm.XMLFeatureModel;
import splar.plugins.reasoners.sat.sat4j.FMReasoningWithSAT;

public class Multiobj {
    private CommandLineParser parser;
    private double w1;
    private double w2;
    private double w3;
    private double maxProductCost;
    private int popSize;
    private int runs;
    private int minProds = 1;
    private int maxIndSize;
    private double maxPairs;
    private String fm;
    private String fcost;
    private String outFile;
    private String outIndiv;
    HashMap<Integer, Integer> costs;
    private int elitism;
    private double mutateProb;

    public Multiobj(String[] args) {
        try {
            this.parser = new CommandLineParser(args, "Multiobj");
            if (args.length == 0) {
                throw new ParameterException("No arguments");
            }
            this.parser.parseArgs();
            String command = this.parser.getCommandName();
            if (command.equals("todimacs")) {
                String splot = this.parser.getCommandToDimacs().fmFile;
                String dimacs = splot.replaceAll("xml", "dimacs");
                this.splotToDimacs(dimacs, splot);
            } else if (command.equals("moga")) {
                this.w1 = this.parser.getCommandMOGA().w1;
                this.w2 = this.parser.getCommandMOGA().w2;
                this.w3 = this.parser.getCommandMOGA().w3;
                this.fm = this.parser.getCommandMOGA().fmFile;
                this.fcost = this.parser.getCommandMOGA().costFile;
                this.runs = this.parser.getCommandMOGA().runs;
                this.maxIndSize = this.parser.getCommandMOGA().maxProds;
                this.popSize = this.parser.getCommandMOGA().popSize;
                this.maxPairs = this.parser.getCommandMOGA().pairs;
                this.outFile = this.parser.getCommandMOGA().out;
                this.outIndiv = this.parser.getCommandMOGA().outIndiv;
                this.costs = this.loadCost(this.fcost);
                this.elitism = this.parser.getCommandMOGA().elitism;
                this.maxProductCost = 0.0;
                for (Integer i : this.costs.keySet()) {
                    this.maxProductCost += (double)this.costs.get(i).intValue();
                }
                Individual sol = this.multiObjectiveGeneticAlgorithm();
                this.writeProds(this.outIndiv, sol);
            } else if (command.equals("numpairs")) {
                this.fm = this.parser.getCommandPairs().fmFile;
                System.out.println(this.getFMNumberOfPairs());
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getMessage());
            this.parser.printUsage();
        }
    }

    public static void main(String[] args) {
        new Multiobj(args);
    }

    public int getFMNumberOfPairs() throws Exception {
        String line;
        HashSet<TSet> pairs = new HashSet<TSet>();
        ISolver dimacsSolver = SolverFactory.instance().createSolverByName("MiniSAT");
        DimacsReader dr = new DimacsReader(dimacsSolver);
        dr.parseInstance((Reader)new FileReader(this.fm));
        Solver solver = (Solver)dimacsSolver;
        ArrayList<Integer> featuresIntList = new ArrayList<Integer>();
        BufferedReader in = new BufferedReader(new FileReader(this.fm));
        int n = 0;
        while ((line = in.readLine()) != null && line.startsWith("c")) {
            StringTokenizer st = new StringTokenizer(line.trim(), " ");
            st.nextToken();
            String sFeature = st.nextToken().replace('$', ' ').trim();
            int feature = Integer.parseInt(sFeature);
            if (++n != feature) {
                throw new Exception("Incorrect dimacs file, missing feature number " + n + " ?");
            }
            featuresIntList.add(feature);
        }
        in.close();
        ArrayList<Integer> extendedFeatures = new ArrayList<Integer>(featuresIntList.size() * 2);
        for (Integer i : featuresIntList) {
            extendedFeatures.add(i);
            extendedFeatures.add(-i.intValue());
        }
        int size = extendedFeatures.size();
        this.nCk(size, 2, pairs, extendedFeatures, true, solver);
        return pairs.size();
    }

    public void nCk(int n, int k, Set<TSet> tsets, List<Integer> featuresList, boolean checkValid, Solver solver) throws Exception {
        int[] a = new int[k];
        this.nCkH(n, k, 0, a, k, tsets, featuresList, checkValid, solver);
    }

    public void nCkH(int n, int loopno, int ini, int[] a, int k, Set<TSet> tsets, List<Integer> featuresList, boolean checkValid, Solver solver) throws Exception {
        if (k == 0) {
            return;
        }
        if (--loopno < 0) {
            a[k - 1] = ini - 1;
            TSet p = new TSet();
            for (int i = 0; i < k; ++i) {
                p.add(featuresList.get(a[i]));
            }
            if (checkValid) {
                VecInt prod = new VecInt(p.getSize());
                for (Integer in : p.getVals()) {
                    prod.push(in.intValue());
                }
                if (solver.isSatisfiable((IVecInt)prod)) {
                    tsets.add(p);
                }
            } else {
                tsets.add(p);
            }
            return;
        }
        for (int i = ini; i <= n - loopno - 1; ++i) {
            a[k - 1 - loopno] = i;
            this.nCkH(n, loopno, i + 1, a, k, tsets, featuresList, checkValid, solver);
        }
    }

    public void writeProds(String file, Individual i) throws Exception {
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        for (IVecInt v : i.getProds()) {
            for (int j = 0; j < v.size(); ++j) {
                out.write(v.get(j) + " ");
            }
            out.newLine();
        }
        out.close();
    }

    public void writeRes(String file, Individual i) throws Exception {
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        out.write("fitness:" + i.getFitness());
        out.newLine();
        out.write("o1:" + i.getO1());
        out.newLine();
        out.write("o2:" + i.getO2());
        out.newLine();
        out.write("o3:" + i.getO3());
        out.newLine();
        out.write("pairs:" + i.getPairs());
        out.newLine();
        out.write("maxpairs:" + i.getMaxpairs());
        out.newLine();
        out.write("cost:" + i.getCost());
        out.newLine();
        out.write("max cost:" + i.getMaxcost());
        out.newLine();
        out.write("nbprods:" + i.getNbprods());
        out.newLine();
        out.close();
    }

    public Individual getRandomIndividualSameCoverage(int pairs) throws Exception {
        ArrayList<IVecInt> rands = new ArrayList<IVecInt>();
        do {
            rands.add(this.getDissimilarConfigs(1, this.fm).get(0));
        } while (this.getPairwiseCoverage(rands) < pairs);
        Individual i = new Individual(rands);
        this.evaluateFitness(i);
        return i;
    }

    public int getPairwiseCoverage(List<IVecInt> prods) {
        HashSet<TSet> pairs = new HashSet<TSet>();
        for (IVecInt v : prods) {
            for (int i = 0; i < v.size(); ++i) {
                for (int j = 0; j < v.size(); ++j) {
                    if (j <= i) continue;
                    pairs.add(new TSet(new int[]{v.get(i), v.get(j)}));
                }
            }
        }
        return pairs.size();
    }

    public Individual getRandomIndividualSameNumberProducts(int nbProds) throws Exception {
        ArrayList<IVecInt> rands = new ArrayList<IVecInt>();
        while (rands.size() < nbProds) {
            rands.add(this.getDissimilarConfigs(1, this.fm).get(0));
        }
        Individual i = new Individual(rands);
        this.evaluateFitness(i);
        return i;
    }

    public Individual multiObjectiveGeneticAlgorithm() throws Exception {
        ArrayList<Individual> indivs = new ArrayList<Individual>();
        double totalFitness = 0.0;
        Random r = new Random();
        for (int i = 1; i <= 100; ++i) {
            int size = r.nextInt(this.maxIndSize - 1) + this.minProds;
            List<IVecInt> prods = this.getDissimilarConfigs(size, this.fm);
            Individual indiv = new Individual(prods);
            this.evaluateFitness(indiv);
            totalFitness += indiv.getFitness();
            indivs.add(indiv);
        }
        Collections.sort(indivs);
        for (int nGen = 1; nGen <= this.runs; ++nGen) {
            System.out.println("Generation " + nGen);
            ArrayList pop = new ArrayList();
            for (int i = 0; i < this.elitism; ++i) {
                pop.add(indivs.get(i));
            }
            int size = r.nextInt(this.maxIndSize - 1) + this.minProds;
            List<IVecInt> prods = this.getDissimilarConfigs(size, this.fm);
            Individual rand = new Individual(prods);
            this.evaluateFitness(rand);
            pop.add(rand);
            while (pop.size() < this.popSize) {
                int rnd = (int)(Math.random() * totalFitness);
                int idx = 1;
                for (idx = 0; idx < this.popSize && rnd > 0; ++idx) {
                    rnd = (int)((double)rnd - ((Individual)indivs.get(idx)).getFitness());
                }
                if (idx == 0) {
                    idx = 1;
                }
                Individual p1 = (Individual)indivs.get(idx - 1);
                rnd = (int)(Math.random() * totalFitness);
                idx = 1;
                for (idx = 0; idx < this.popSize && rnd > 0; ++idx) {
                    rnd = (int)((double)rnd - ((Individual)indivs.get(idx)).getFitness());
                }
                if (idx == 0) {
                    idx = 1;
                }
                Individual p2 = (Individual)indivs.get(idx - 1);
                List<List<IVecInt>> offsprings = this.cross(p1.getProds(), p2.getProds(), r);
                double prob = Math.random() * 100.0;
                if (prob <= this.mutateProb) {
                    this.mutate(offsprings.get(0), r, this.fm);
                }
                if ((prob = Math.random() * 100.0) <= this.mutateProb) {
                    this.mutate(offsprings.get(1), r, this.fm);
                }
                Individual off1 = new Individual(offsprings.get(0));
                Individual off2 = new Individual(offsprings.get(1));
                this.evaluateFitness(off1);
                this.evaluateFitness(off2);
                pop.add(off1);
                pop.add(off2);
            }
            indivs = pop;
            Collections.sort(indivs);
            while (indivs.size() < 100) {
                indivs.remove(indivs.size() - 1);
            }
            totalFitness = 0.0;
            for (Individual i : indivs) {
                totalFitness += i.getFitness();
            }
        }
        this.writeRes(this.outFile, (Individual)indivs.get(0));
        return (Individual)indivs.get(0);
    }

    public void mutate(List<IVecInt> prods, Random r, String fm) throws Exception {
        int prodIndex = r.nextInt(prods.size());
        prods.remove(prodIndex);
        prods.add(this.getDissimilarConfigs(1, fm).get(0));
    }

    public List<List<IVecInt>> cross(List<IVecInt> p1, List<IVecInt> p2, Random r) {
        ArrayList<List<IVecInt>> offsprings = new ArrayList<List<IVecInt>>();
        ArrayList<IVecInt> o1 = new ArrayList<IVecInt>(p1);
        ArrayList<IVecInt> o2 = new ArrayList<IVecInt>(p2);
        if (p1.size() <= p2.size()) {
            int c = r.nextInt(p1.size());
            for (int n = 0; n < c; ++n) {
                int i = r.nextInt(p1.size());
                int j = r.nextInt(p2.size());
                IVecInt tmp = (IVecInt)o1.get(i);
                o1.set(i, (IVecInt)o2.get(j));
                o2.set(j, tmp);
            }
        } else {
            int c = r.nextInt(p2.size());
            for (int n = 0; n < c; ++n) {
                int i = r.nextInt(p2.size());
                int j = r.nextInt(p1.size());
                IVecInt tmp = (IVecInt)o2.get(i);
                o2.set(i, (IVecInt)o1.get(j));
                o1.set(j, tmp);
            }
        }
        offsprings.add(o1);
        offsprings.add(o2);
        return offsprings;
    }

    public int getCost(List<IVecInt> products) {
        int cost = 0;
        for (IVecInt p : products) {
            for (int i = 0; i < p.size(); ++i) {
                if (p.get(i) <= 0) continue;
                cost += this.costs.get(p.get(i)) == null ? 0 : this.costs.get(p.get(i));
            }
        }
        return cost;
    }

    public HashMap<Integer, Integer> loadCost(String filename) throws Exception {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(filename));
        HashMap<Integer, Integer> costs = new HashMap<Integer, Integer>();
        while ((line = in.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line, ":");
            costs.put(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
        }
        in.close();
        return costs;
    }

    public void evaluateFitness(Individual indiv) {
        List<IVecInt> products = indiv.getProds();
        double n = products.size();
        HashSet<TSet> pairs = new HashSet<TSet>();
        List<IVecInt> prods = indiv.getProds();
        for (IVecInt v : prods) {
            for (int i = 0; i < v.size(); ++i) {
                for (int j = 0; j < v.size(); ++j) {
                    if (j <= i) continue;
                    pairs.add(new TSet(new int[]{v.get(i), v.get(j)}));
                }
            }
        }
        int nf = products.get(0).size();
        double o1 = ((double)(-pairs.size()) + this.maxPairs) / ((double)(-(nf * (nf - 1) / 2)) + this.maxPairs);
        double o2 = (n - (double)this.minProds) / (double)(this.maxIndSize - this.minProds);
        double cost = this.getCost(products);
        double maxCost = this.maxProductCost * n;
        double o3 = cost / maxCost;
        double fit = o1 * this.w1 + o2 * this.w2 + o3 * this.w3;
        indiv.setFitness(fit);
        indiv.setO1(o1);
        indiv.setO2(o2);
        indiv.setO3(o3);
        indiv.setMaxpairs(this.maxPairs);
        indiv.setPairs(pairs.size());
        indiv.setMaxcost(maxCost);
        indiv.setCost(cost);
        indiv.setNbprods(n);
    }

    public List<IVecInt> getDissimilarConfigs(int count, String dimacsFM) throws Exception {
        ISolver dimacsSolver = SolverFactory.instance().createSolverByName("MiniSAT");
        DimacsReader dr = new DimacsReader(dimacsSolver);
        dr.parseInstance((Reader)new FileReader(dimacsFM));
        Solver solver = (Solver)dimacsSolver;
        solver.setTimeout(1000);
        solver.setOrder((IOrder)new RandomWalkDecorator(new VarOrderHeap((IPhaseSelectionStrategy)new RandomLiteralSelectionStrategy()), 1.0));
        ModelIterator solverIterator = new ModelIterator((ISolver)solver);
        solverIterator.setTimeoutMs(150000L);
        ArrayList<IVecInt> products = new ArrayList<IVecInt>(count);
        while (products.size() < count) {
            try {
                if (solverIterator.isSatisfiable()) {
                    int[] vec = solverIterator.model();
                    IVecInt vect = this.toVec(vec);
                    if (products.contains(vect)) continue;
                    products.add(vect);
                    continue;
                }
                dimacsSolver = SolverFactory.instance().createSolverByName("MiniSAT");
                dr = new DimacsReader(dimacsSolver);
                dr.parseInstance((Reader)new FileReader(dimacsFM));
                solver = (Solver)dimacsSolver;
                solver.setTimeout(1000);
                solver.setOrder((IOrder)new RandomWalkDecorator(new VarOrderHeap((IPhaseSelectionStrategy)new RandomLiteralSelectionStrategy()), 1.0));
                solverIterator = new ModelIterator((ISolver)solver);
                solverIterator.setTimeoutMs(150000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return products;
    }

    public IVecInt toVec(int[] vec) {
        VecInt vect = new VecInt(vec.length);
        for (int i = 0; i < vec.length; ++i) {
            vect.push(vec[i]);
        }
        return vect;
    }

    public void splotToDimacs(String dimacsPath, String splotPath) throws Exception {
        XMLFeatureModel splotFM = new XMLFeatureModel(splotPath, 10);
        splotFM.loadModel();
        int SATtimeout = 60000;
        FMReasoningWithSAT reasoner = new FMReasoningWithSAT("MiniSAT", (FeatureModel)splotFM, SATtimeout);
        reasoner.init();
        File file = new File(dimacsPath);
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        for (int i = 1; i <= splotFM.countFeatures(); ++i) {
            out.write("c " + i + " " + reasoner.getVariableName(i));
            out.newLine();
        }
        CNFFormula formula = splotFM.FM2CNF();
        out.write("p cnf " + splotFM.countFeatures() + " " + formula.getClauses().size());
        out.newLine();
        for (CNFClause clause : formula.getClauses()) {
            for (int i = 0; i < clause.getLiterals().size(); ++i) {
                int signal = ((CNFLiteral)clause.getLiterals().get(i)).isPositive() ? 1 : -1;
                int varID = reasoner.getVariableIndex(((CNFLiteral)clause.getLiterals().get(i)).getVariable().getID());
                out.write("" + signal * varID + " ");
                if (i != clause.getLiterals().size() - 1) continue;
                out.write("0");
                out.newLine();
            }
        }
        out.close();
    }

    private class CommandLineParser {
        private JCommander jCommander;
        private MOGA commandMOGA;
        private ToDimacs commandToDimacs;
        private Pairs commandPairs;
        public static final String MOGA = "moga";
        public static final String TO_DIMACS = "todimacs";
        public static final String PAIRS = "numpairs";
        private String[] args;

        public CommandLineParser(String[] args, String programName) {
            this.args = args;
            this.commandMOGA = new MOGA();
            this.commandToDimacs = new ToDimacs();
            this.commandPairs = new Pairs();
            this.jCommander = new JCommander();
            this.jCommander.addCommand(TO_DIMACS, this.commandToDimacs);
            this.jCommander.addCommand(PAIRS, this.commandPairs);
            this.jCommander.addCommand(MOGA, this.commandMOGA);
            this.jCommander.setProgramName("java -jar " + programName + ".jar");
        }

        public void parseArgs() {
            this.jCommander.parse(this.args);
        }

        public void printUsage() {
            this.jCommander.usage();
        }

        public String getCommandName() {
            return this.jCommander.getParsedCommand();
        }

        public MOGA getCommandMOGA() {
            return this.commandMOGA;
        }

        public ToDimacs getCommandToDimacs() {
            return this.commandToDimacs;
        }

        public Pairs getCommandPairs() {
            return this.commandPairs;
        }

        @Parameters(commandDescription="Compute the number of valid pairs of a given DIMACS Feature model (.dimacs format). ")
        private class Pairs {
            @Parameter(names={"-fm"}, description="Feature model in the DIMACS (.dimacs) format", required=true)
            private String fmFile;

            private Pairs() {
            }
        }

        @Parameters(commandDescription="Convert a Feature Model from the SPLOT (.xml) format to the DIMACS (.dimacs) format. ")
        private class ToDimacs {
            @Parameter(names={"-fm"}, description="Feature model in the SPLOT (.xml) format)", required=true)
            private String fmFile;

            private ToDimacs() {
            }
        }

        @Parameters(commandDescription="Run the multi-objective genetic algorithm. ")
        private class MOGA {
            @Parameter(names={"-fm"}, description="Feature model (DIMACS format)", required=true)
            private String fmFile;
            @Parameter(names={"-cost"}, description="Cost file (following the format featureNumber:cost)", required=true)
            private String costFile;
            @Parameter(names={"-outInfo"}, description="Output file to store the information of each run", required=true)
            private String out;
            @Parameter(names={"-outSol"}, description="Output file to store the products of the Individual solution to the problem", required=true)
            private String outIndiv;
            @Parameter(names={"-pairs"}, description="Number of valid pairs of the feature model", required=true)
            private int pairs;
            @Parameter(names={"-runs"}, description="Number of runs to perform")
            private int runs = 500;
            @Parameter(names={"-w1"}, description="Weight for objective F1")
            private double w1 = 0.5;
            @Parameter(names={"-w2"}, description="Weight for objective F2")
            private double w2 = 0.25;
            @Parameter(names={"-w3"}, description="Weight for objective F3")
            private double w3 = 0.25;
            @Parameter(names={"-maxIndSize"}, description="Maximum number of products for an Individual, i.e. a solution to the problem")
            private int maxProds = 100;
            @Parameter(names={"-popSize"}, description="Maximum size for the population (set of solutions)")
            private int popSize = 100;
            @Parameter(names={"-elitism"}, description="Number individuals to keep for the next generation (elitism), should be lower than the population size")
            private int elitism = 5;
            @Parameter(names={"-mutationProb"}, description="Probability to mutate an offspring (in percentage)")
            private double mutateProb = 5.0;

            private MOGA() {
            }
        }
    }
}

