/*
 * Decompiled with CFR 0.152.
 */
package splar.apps.experiments;

import java.io.FileWriter;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import splar.apps.experiments.VDData;
import splar.core.constraints.BooleanVariableInterface;
import splar.core.constraints.CNFClause;
import splar.core.constraints.CNFGenerator;
import splar.core.constraints.PropositionalFormula;
import splar.core.fm.FeatureGroup;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureModelException;
import splar.core.fm.FeatureModelStatistics;
import splar.core.fm.FeatureTreeNode;
import splar.core.fm.XMLFeatureModel;
import splar.core.fm.randomization.RandomFeatureModel2;
import splar.plugins.reasoners.sat.sat4j.FMReasoningWithSAT;

public class TestValidDomains {
    boolean saveHeader = true;

    public static void main(String[] args) {
        TestValidDomains o = new TestValidDomains();
        o.checkValidDomains();
    }

    public void checkValidDomains() {
        FeatureModel fm = null;
        boolean generateModels = true;
        boolean saveLogs = false;
        boolean checkValidDomain = false;
        boolean satisfiabilityState = false;
        int fmSize = 1000;
        float ecr = 0.2f;
        float density = 1.0f;
        int numberModels = 10;
        int firstModel = 1;
        boolean[] optimizations = new boolean[]{true, true, false, false};
        int[] checkType = new int[]{0, 1};
        String logPath = "c:\\users\\marcilio\\eclipse\\SPLOT\\webcontent\\genmodels\\temp\\valid-domains-logs.txt";
        String modelsPath = "c:\\users\\marcilio\\eclipse\\SPLOT\\webcontent\\genmodels\\";
        FMReasoningWithSAT ri = null;
        for (int modelIndex = firstModel; modelIndex <= numberModels; ++modelIndex) {
            String fmName = "unsat-3-sat-fm-" + fmSize + "-" + (int)(ecr * 100.0f) + "-" + modelIndex;
            String fileName = fmName + ".xml";
            if (generateModels) {
                try {
                    do {
                        System.out.println("Trying to generate a " + (satisfiabilityState ? "SATISFIABLE" : "UNSATISFIABLE") + " model ...");
                        fm = this.gen3SATFeatureModel(fmSize, ecr, density);
                        ri = new FMReasoningWithSAT("MiniSAT", fm, 60000);
                        ri.init();
                    } while (ri.isConsistent() != satisfiabilityState);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                fm = new XMLFeatureModel(modelsPath + fileName, 10);
                try {
                    fm.loadModel();
                }
                catch (FeatureModelException e) {
                    e.printStackTrace();
                }
            }
            fm.setName(fmName);
            FeatureModelStatistics stats = new FeatureModelStatistics(fm);
            stats.update();
            if (checkValidDomain) {
                System.out.println("********** Processing Model " + modelIndex + " **********");
                try {
                    VDData data = new VDData();
                    ri = new FMReasoningWithSAT("MiniSAT", fm, 60000);
                    ri.init();
                    HashMap<String, String> riStats = new HashMap<String, String>();
                    data.optimizations = optimizations;
                    data.checkType = checkType.length == 2 ? "Domain" : (checkType[0] == 1 ? "Dead" : "Common");
                    byte[][] domainTable = ri.computeValidDomains(checkType, data.optimizations, riStats);
                    data.numSATChecks = (String)riStats.get("sat-checks");
                    data.processingTime = (String)riStats.get("processing-time");
                    data.opt3ElimVars = (String)riStats.get("opt3-eliminated-vars");
                    int index = 0;
                    data.numCommon = 0;
                    data.numDead = 0;
                    for (byte[] entry : domainTable) {
                        if (entry[0] == 3) {
                            ++data.numCommon;
                        } else if (entry[1] == 3) {
                            ++data.numDead;
                        }
                        ++index;
                    }
                    data.fmSize = fm.countFeatures();
                    data.modelName = fm.getName();
                    data.ecr = ecr;
                    data.clauseDensity = stats.getECClauseDensity();
                    data.numClauses = fm.countConstraints();
                    System.out.println("#SAT checks: " + data.numSATChecks);
                    System.out.println("Time........: " + data.processingTime);
                    System.out.println("#Dead/Common..: " + data.numDead + "/" + data.numCommon + "\r\n");
                    if (saveLogs) {
                        this.saveData(logPath, data);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!generateModels) continue;
            this.saveFeatureModel(fm, stats, modelsPath + fileName);
        }
    }

    public FeatureModel gen3SATFeatureModel(int fmSize, float ecr, float density) {
        RandomFeatureModel2 fm = new RandomFeatureModel2("fm", fmSize, 25, 25, 25, 25, 1, 6, 6, 0);
        try {
            fm.loadModel();
        }
        catch (FeatureModelException e) {
            e.printStackTrace();
        }
        int ecVar = (int)((float)fmSize * ecr);
        LinkedList<BooleanVariableInterface> ecVars = new LinkedList<BooleanVariableInterface>();
        for (FeatureTreeNode var : fm.getNodes()) {
            if (var instanceof FeatureGroup || fm.isRoot(var)) continue;
            ecVars.add(var);
        }
        Collections.shuffle(ecVars);
        int size = ecVars.size() - ecVar;
        for (int i = 1; i <= size; ++i) {
            ecVars.remove(ecVars.size() - 1);
        }
        CNFGenerator cnfGenerator = new CNFGenerator();
        List<CNFClause> clauses = cnfGenerator.generateCNFInstance(ecVars, null, density, 3);
        int clauseCounter = 1;
        for (CNFClause clause : clauses) {
            try {
                fm.addConstraint(new PropositionalFormula("ec_" + clauseCounter++, clause.toPropositionalFormula()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fm;
    }

    public void saveData(String fileName, VDData data) {
        try {
            FileWriter writer = new FileWriter(fileName, true);
            if (this.saveHeader) {
                writer.write(data.header() + "\r\n");
            }
            writer.write(data.toString() + "\r\n");
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.saveHeader = false;
    }

    private void saveFeatureModel(FeatureModel fm, FeatureModelStatistics stats, String location) {
        PrintStream stream = null;
        PrintStream standartOut = System.out;
        try {
            stream = new PrintStream(location);
            System.setOut(stream);
            fm.dumpXML();
            System.out.println("<!--");
            stats.dump();
            System.out.println("-->");
            System.setOut(standartOut);
            stream.flush();
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

