/*
 * Decompiled with CFR 0.152.
 */
package splar.apps.generator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import splar.apps.generator.FMGeneratorGUIEvent;
import splar.apps.generator.FMGeneratorGUIListener;

public class FMGeneratorGUI
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 3698662440079433924L;
    private static final String remarkMessage = "This software generates 3-CNF Feature Models, i.e., models in which the cross-tree constraints (CTC) are represented by a Random 3-CNF Formula";
    private static final String initialMessage = "This software generates 3-CNF Feature Models. For details please see publication below:\n\n M. Mendonca, A. Wasowski, K. Czarnecki: SAT-Based Analysis of Feature Models is Easy, Proceedings of SPLC 2009, San Francisco, USA\n\nIMPORTANT: The models are generated based on the parameters indicated above.It is important to note that some of these parameters are conflicting. For instance, if the clause density is to high it might not be possible to generate consistent models. Also, conflicts can cause a significant delay in the generation process as the system will attempt unproductively to produce a model that matches the specified parameters.The user should try to adjust parameters to avoid such scenarios.\n\nYour suggestions for improvement and feedback are important. Contact us at http://www.splot-research.org";
    private Color foreColor1 = new Color(50, 50, 250);
    private Color foreColor2 = new Color(250, 50, 50);
    private Color errorBgColor = new Color(250, 50, 50);
    private Font font1 = new Font("Default", 1, 16);
    private Font font2 = new Font("Default", 1, 12);
    JTextField collectionNameTextField = new JTextField("MyCollection");
    JTextField collectionSizeTextField = new JTextField("10");
    JTextField collectionPathTextField = new JTextField("c:\\my_feature_models\\");
    JTextField featureTreeSizeTextField = new JTextField("100");
    JTextField featureTreeMandatoryTextField = new JTextField("25");
    JTextField featureTreeOptionalTextField = new JTextField("25");
    JTextField featureTreeAlternativeTextField = new JTextField("25");
    JTextField featureTreeExclusiveTextField = new JTextField("25");
    JTextField featureTreeMinBranchingFactorTextField = new JTextField("1");
    JTextField featureTreeMaxBranchingFactorTextField = new JTextField("6");
    JTextField featureTreeMaxFeatureGroupSizeTextField = new JTextField("6");
    JTextField ctcrTextField = new JTextField("20");
    JTextField ctcClauseDensityTextField = new JTextField("1.0");
    String[] data = new String[]{"Generate CONSISTENT models ONLY", "Generate INCONSISTENT models ONLY", "I DON'T CARE"};
    JComboBox consistentyList = new JComboBox<String>(this.data);
    JButton generateButton = new JButton("Generate");
    JButton cancelButton = new JButton("Cancel");
    JLabel messagesLabel = new JLabel(">> <<");
    JTextArea messageOutputTextArea = new JTextArea("This software generates 3-CNF Feature Models. For details please see publication below:\n\n M. Mendonca, A. Wasowski, K. Czarnecki: SAT-Based Analysis of Feature Models is Easy, Proceedings of SPLC 2009, San Francisco, USA\n\nIMPORTANT: The models are generated based on the parameters indicated above.It is important to note that some of these parameters are conflicting. For instance, if the clause density is to high it might not be possible to generate consistent models. Also, conflicts can cause a significant delay in the generation process as the system will attempt unproductively to produce a model that matches the specified parameters.The user should try to adjust parameters to avoid such scenarios.\n\nYour suggestions for improvement and feedback are important. Contact us at http://www.splot-research.org");
    private List<FMGeneratorGUIListener> listeners;

    public FMGeneratorGUI(String title) {
        super(title);
        this.init();
    }

    protected void init() {
        this.listeners = new LinkedList<FMGeneratorGUIListener>();
        this.buildGUI();
        this.addTooltips();
        this.generateButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    private void addTooltips() {
        this.collectionNameTextField.setToolTipText("What is the name of this collection of models (used as a prefix to name generated files)?");
        this.collectionSizeTextField.setToolTipText("How many feature models do you want to generate in this collection?");
        this.collectionPathTextField.setToolTipText("What is the path for saving your models? ");
        this.featureTreeSizeTextField.setToolTipText("What is the desired size for generated models?");
        this.featureTreeMandatoryTextField.setToolTipText("What is the percentage of mandatory features?");
        this.featureTreeOptionalTextField.setToolTipText("What is the percentage of optional features?");
        this.featureTreeAlternativeTextField.setToolTipText("What is the percentage of alternative (OR) features?");
        this.featureTreeExclusiveTextField.setToolTipText("What is the percentage of exclusive (XOR) features?");
        this.featureTreeMinBranchingFactorTextField.setToolTipText("What is the minimum branching factor (# of children per parent node)?");
        this.featureTreeMaxBranchingFactorTextField.setToolTipText("What is the maximum branching factor (# of children per parent node)?");
        this.featureTreeMaxFeatureGroupSizeTextField.setToolTipText("What is the maximum number of grouped features in a Feature Group?");
        this.ctcrTextField.setToolTipText("What percentage of the features in the feature tree should be considered to build the Random 3-CNF formula?");
        this.ctcClauseDensityTextField.setToolTipText("What is the desired clause density for the Random 3-CNF formula (density = #clauses / #features)?");
        this.consistentyList.setToolTipText("What is the desired consistency for your models?");
    }

    private Border createTitleBorder(String title) {
        return BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), title, 1, 2, this.font1, this.foreColor1);
    }

    private JPanel generateRemarkPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JTextArea textArea = new JTextArea(remarkMessage);
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setForeground(this.foreColor1);
        textArea.setFont(this.font1);
        textArea.setWrapStyleWord(true);
        textArea.setRows(2);
        JPanel tempPanel = new JPanel(new FlowLayout(1));
        tempPanel.setBackground(Color.white);
        JLabel label = new JLabel("Hover mouse over textfields to see tooltip descriptions");
        label.setForeground(this.foreColor2);
        label.setFont(this.font2);
        tempPanel.add(label);
        panel.add((Component)textArea, "Center");
        panel.add((Component)tempPanel, "South");
        return panel;
    }

    public void buildGUI() {
        this.setLayout(new BorderLayout());
        JPanel collectionPanel = new JPanel(new GridLayout(3, 1));
        collectionPanel.setBorder(this.createTitleBorder("Collection Information"));
        JPanel panel1 = new JPanel(new BorderLayout());
        panel1.add((Component)new JLabel("Name: "), "West");
        panel1.add((Component)this.collectionNameTextField, "Center");
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)new JLabel("Size: "), "West");
        panel2.add((Component)this.collectionSizeTextField, "Center");
        JPanel panel3 = new JPanel(new BorderLayout());
        panel3.add((Component)new JLabel("Output Directory: "), "West");
        panel3.add((Component)this.collectionPathTextField, "Center");
        collectionPanel.add(panel1);
        collectionPanel.add(panel2);
        collectionPanel.add(panel3);
        JPanel featureTreePanel = new JPanel(new GridLayout(8, 1));
        featureTreePanel.setBorder(this.createTitleBorder("Feature Tree Information"));
        JPanel panel4 = new JPanel(new BorderLayout());
        panel4.add((Component)new JLabel("Size (# of features) [>1]: "), "West");
        panel4.add((Component)this.featureTreeSizeTextField, "Center");
        JPanel panel5 = new JPanel(new BorderLayout());
        panel5.add((Component)new JLabel("% of Mandatory features [0-100]: "), "West");
        panel5.add((Component)this.featureTreeMandatoryTextField, "Center");
        JPanel panel6 = new JPanel(new BorderLayout());
        panel6.add((Component)new JLabel("% of Optional features [0-100]: "), "West");
        panel6.add((Component)this.featureTreeOptionalTextField, "Center");
        JPanel panel7 = new JPanel(new BorderLayout());
        panel7.add((Component)new JLabel("% of Alternative (OR) features [0-100]: "), "West");
        panel7.add((Component)this.featureTreeAlternativeTextField, "Center");
        JPanel panel8 = new JPanel(new BorderLayout());
        panel8.add((Component)new JLabel("% of Exclusive (XOR) features [0-100]: "), "West");
        panel8.add((Component)this.featureTreeExclusiveTextField, "Center");
        JPanel panel9 = new JPanel(new BorderLayout());
        panel9.add((Component)new JLabel("Minimum Branching Factor [>= 0]: "), "West");
        panel9.add((Component)this.featureTreeMinBranchingFactorTextField, "Center");
        JPanel panel10 = new JPanel(new BorderLayout());
        panel10.add((Component)new JLabel("Maximum Branching Factor [>= Minimum factor]: "), "West");
        panel10.add((Component)this.featureTreeMaxBranchingFactorTextField, "Center");
        JPanel panel11 = new JPanel(new BorderLayout());
        panel11.add((Component)new JLabel("Maximum Size for Feature Groups [> 1]: "), "West");
        panel11.add((Component)this.featureTreeMaxFeatureGroupSizeTextField, "Center");
        featureTreePanel.add(panel4);
        featureTreePanel.add(panel5);
        featureTreePanel.add(panel6);
        featureTreePanel.add(panel7);
        featureTreePanel.add(panel8);
        featureTreePanel.add(panel9);
        featureTreePanel.add(panel10);
        featureTreePanel.add(panel11);
        JPanel crosstreePanel = new JPanel(new GridLayout(3, 1));
        crosstreePanel.setBorder(this.createTitleBorder("Cross-Tree Constraints Information (Random 3-CNF Formula)"));
        JPanel panel12 = new JPanel(new BorderLayout());
        panel12.add((Component)new JLabel("% of Feature Tree Variables To Be Considered [0-100]: "), "West");
        panel12.add((Component)this.ctcrTextField, "Center");
        JPanel panel14 = new JPanel(new BorderLayout());
        panel14.add((Component)new JLabel("Clause Density [>= 0.0]: "), "West");
        panel14.add((Component)this.ctcClauseDensityTextField, "Center");
        JPanel panel15 = new JPanel(new BorderLayout());
        panel15.add((Component)new JLabel("Model Consistency: "), "West");
        panel15.add((Component)this.consistentyList, "Center");
        crosstreePanel.add(panel12);
        crosstreePanel.add(panel14);
        crosstreePanel.add(panel15);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 3));
        buttonPanel.add(this.generateButton);
        buttonPanel.add(this.cancelButton);
        this.cancelButton.setEnabled(false);
        JPanel centerPanel = new JPanel(new BorderLayout());
        JPanel tempPanel = new JPanel();
        tempPanel.setLayout(new BoxLayout(tempPanel, 3));
        JPanel errorMessagesPanel = new JPanel(new FlowLayout(1));
        errorMessagesPanel.add(this.messagesLabel);
        tempPanel.add(collectionPanel);
        tempPanel.add(featureTreePanel);
        tempPanel.add(crosstreePanel);
        tempPanel.add(errorMessagesPanel);
        tempPanel.add(buttonPanel);
        JScrollPane pane = new JScrollPane(this.messageOutputTextArea);
        centerPanel.add((Component)tempPanel, "North");
        centerPanel.add((Component)pane, "Center");
        this.messageOutputTextArea.setEditable(false);
        this.messageOutputTextArea.setLineWrap(true);
        this.messageOutputTextArea.setWrapStyleWord(true);
        this.add((Component)this.generateRemarkPanel(), "North");
        this.add((Component)centerPanel, "Center");
    }

    public String getCollectionName() {
        return this.collectionNameTextField.getText().trim();
    }

    public int getCollectionSize() {
        return Integer.parseInt(this.collectionSizeTextField.getText().trim());
    }

    public String getCollectionPath() {
        return this.collectionPathTextField.getText().trim();
    }

    public int getFeatureTreeSize() {
        return Integer.parseInt(this.featureTreeSizeTextField.getText().trim());
    }

    public int getFeatureTreeMandatoryPercentage() {
        return Integer.parseInt(this.featureTreeMandatoryTextField.getText().trim());
    }

    public int getFeatureTreeOptionalPercentage() {
        return Integer.parseInt(this.featureTreeOptionalTextField.getText().trim());
    }

    public int getFeatureTreeExclusiveORPercentage() {
        return Integer.parseInt(this.featureTreeExclusiveTextField.getText().trim());
    }

    public int getFeatureTreeInclusiveORPercentage() {
        return Integer.parseInt(this.featureTreeAlternativeTextField.getText().trim());
    }

    public int getFeatureTreeMinBranchingFactor() {
        return Integer.parseInt(this.featureTreeMinBranchingFactorTextField.getText().trim());
    }

    public int getFeatureTreeMaxBranchingFactor() {
        return Integer.parseInt(this.featureTreeMaxBranchingFactorTextField.getText().trim());
    }

    public int getFeatureTreeMaxFeatureGroupSize() {
        return Integer.parseInt(this.featureTreeMaxFeatureGroupSizeTextField.getText().trim());
    }

    public int getCTCR() {
        return Integer.parseInt(this.ctcrTextField.getText().trim());
    }

    public float getCTCClauseDensity() {
        return Float.parseFloat(this.ctcClauseDensityTextField.getText().trim());
    }

    public int getConsistentyOption() {
        return this.consistentyList.getSelectedIndex() == 0 ? 1 : (this.consistentyList.getSelectedIndex() == 1 ? -1 : 0);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        block4: {
            block3: {
                if (event.getSource() != this.generateButton) break block3;
                this.validParametersState();
                this.clearErrorMessage();
                if (!this.validateParameters()) break block4;
                FMGeneratorGUIEvent gEvent = new FMGeneratorGUIEvent(this);
                for (FMGeneratorGUIListener listener : this.listeners) {
                    listener.startGeneration(gEvent);
                }
                break block4;
            }
            if (event.getSource() == this.cancelButton) {
                for (FMGeneratorGUIListener listener : this.listeners) {
                    listener.cancelGeneration();
                }
            }
        }
    }

    public void addListener(FMGeneratorGUIListener listener) {
        this.listeners.add(listener);
    }

    public void disableGeneration() {
        this.generateButton.setEnabled(false);
    }

    public void enableGeneration() {
        this.generateButton.setEnabled(true);
    }

    public void disableCancelGeneration() {
        this.cancelButton.setEnabled(false);
    }

    public void enableCancelGeneration() {
        this.cancelButton.setEnabled(true);
    }

    public void addMessage(String message) {
        this.messageOutputTextArea.append(message + "\r\n");
    }

    public void clearMessages() {
        this.messageOutputTextArea.setText("");
    }

    public void setMessage(String message) {
        this.messagesLabel.setText(message);
        this.messagesLabel.setFont(this.font2);
        this.messagesLabel.setForeground(this.errorBgColor);
    }

    private void clearErrorMessage() {
        this.messagesLabel.setText("");
    }

    private void validParametersState() {
        this.collectionNameTextField.setBackground(Color.white);
        this.collectionSizeTextField.setBackground(Color.white);
        this.collectionPathTextField.setBackground(Color.white);
        this.featureTreeSizeTextField.setBackground(Color.white);
        this.featureTreeMandatoryTextField.setBackground(Color.white);
        this.featureTreeOptionalTextField.setBackground(Color.white);
        this.featureTreeAlternativeTextField.setBackground(Color.white);
        this.featureTreeExclusiveTextField.setBackground(Color.white);
        this.featureTreeMinBranchingFactorTextField.setBackground(Color.white);
        this.featureTreeMaxBranchingFactorTextField.setBackground(Color.white);
        this.featureTreeMaxFeatureGroupSizeTextField.setBackground(Color.white);
        this.ctcrTextField.setBackground(Color.white);
        this.ctcClauseDensityTextField.setBackground(Color.white);
        this.consistentyList.setBackground(Color.white);
    }

    private boolean validateParameters() {
        this.collectionNameTextField.getText().trim();
        if (this.collectionNameTextField.getText().trim().isEmpty()) {
            this.setMessage("Collection name cannot be empty");
            this.collectionNameTextField.setBackground(this.errorBgColor);
            return false;
        }
        try {
            if (Integer.parseInt(this.collectionSizeTextField.getText().trim()) < 1) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            this.setMessage("Collection size must be a positive integer");
            this.collectionSizeTextField.setBackground(this.errorBgColor);
            return false;
        }
        File file = new File(this.collectionPathTextField.getText().trim());
        if (this.collectionPathTextField.getText().trim().isEmpty() || !file.exists()) {
            this.setMessage("Collection path must point to a valid directory path");
            this.collectionPathTextField.setBackground(this.errorBgColor);
            return false;
        }
        try {
            if (Integer.parseInt(this.featureTreeSizeTextField.getText().trim()) < 1) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            this.setMessage("Feature tree size must be a positive integer");
            this.featureTreeSizeTextField.setBackground(this.errorBgColor);
            return false;
        }
        try {
            if (Integer.parseInt(this.featureTreeMandatoryTextField.getText().trim()) < 0 || Integer.parseInt(this.featureTreeMandatoryTextField.getText().trim()) > 100) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            this.setMessage("% of mandatory features must be between 0 and 100");
            this.featureTreeMandatoryTextField.setBackground(this.errorBgColor);
            return false;
        }
        try {
            if (Integer.parseInt(this.featureTreeOptionalTextField.getText().trim()) < 0 || Integer.parseInt(this.featureTreeOptionalTextField.getText().trim()) > 100) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            this.setMessage("% of optional features must be between 0 and 100");
            this.featureTreeOptionalTextField.setBackground(this.errorBgColor);
            return false;
        }
        try {
            if (Integer.parseInt(this.featureTreeExclusiveTextField.getText().trim()) < 0 || Integer.parseInt(this.featureTreeExclusiveTextField.getText().trim()) > 100) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            this.setMessage("% of exclusive (XOR) features must be between 0 and 100");
            this.featureTreeExclusiveTextField.setBackground(this.errorBgColor);
            return false;
        }
        try {
            if (Integer.parseInt(this.featureTreeAlternativeTextField.getText().trim()) < 0 || Integer.parseInt(this.featureTreeAlternativeTextField.getText().trim()) > 100) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            this.setMessage("% of alternative (OR) features must be between 0 and 100");
            this.featureTreeAlternativeTextField.setBackground(this.errorBgColor);
            return false;
        }
        try {
            if (Integer.parseInt(this.featureTreeMinBranchingFactorTextField.getText().trim()) < 0) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            this.setMessage("Minimum branching factor must be greater or equal to 0");
            this.featureTreeMinBranchingFactorTextField.setBackground(this.errorBgColor);
            return false;
        }
        try {
            if (Integer.parseInt(this.featureTreeMaxBranchingFactorTextField.getText().trim()) < Integer.parseInt(this.featureTreeMinBranchingFactorTextField.getText().trim())) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            this.setMessage("Maximum branching factor must be greater than minimum factor");
            this.featureTreeMaxBranchingFactorTextField.setBackground(this.errorBgColor);
            return false;
        }
        try {
            if (Integer.parseInt(this.featureTreeMaxFeatureGroupSizeTextField.getText().trim()) < 0) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            this.setMessage("Maximum group size must be a positive integer");
            this.featureTreeMaxFeatureGroupSizeTextField.setBackground(this.errorBgColor);
            return false;
        }
        try {
            if (Integer.parseInt(this.ctcrTextField.getText().trim()) < 0 || Integer.parseInt(this.ctcrTextField.getText().trim()) > 100) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            this.setMessage("CTCR % must be between 0 and 100");
            this.ctcrTextField.setBackground(this.errorBgColor);
            return false;
        }
        try {
            if (Float.parseFloat(this.ctcClauseDensityTextField.getText().trim()) < 0.0f) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            this.setMessage("CTC Clause Density must be a non-negative float number (e.g., 0.5, 1.3)");
            this.ctcClauseDensityTextField.setBackground(this.errorBgColor);
            return false;
        }
        this.clearErrorMessage();
        return true;
    }
}

