/*
 * Decompiled with CFR 0.152.
 */
package splar.apps.generator;

import splar.apps.generator.FMGeneratorEngine;
import splar.apps.generator.FMGeneratorEngineListener;
import splar.apps.generator.FMGeneratorGUI;
import splar.apps.generator.FMGeneratorGUIEvent;
import splar.apps.generator.FMGeneratorGUIListener;

public class FMGeneratorMain
implements FMGeneratorGUIListener,
FMGeneratorEngineListener {
    FMGeneratorGUI gui = null;
    FMGeneratorEngine engine = null;

    public static void main(String[] args) {
        new FMGeneratorMain().run();
    }

    public void run() {
        this.gui = new FMGeneratorGUI("SPLOT 3-CNF Feature Model Generator - Marcilio Mendonca - Sept 2009 (alfa version) - (www.splot-research.org)");
        this.gui.setSize(600, 700);
        this.gui.setLocation(0, 0);
        this.gui.setVisible(true);
        this.gui.addListener(this);
        this.gui.setDefaultCloseOperation(3);
        this.engine = new FMGeneratorEngine();
        this.engine.addListener(this);
    }

    private void dumpEngineParameters() {
        this.gui.addMessage("Collection name......: " + this.gui.getCollectionName());
        this.gui.addMessage("Collection path......: " + this.gui.getCollectionPath());
        this.gui.addMessage("Collection size......: " + this.gui.getCollectionSize());
        this.gui.addMessage("FT size (# features).: " + this.gui.getFeatureTreeSize());
        this.gui.addMessage("FT % Mandatory.......: " + this.gui.getFeatureTreeMandatoryPercentage());
        this.gui.addMessage("FT % Optional........: " + this.gui.getFeatureTreeOptionalPercentage());
        this.gui.addMessage("FT % XOR groups......: " + this.gui.getFeatureTreeExclusiveORPercentage());
        this.gui.addMessage("FT % OR groups.......: " + this.gui.getFeatureTreeInclusiveORPercentage());
        this.gui.addMessage("FT Min Branch. Factor: " + this.gui.getFeatureTreeMinBranchingFactor());
        this.gui.addMessage("FT Max Branch. Factor: " + this.gui.getFeatureTreeMaxBranchingFactor());
        this.gui.addMessage("FT Max Group Size....: " + this.gui.getFeatureTreeMaxFeatureGroupSize());
        this.gui.addMessage("CTCR.................: " + this.gui.getCTCR());
        this.gui.addMessage("CTC Clause Density...:" + this.gui.getCTCClauseDensity());
        this.gui.addMessage("Consistency Option...: " + this.gui.getConsistentyOption());
    }

    private void runGeneratorEngine() {
        this.engine.setCollectionName(this.gui.getCollectionName());
        this.engine.setCollectionPath(this.gui.getCollectionPath());
        this.engine.setCollectionSize(this.gui.getCollectionSize());
        this.engine.setFeatureModelSize(this.gui.getFeatureTreeSize());
        this.engine.setMandatoryPercentage(this.gui.getFeatureTreeMandatoryPercentage());
        this.engine.setOptionalPercentage(this.gui.getFeatureTreeOptionalPercentage());
        this.engine.setExclusiveORPercentage(this.gui.getFeatureTreeExclusiveORPercentage());
        this.engine.setInclusiveORPercentage(this.gui.getFeatureTreeInclusiveORPercentage());
        this.engine.setMinimumBranchingFactor(this.gui.getFeatureTreeMinBranchingFactor());
        this.engine.setMaximumBranchingFactor(this.gui.getFeatureTreeMaxBranchingFactor());
        this.engine.setMaximumGroupSize(this.gui.getFeatureTreeMaxFeatureGroupSize());
        this.engine.setCTCR(this.gui.getCTCR());
        this.engine.setClauseDensity(this.gui.getCTCClauseDensity());
        this.engine.setModelConsistency(this.gui.getConsistentyOption());
        this.engine.run();
    }

    @Override
    public void startGeneration(FMGeneratorGUIEvent event) {
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    FMGeneratorMain.this.gui.disableGeneration();
                    FMGeneratorMain.this.gui.enableCancelGeneration();
                    FMGeneratorMain.this.gui.clearMessages();
                    long startTime = System.currentTimeMillis();
                    FMGeneratorMain.this.dumpEngineParameters();
                    FMGeneratorMain.this.runGeneratorEngine();
                    FMGeneratorMain.this.gui.addMessage(">> Generation Time: " + (System.currentTimeMillis() - startTime) / 1000L + " seg");
                    FMGeneratorMain.this.gui.disableCancelGeneration();
                    FMGeneratorMain.this.gui.enableGeneration();
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void cancelGeneration() {
        this.gui.disableCancelGeneration();
        this.engine.cancel();
        this.gui.enableGeneration();
    }

    @Override
    public void generatingModel(String modelName) {
        this.gui.setMessage("Generating model: " + modelName);
    }

    @Override
    public void doneGeneratingModel(String modelName) {
    }

    @Override
    public void modelAccepted(String modelName) {
        this.gui.addMessage(">> Model generated: " + modelName);
    }

    @Override
    public void modelRejected(String modelName, String reason) {
        this.gui.addMessage("Model rejected: " + modelName + " (reason = " + reason + " )");
    }

    @Override
    public void modelGenerationStarted() {
    }

    @Override
    public void modelGenerationEnded() {
        this.gui.setMessage("Done!");
    }

    @Override
    public void modelIsUnsat(String modelName) {
    }

    @Override
    public void modelIsSat(String modelName) {
    }

    @Override
    public void errorDuringGeneration(String modelName, String errorMessage) {
    }

    @Override
    public void generationCanceled() {
        this.gui.addMessage("Generation canceled by user");
        this.gui.setMessage("Generation canceled by user");
    }
}

