/*
 * Decompiled with CFR 0.152.
 */
package splar.core.constraints;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import splar.core.constraints.BooleanVariableInterface;
import splar.core.constraints.CNFLiteral;

public class CNFClause {
    private Vector<CNFLiteral> literals = new Vector();

    public void addLiteral(CNFLiteral literal) {
        this.literals.add(literal);
    }

    public List<BooleanVariableInterface> getVariables() {
        Vector<BooleanVariableInterface> variables = new Vector<BooleanVariableInterface>();
        Iterator<CNFLiteral> it = this.literals.iterator();
        while (it.hasNext()) {
            variables.add(it.next().getVariable());
        }
        return variables;
    }

    public int calculateSpan(Map<String, Integer> variable2indexMap) {
        int min = Integer.MAX_VALUE;
        int max = -1;
        Iterator<CNFLiteral> it = this.literals.iterator();
        while (it.hasNext()) {
            BooleanVariableInterface variable = it.next().getVariable();
            Integer order = variable2indexMap.get(variable.getID());
            if (order == null) continue;
            if (order < min) {
                min = order;
            }
            if (order <= max) continue;
            max = order;
        }
        return max - min;
    }

    public List<CNFLiteral> getLiterals() {
        return this.literals;
    }

    public int countLiterals() {
        return this.literals.size();
    }

    public int countVariables() {
        return this.getVariables().size();
    }

    public int hashCode() {
        return this.literals.hashCode();
    }

    public boolean equals(Object o) {
        CNFClause clause = (CNFClause)o;
        if (clause.getLiterals().size() != this.getLiterals().size()) {
            return false;
        }
        for (CNFLiteral literal : clause.getLiterals()) {
            if (this.getLiterals().contains(literal)) continue;
            return false;
        }
        for (CNFLiteral literal : this.getLiterals()) {
            if (clause.getLiterals().contains(literal)) continue;
            return false;
        }
        return true;
    }

    public String toPropositionalFormula() {
        String formula = "";
        Iterator<CNFLiteral> it = this.literals.iterator();
        while (it.hasNext()) {
            CNFLiteral literal = it.next();
            formula = formula + (literal.isPositive() ? literal.getVariable().getID() : "~" + literal.getVariable().getID());
            if (!it.hasNext()) continue;
            formula = formula + " OR ";
        }
        return formula;
    }

    public String toString() {
        StringBuffer toString = new StringBuffer(100);
        Iterator<CNFLiteral> it = this.literals.iterator();
        while (it.hasNext()) {
            toString.append(it.next());
            if (!it.hasNext()) continue;
            toString.append(" or ");
        }
        return toString.toString();
    }

    public String toString2() {
        StringBuffer toString = new StringBuffer(100);
        Iterator<CNFLiteral> it = this.literals.iterator();
        while (it.hasNext()) {
            toString.append(it.next().toString2());
            if (!it.hasNext()) continue;
            toString.append(" or ");
        }
        return toString.toString();
    }
}

