/*
 * Decompiled with CFR 0.152.
 */
package splar.core.constraints;

import java.util.Map;
import splar.core.constraints.BooleanVariable;
import splar.core.constraints.PropositionalFormula;

class PFParser {
    protected int index = 0;
    private static final int AND = 1;
    private static final int OR = 2;
    private static final int IMP = 3;
    private static final int BIIMP = 4;
    protected static String letters = "_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    protected static String digits = "0123456789";
    protected static String others = "_";
    protected String all = letters + digits + others;
    protected PropositionalFormula pformula;
    protected String parsedFormula = "";
    protected Map<String, String> replacements;

    public PFParser(PropositionalFormula pformula) {
        this.pformula = pformula;
        this.replacements = null;
    }

    public String replace(Map<String, String> replacements) throws Exception {
        this.parsedFormula = "";
        this.replacements = replacements;
        this.parse();
        return this.parsedFormula;
    }

    public void parse() throws Exception {
        this.parsedFormula = "";
        this.parse(this.pformula.getFormula());
    }

    protected void parse(String formula) throws Exception {
        this.index = 0;
        this.F(formula.trim());
    }

    protected String currentChar(String formula) {
        return formula.substring(this.index, this.index + 1);
    }

    protected void F(String formula) throws Exception {
        if (!this.EOF(formula)) {
            if (this.currentChar(formula).equals("~")) {
                this.parsedFormula = this.parsedFormula + "~";
                this.incrementIndex(formula);
                this.skipBlanks(formula);
                if (this.isLetter(this.currentChar(formula))) {
                    this.parsedFormula = this.parsedFormula + this.extractVar(formula, false);
                }
                this.skipBlanks(formula);
                this.parsedFormula = this.parsedFormula + " ";
                if (!this.EOF(formula) && (this.isLetter(this.currentChar(formula)) || this.currentChar(formula).equals("&") || this.currentChar(formula).equals("|") || this.currentChar(formula).equals("-") || this.currentChar(formula).equals("<"))) {
                    this.parsedFormula = this.parsedFormula + this.operator(formula);
                    this.skipBlanks(formula);
                    this.parsedFormula = this.parsedFormula + " ";
                }
            } else if (this.currentChar(formula).equals("(")) {
                this.parsedFormula = this.parsedFormula + "(";
                this.incrementIndex(formula);
                this.skipBlanks(formula);
                this.parsedFormula = this.parsedFormula + " ";
                this.F(formula);
                if (!this.currentChar(formula).equals(")")) {
                    throw new Exception("Error on formula " + this.pformula.getFormula() + " at index (" + this.index + ")");
                }
                this.parsedFormula = this.parsedFormula + ")";
                this.incrementIndex(formula);
                if (!this.EOF(formula)) {
                    this.skipBlanks(formula);
                    this.parsedFormula = this.parsedFormula + " ";
                    if (this.isLetter(this.currentChar(formula)) || this.currentChar(formula).equals("&") || this.currentChar(formula).equals("|") || this.currentChar(formula).equals("-") || this.currentChar(formula).equals("<")) {
                        this.parsedFormula = this.parsedFormula + this.operator(formula);
                        this.skipBlanks(formula);
                        this.parsedFormula = this.parsedFormula + " ";
                        this.F(formula);
                    } else if (!this.currentChar(formula).equals(")")) {
                        throw new Exception("Error at index (" + this.index + ")");
                    }
                }
            } else {
                this.parsedFormula = this.parsedFormula + this.extractVar(formula, true);
                this.skipBlanks(formula);
                this.parsedFormula = this.parsedFormula + " ";
                if (!this.EOF(formula) && !this.currentChar(formula).startsWith(")")) {
                    this.parsedFormula = this.parsedFormula + this.operator(formula);
                    this.skipBlanks(formula);
                    this.parsedFormula = this.parsedFormula + " ";
                    this.F(formula);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String operator(String formula) throws Exception {
        int op = -1;
        String opStr = "<error>";
        if (this.isLetter(this.currentChar(formula))) {
            opStr = this.extractOperator(formula);
            if (opStr.compareToIgnoreCase("and") == 0) {
                op = 1;
            } else if (opStr.compareToIgnoreCase("or") == 0) {
                op = 2;
            } else if (opStr.compareToIgnoreCase("imp") == 0) {
                op = 3;
            } else {
                if (opStr.compareToIgnoreCase("biimp") != 0) throw new Exception("Error at index (" + this.index + ")");
                op = 4;
            }
        } else if (this.currentChar(formula).startsWith("|")) {
            this.incrementIndex(formula);
            op = 2;
        } else if (this.currentChar(formula).startsWith("&")) {
            this.incrementIndex(formula);
            op = 1;
        } else if (this.currentChar(formula).startsWith("-")) {
            this.incrementIndex(formula);
            if (!this.currentChar(formula).startsWith(">")) {
                throw new Exception("Error at index (" + this.index + ")");
            }
            this.incrementIndex(formula);
            op = 3;
        } else if (this.currentChar(formula).startsWith("<")) {
            this.incrementIndex(formula);
            if (!this.currentChar(formula).startsWith("-")) {
                throw new Exception("Error at index (" + this.index + ")");
            }
            this.incrementIndex(formula);
            if (!this.currentChar(formula).startsWith(">")) {
                throw new Exception("Error at index (" + this.index + ")");
            }
            this.incrementIndex(formula);
            op = 4;
        }
        if (op != -1) return opStr;
        throw new Exception("Error at index (" + this.index + "): Invalid operator!");
    }

    private String extractOperator(String formula) {
        StringBuffer opName = new StringBuffer();
        if (this.isLetter(this.currentChar(formula))) {
            opName.append(this.currentChar(formula));
            this.incrementIndex(formula);
            while (!this.EOF(formula) && this.isValidChar(this.currentChar(formula))) {
                opName.append(this.currentChar(formula));
                this.incrementIndex(formula);
            }
        }
        return opName.toString();
    }

    protected String extractVar(String formula, boolean varState) {
        String varName = "";
        if (this.isLetter(this.currentChar(formula))) {
            String newVarName;
            varName = varName + this.currentChar(formula);
            this.incrementIndex(formula);
            while (!this.EOF(formula) && this.isValidChar(this.currentChar(formula))) {
                varName = varName + this.currentChar(formula);
                this.incrementIndex(formula);
            }
            if (this.replacements != null && (newVarName = this.replacements.get(varName)) != null) {
                varName = newVarName;
            }
            BooleanVariable variable = new BooleanVariable(varName);
            variable.setState(varState);
            this.pformula.addVariable(variable);
        }
        return varName;
    }

    protected boolean EOF(String formula) {
        return this.index >= formula.length();
    }

    protected boolean isLetter(String str) {
        return letters.indexOf(str) != -1;
    }

    protected boolean isValidChar(String str) {
        return this.all.indexOf(str) != -1;
    }

    protected void skipBlanks(String formula) {
        if (!this.EOF(formula)) {
            while (this.currentChar(formula).startsWith(" ")) {
                this.incrementIndex(formula);
            }
        }
    }

    protected void incrementIndex(String formula) {
        ++this.index;
    }
}

