/*
 * Decompiled with CFR 0.152.
 */
package splar.core.constraints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import splar.core.constraints.Assignment;
import splar.core.constraints.BooleanVariable;
import splar.core.constraints.CNFClause;
import splar.core.constraints.CNFLiteral;
import splar.core.constraints.PFParser;
import splar.core.constraints.PropositionalFormulaState;
import splar.core.util.hypergraphs.Hyperedge;
import splar.core.util.hypergraphs.Hypergraph;
import splar.core.util.hypergraphs.Vertex;

public class PropositionalFormula {
    protected String name;
    protected ArrayList<BooleanVariable> variables;
    protected String formula;
    protected PFParser parser;
    protected HashMap<String, PropositionalFormulaState> states;

    public PropositionalFormula(String name, String formula) throws Exception {
        this.name = name;
        this.formula = formula;
        this.variables = new ArrayList();
        this.states = new HashMap();
        this.parser = new PFParser(this);
        this.parser.parse();
    }

    public void appendToFormula(String formulaPart) {
        this.formula = this.formula + formulaPart;
    }

    public void appendToVariables(BooleanVariable var) {
        assert (!this.variables.contains(var));
        this.variables.add(var);
    }

    public void replaceVariable(String oldName, String newName) {
        this.variables = new ArrayList();
        try {
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put(oldName, newName);
            this.formula = new PFParser(this).replace(replacements);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Assignment getInstantiatedVariables() {
        Assignment a = new Assignment();
        for (BooleanVariable var : this.variables) {
            if (!var.isInstantiated()) continue;
            a.add(var);
        }
        return a;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return "undefined-type";
    }

    public String getVariableListAsString() {
        return "" + this.variables;
    }

    public Collection<BooleanVariable> getVariables() {
        return this.variables;
    }

    protected void addVariable(BooleanVariable var) {
        if (!this.variables.contains(var)) {
            var.assignValue(-1);
            this.variables.add(var);
        }
    }

    public BooleanVariable getVariable(String name) {
        return this.variables.get(this.getIndex(name));
    }

    protected void removeVariable(BooleanVariable var) {
        this.variables.remove(this.variables.get(this.getIndex(this.getName())));
    }

    public String toString() {
        return this.toCNFClauses().toArray(new CNFClause[0])[0].toString();
    }

    public int getIndex(String varName) {
        int length = this.variables.size();
        for (int i = 0; i < length; ++i) {
            BooleanVariable vi = this.variables.get(i);
            if (!vi.getID().equals(varName)) continue;
            return i;
        }
        return -1;
    }

    public void saveState(String stateID) {
        if (!this.states.containsKey(stateID)) {
            PropositionalFormulaState state = new PropositionalFormulaState(this);
            state.save();
            this.states.put(stateID, state);
        }
    }

    public void restoreState(String stateID) {
        PropositionalFormulaState state = this.states.get(stateID);
        state.restore();
        this.states.remove(stateID);
    }

    public void discardState(String stateID) {
        this.states.remove(stateID);
    }

    public void assignValue(String varName, int value) {
        BooleanVariable var = this.variables.get(this.getIndex(varName));
        if (var != null) {
            var.assignValue(value);
        }
    }

    public int countVars() {
        return this.variables.size();
    }

    public String getFormula() {
        return this.formula;
    }

    public Hypergraph buildHyperGraph() {
        Hypergraph hGraph = new Hypergraph();
        Hyperedge hyperEdge = new Hyperedge();
        Iterator<BooleanVariable> it = this.variables.iterator();
        while (it.hasNext()) {
            String varName = it.next().getID();
            Vertex vertex = new Vertex(varName);
            hGraph.addVertex(vertex);
            hyperEdge.addVertex(vertex);
        }
        hGraph.addHyperEdge(hyperEdge);
        return hGraph;
    }

    public Collection<CNFClause> toCNFClauses() {
        Vector<CNFClause> clauses = new Vector<CNFClause>();
        CNFClause clause = new CNFClause();
        for (BooleanVariable variable : this.variables) {
            clause.addLiteral(new CNFLiteral(variable, variable.isPositive()));
        }
        clauses.add(clause);
        return clauses;
    }
}

