/*
 * Decompiled with CFR 0.152.
 */
package splar.core.fm;

import java.util.LinkedList;
import java.util.List;
import splar.core.fm.FTTraversalNodeSelector;
import splar.core.fm.FeatureTreeNode;

public class FTTraversals {
    public static List<FeatureTreeNode> dfs(FeatureTreeNode node, FTTraversalNodeSelector selector) {
        LinkedList<FeatureTreeNode> nodes = new LinkedList<FeatureTreeNode>();
        FTTraversals.dfs(node, nodes, selector);
        return nodes;
    }

    public static List<FeatureTreeNode> bfs(FeatureTreeNode node, FTTraversalNodeSelector selector) {
        LinkedList<FeatureTreeNode> nodes = new LinkedList<FeatureTreeNode>();
        FTTraversals.bfs(node, nodes, selector);
        return nodes;
    }

    private static void dfs(FeatureTreeNode node, List<FeatureTreeNode> nodes, FTTraversalNodeSelector selector) {
        if (node != null && selector != null && selector.select(node)) {
            nodes.add(node);
        }
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            FTTraversals.dfs((FeatureTreeNode)node.getChildAt(i), nodes, selector);
        }
    }

    private static void bfs(FeatureTreeNode node, List<FeatureTreeNode> nodes, FTTraversalNodeSelector selector) {
        LinkedList<FeatureTreeNode> toProcess = new LinkedList<FeatureTreeNode>();
        if (node != null) {
            toProcess.add(node);
        }
        while (!toProcess.isEmpty()) {
            FeatureTreeNode curNode = (FeatureTreeNode)toProcess.pollFirst();
            if (selector.select(curNode)) {
                nodes.add(curNode);
            }
            int count = curNode.getChildCount();
            for (int i = 0; i < count; ++i) {
                toProcess.add((FeatureTreeNode)curNode.getChildAt(i));
            }
        }
    }
}

