/*
 * Decompiled with CFR 0.152.
 */
package splar.core.fm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import splar.core.fm.FeatureTreeNode;
import splar.core.fm.IFNodeRenderer;

public class NodeRenderer
implements IFNodeRenderer {
    private static final Color trueNodeColor = new Color(50, 160, 50);
    private static final Color falseNodeColor = new Color(140, 140, 160);
    private ImageIcon imageIcon = null;
    private String imgPath = null;
    private JLabel nodeDescriptionLabel = null;
    private JLabel nodeValueLabel = null;
    private JLabel nodeImageLabel = null;
    private JPanel nodeDescriptionPanel = null;
    private JPanel nodeValuePanel = null;
    private JPanel nodeImagePanel = null;
    private JPanel panel = null;
    private Color bgDefaultColor = Color.WHITE;
    private Color fgDefaultColor = Color.BLACK;
    private Color bgColor = this.bgDefaultColor;
    private Color fgColor = this.fgDefaultColor;
    private boolean displayTruthValue;

    public NodeRenderer(String imgPath, String imgFile, String description, boolean displayTruthValue) {
        this.imgPath = imgPath;
        this.displayTruthValue = displayTruthValue;
        this.panel = new JPanel(new BorderLayout());
        if (displayTruthValue) {
            this.nodeValueLabel = new JLabel("", 2);
            this.nodeValuePanel = new JPanel(new BorderLayout());
            this.nodeValuePanel.add((Component)this.nodeValueLabel, "Center");
        }
        this.nodeDescriptionLabel = new JLabel("", 2);
        this.nodeImageLabel = new JLabel("", this.imageIcon, 2);
        this.nodeDescriptionPanel = new JPanel(new BorderLayout());
        this.nodeDescriptionPanel.add((Component)this.nodeDescriptionLabel, "Center");
        this.nodeImagePanel = new JPanel(new BorderLayout());
        this.nodeImagePanel.add((Component)this.nodeImageLabel, "Center");
        this.nodeImagePanel.setBackground(Color.white);
        JPanel nodePanel = new JPanel(new BorderLayout(3, 3));
        nodePanel.setBackground(Color.white);
        nodePanel.add((Component)this.nodeImagePanel, "West");
        if (displayTruthValue) {
            nodePanel.add((Component)this.nodeValuePanel, "Center");
            nodePanel.add((Component)this.nodeDescriptionPanel, "East");
        } else {
            nodePanel.add((Component)this.nodeDescriptionPanel, "Center");
        }
        this.panel.add((Component)nodePanel, "Center");
    }

    @Override
    public void setBackgroundColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    @Override
    public void setForegroundColor(Color fgColor) {
        this.fgColor = fgColor;
    }

    @Override
    public Color getBackgroundColor() {
        return this.bgColor;
    }

    @Override
    public Color getForegroundColor() {
        return this.fgColor;
    }

    @Override
    public void resetDefaults() {
        this.bgColor = this.bgDefaultColor;
        this.fgColor = this.fgDefaultColor;
        this.nodeValueLabel.setForeground(this.fgColor);
        this.nodeValueLabel.setBackground(this.bgColor);
        this.nodeDescriptionLabel.setForeground(this.fgColor);
        this.nodeDescriptionLabel.setBackground(this.bgColor);
    }

    protected static ImageIcon createImageIcon(String path, String description) {
        try {
            URL imgURL = new URL(path);
            if (imgURL != null) {
                return new ImageIcon(imgURL, description);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public JComponent getRenderedComponent(FeatureTreeNode node) {
        if (this.displayTruthValue) {
            ImageIcon valueIcon = null;
            if (node.getValue() == -1) {
                valueIcon = NodeRenderer.createImageIcon(this.imgPath + "unknown.jpg", "");
                this.nodeValuePanel.setBackground(this.bgColor);
                this.nodeValueLabel.setIcon(valueIcon);
            } else if (node.getValue() == 1) {
                valueIcon = NodeRenderer.createImageIcon(this.imgPath + "true.jpg", "");
                this.nodeDescriptionLabel.setForeground(trueNodeColor);
            } else if (node.getValue() == 0) {
                valueIcon = NodeRenderer.createImageIcon(this.imgPath + "false.jpg", "");
                this.nodeDescriptionLabel.setForeground(falseNodeColor);
            }
            this.nodeValueLabel.setIcon(valueIcon);
        }
        this.nodeDescriptionLabel.setText(node.getDescription());
        this.nodeDescriptionPanel.setBackground(this.bgColor);
        this.panel.setBackground(this.bgColor);
        return this.panel;
    }
}

