/*
 * Decompiled with CFR 0.152.
 */
package splar.core.fm.randomization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import splar.core.constraints.BooleanVariableInterface;
import splar.core.constraints.PropositionalFormula;
import splar.core.fm.FeatureGroup;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureModelException;
import splar.core.fm.FeatureTreeNode;
import splar.core.fm.GroupedFeature;
import splar.core.fm.RootNode;
import splar.core.fm.SolitaireFeature;
import splar.core.fm.TreeNodeRendererFactory;

public class RandomFeatureTreeModel
extends FeatureModel {
    private int numberOfFeatures;
    private int childFeaturesOdds;
    private int minChildFeature;
    private int solitaireOdds;
    private int groupOdds;
    private int minGroupCard;
    private int maxGroupCard;

    public RandomFeatureTreeModel(int numberOfFeatures, int solitaireOdds, int groupOdds, int minChildFeature, int minGroupCard, int maxGroupCard) {
        this.numberOfFeatures = numberOfFeatures;
        this.childFeaturesOdds = solitaireOdds + groupOdds;
        this.minChildFeature = minChildFeature;
        this.solitaireOdds = solitaireOdds;
        this.groupOdds = groupOdds;
        this.minGroupCard = minGroupCard;
        this.maxGroupCard = maxGroupCard;
    }

    @Override
    protected FeatureTreeNode createNodes() throws FeatureModelException {
        int countFeatures = 1;
        Vector<FeatureTreeNode> fmNodes = new Vector<FeatureTreeNode>();
        String featureName = "R";
        ++countFeatures;
        RootNode root = new RootNode(featureName, featureName, TreeNodeRendererFactory.createRootRenderer());
        fmNodes.add(root);
        FeatureTreeNode parentNode = null;
        while (countFeatures <= this.numberOfFeatures) {
            parentNode = (FeatureTreeNode)fmNodes.firstElement();
            fmNodes.removeElement(parentNode);
            int numberOfChildNodesToCreate = Math.min(this.numberOfFeatures - countFeatures + 1, Math.abs(new Random().nextInt()) % (this.childFeaturesOdds - this.minChildFeature + 1) + this.minChildFeature);
            if (numberOfChildNodesToCreate == 0 && fmNodes.size() == 0) {
                numberOfChildNodesToCreate = 1;
            }
            if (numberOfChildNodesToCreate <= 0) continue;
            for (int i = 0; i < numberOfChildNodesToCreate && countFeatures <= this.numberOfFeatures; ++i) {
                String childFeatureName = parentNode.getID().substring(1) + (i + 1);
                FeatureTreeNode randomNode = this.createRandomNode(childFeatureName, this.solitaireOdds, this.groupOdds, this.minGroupCard, this.maxGroupCard);
                parentNode.add(randomNode);
                if (randomNode instanceof FeatureGroup) {
                    FeatureGroup groupRandomNode = (FeatureGroup)randomNode;
                    int countGroupedNodes = groupRandomNode.getChildCount();
                    for (int j = 0; j < countGroupedNodes; ++j) {
                        fmNodes.add((FeatureTreeNode)groupRandomNode.getChildAt(j));
                    }
                    countFeatures += countGroupedNodes;
                    continue;
                }
                fmNodes.add(randomNode);
                ++countFeatures;
            }
        }
        return root;
    }

    private FeatureTreeNode createRandomNode(String childFeatureName, int solitaireOdds, int groupOdds, int minGroupCard, int maxGroupCard) {
        int solitaireOrGroupRandom = new Random().nextInt() % this.childFeaturesOdds + 1;
        FeatureTreeNode node = null;
        String featureName = "";
        if (solitaireOrGroupRandom <= solitaireOdds) {
            featureName = "S" + childFeatureName;
            node = new SolitaireFeature(true, featureName, featureName, TreeNodeRendererFactory.createOptionalRenderer());
        } else {
            int groupSize = Math.abs(new Random().nextInt()) % (maxGroupCard - minGroupCard + 1) + minGroupCard;
            int groupTypeOdds = new Random().nextInt() % 2;
            int lower = 1;
            int upper = 1;
            if (groupTypeOdds == 0) {
                upper = -1;
            }
            String groupName = "_G" + childFeatureName;
            node = new FeatureGroup(groupName, groupName, lower, upper, TreeNodeRendererFactory.createFeatureGroupRenderer());
            for (int i = 0; i < groupSize; ++i) {
                featureName = "g" + childFeatureName + (i + 1);
                node.add(new GroupedFeature(featureName, featureName, TreeNodeRendererFactory.createGroupedRenderer()));
            }
        }
        return node;
    }

    public static Vector<PropositionalFormula> createExtraConstraints(FeatureModel fm, int numVars, int numConstraints, int minVarsLeft, int maxVarsLeft, int minVarsRight, int maxVarsRight) {
        Vector<PropositionalFormula> pfs = new Vector<PropositionalFormula>();
        if (fm != null && numConstraints > 0 && numVars > 1) {
            ArrayList<BooleanVariableInterface> vars = RandomFeatureTreeModel.chooseVariablesForConstraints(fm, numVars);
            int varIndex = 0;
            for (int i = 0; i < numConstraints; ++i) {
                int form;
                String v;
                int j;
                String constraint = "";
                int leftVarsToPick = new Random().nextInt() % (maxVarsLeft - minVarsLeft + 1) + minVarsLeft;
                int RightVarsToPick = new Random().nextInt() % (maxVarsRight - minVarsLeft + 1) + minVarsRight;
                int leftOp = new Random().nextInt() % 2;
                int RightOp = new Random().nextInt() % 2;
                constraint = constraint + "(";
                for (j = 0; j < leftVarsToPick - 1; ++j) {
                    v = vars.get(varIndex).getID();
                    form = new Random().nextInt() % 2;
                    constraint = form == 0 ? constraint + "" + v : constraint + "~" + v;
                    constraint = leftOp == 0 ? constraint + " OR " : constraint + " OR ";
                    int n = varIndex = varIndex < numVars - 1 ? varIndex + 1 : 0;
                    if (varIndex != 0) continue;
                    RandomFeatureTreeModel.scrumbleVars(vars);
                }
                v = vars.get(varIndex).getID();
                form = new Random().nextInt() % 2;
                constraint = form == 0 ? constraint + "" + v : constraint + "~" + v;
                constraint = constraint + ") OR (";
                int n = varIndex = varIndex < numVars - 1 ? varIndex + 1 : 0;
                if (varIndex == 0) {
                    RandomFeatureTreeModel.scrumbleVars(vars);
                }
                for (j = 0; j < RightVarsToPick - 1; ++j) {
                    v = vars.get(varIndex).getID();
                    form = new Random().nextInt() % 2;
                    constraint = form == 0 ? constraint + "" + v : constraint + "~" + v;
                    constraint = RightOp == 0 ? constraint + " OR " : constraint + " OR ";
                    int n2 = varIndex = varIndex < numVars - 1 ? varIndex + 1 : 0;
                    if (varIndex != 0) continue;
                    RandomFeatureTreeModel.scrumbleVars(vars);
                }
                v = vars.get(varIndex).getID();
                form = new Random().nextInt() % 2;
                constraint = form == 0 ? constraint + "" + v : constraint + "~" + v;
                constraint = constraint + ")";
                int n3 = varIndex = varIndex < numVars - 1 ? varIndex + 1 : 0;
                if (varIndex == 0) {
                    RandomFeatureTreeModel.scrumbleVars(vars);
                }
                try {
                    pfs.add(new PropositionalFormula("C" + (i + 1), constraint));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return pfs;
    }

    private static void scrumbleVars(ArrayList<BooleanVariableInterface> vars) {
        int numVars = vars.size();
        for (int i = 0; i < numVars; ++i) {
            int index = Math.abs(new Random().nextInt() % numVars);
            BooleanVariableInterface temp = vars.get(index);
            vars.set(index, vars.get(i));
            vars.set(i, temp);
        }
    }

    private static ArrayList<BooleanVariableInterface> chooseVariablesForConstraints(FeatureModel fm, int numVars) {
        ArrayList<BooleanVariableInterface> vars = new ArrayList<BooleanVariableInterface>(numVars);
        Collection<FeatureTreeNode> nodes = fm.getNodes();
        int numNodes = nodes.size();
        int varsGen = 0;
        while (varsGen < numVars) {
            int random = Math.abs(new Random().nextInt() % numNodes);
            Iterator<FeatureTreeNode> it = nodes.iterator();
            for (int i = 0; i < random - 1; ++i) {
                it.next();
            }
            FeatureTreeNode node = it.next();
            if (node instanceof FeatureGroup || node instanceof RootNode || vars.contains(node)) continue;
            vars.add(node);
            ++varsGen;
        }
        return vars;
    }

    @Override
    public void saveNodes() {
    }
}

