/*
 * Decompiled with CFR 0.152.
 */
package splar.core.heuristics;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Stack;
import splar.core.constraints.BooleanVariableInterface;
import splar.core.constraints.CNFClause;
import splar.core.constraints.CNFFormula;
import splar.core.constraints.PropositionalFormula;
import splar.core.fm.FeatureGroup;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureTreeNode;
import splar.core.heuristics.FORCEVariableOrderingHeuristic;
import splar.core.heuristics.FTTraversalHeuristic;
import splar.core.heuristics.VariableOrderingHeuristic;

public class ECFT_FORCEPreOrderHeuristic
extends FTTraversalHeuristic {
    public ECFT_FORCEPreOrderHeuristic(String name, FeatureModel featureModel) {
        super(name, featureModel);
    }

    @Override
    public String[] runHeuristic(CNFFormula cnf) {
        LinkedHashSet<String> variables = new LinkedHashSet<String>();
        for (PropositionalFormula formula : this.featureModel.getConstraints()) {
            for (CNFClause clause : formula.toCNFClauses()) {
                for (BooleanVariableInterface booleanVariableInterface : clause.getVariables()) {
                    if (variables.contains(booleanVariableInterface.getID())) continue;
                    variables.add(booleanVariableInterface.getID());
                }
            }
        }
        FORCEVariableOrderingHeuristic heuristic = new FORCEVariableOrderingHeuristic("FORCE", VariableOrderingHeuristic.variableOrderingAsBooleanVariableArray(variables.toArray(new String[0])), 1);
        String[] order = heuristic.run(this.featureModel.EC2CNF());
        variables.clear();
        for (String string : order) {
            variables.add(string);
        }
        Set<BooleanVariableInterface> cnfVariables = cnf.getVariables();
        Stack<FeatureTreeNode> nodes = new Stack<FeatureTreeNode>();
        nodes.push(this.getFeatureModel().getRoot());
        while (nodes.size() > 0) {
            FeatureTreeNode curNode = (FeatureTreeNode)nodes.pop();
            if (curNode == null) continue;
            if (!(curNode instanceof FeatureGroup) && cnfVariables.contains(curNode) && !variables.contains(curNode.getID())) {
                variables.add(curNode.getID());
            }
            FeatureTreeNode[] featureTreeNodeArray = this.orderChildNodes(curNode);
            for (int i = featureTreeNodeArray.length - 1; i >= 0; --i) {
                nodes.push(featureTreeNodeArray[i]);
            }
        }
        return variables.toArray(new String[0]);
    }

    protected FeatureTreeNode[] orderChildNodes(FeatureTreeNode node) {
        int count = node.getChildCount();
        FeatureTreeNode[] nodes = new FeatureTreeNode[count];
        for (int i = 0; i < count; ++i) {
            nodes[i] = (FeatureTreeNode)node.getChildAt(i);
        }
        return nodes;
    }
}

