/*
 * Decompiled with CFR 0.152.
 */
package splar.core.heuristics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import splar.core.constraints.BooleanVariableInterface;
import splar.core.constraints.CNFClause;
import splar.core.constraints.CNFFormula;
import splar.core.heuristics.VariableOrderingHeuristic;

public class FORCEVariableOrderingHeuristic
extends VariableOrderingHeuristic {
    private final boolean DEBUG = false;
    private static final int maxSpanReductionAttempts = 2;
    private BooleanVariableInterface[] initialVariableOrdering;
    private int numReruns;

    public FORCEVariableOrderingHeuristic(String name, int numReRuns) {
        this(name, null, numReRuns);
    }

    public FORCEVariableOrderingHeuristic(String name, BooleanVariableInterface[] initialVariableOrdering, int numReRuns) {
        super(name);
        this.initialVariableOrdering = initialVariableOrdering;
        this.numReruns = numReRuns;
    }

    @Override
    public void setParameter(String name, Object value) {
        if (name.compareToIgnoreCase("variable_ordering_list") == 0) {
            if (value != null && value instanceof String) {
                String voList = (String)value;
                this.initialVariableOrdering = VariableOrderingHeuristic.variableOrderingAsBooleanVariableArray(voList);
            }
        } else if (name.compareToIgnoreCase("num_reruns") == 0) {
            this.numReruns = Integer.parseInt((String)this.parameters.get("num_reruns"));
        }
        super.setParameter(name, value);
    }

    private BooleanVariableInterface[] getInitialVariableOrdering(CNFFormula cnf) {
        if (this.initialVariableOrdering != null) {
            return this.initialVariableOrdering;
        }
        ArrayList<BooleanVariableInterface> scrambledVariables = new ArrayList<BooleanVariableInterface>();
        scrambledVariables.addAll(cnf.getVariables());
        Collections.shuffle(scrambledVariables);
        return scrambledVariables.toArray(new BooleanVariableInterface[0]);
    }

    @Override
    public String[] runHeuristic(CNFFormula cnf) {
        String[] varOrder = null;
        int runsMinSpan = Integer.MAX_VALUE;
        int numLoops = this.initialVariableOrdering != null ? 1 : this.numReruns;
        for (int runIndex = 1; runIndex <= numLoops; ++runIndex) {
            int span;
            if (numLoops > 1) {
                System.out.println(">> FORCE: run #" + runIndex);
            }
            int countUnsuccessfulSpanReductions = 0;
            BooleanVariableInterface[] outputVariableOrdering = null;
            BooleanVariableInterface[] variables = this.getInitialVariableOrdering(cnf);
            Set<CNFClause> clauses = cnf.getClauses();
            Map<String, Integer> variableMap = VariableOrderingHeuristic.variableOrderingAsHashMap(variables);
            variableMap = VariableOrderingHeuristic.variableOrderingAsHashMap(variables);
            int countVars = variables.length;
            int countClauses = clauses.size();
            outputVariableOrdering = new BooleanVariableInterface[countVars];
            System.arraycopy(variables, 0, outputVariableOrdering, 0, countVars);
            int minSpan = span = cnf.calculateClauseSpan(variableMap);
            int countSteps = 0;
            while (countUnsuccessfulSpanReductions < 2) {
                double[] COG = new double[countClauses];
                int i = 0;
                for (CNFClause clause : clauses) {
                    double orderSum = 0.0;
                    for (BooleanVariableInterface var : clause.getVariables()) {
                        try {
                            orderSum += (double)variableMap.get(var.getID()).intValue();
                        }
                        catch (Exception e) {
                            System.out.println("Var not found: " + var.getID());
                            e.printStackTrace();
                        }
                    }
                    COG[i++] = orderSum / (double)clause.countVariables();
                }
                for (BooleanVariableInterface var : variables) {
                    double sumCOG = 0.0;
                    int countVarClauses = 0;
                    int clauseIndex = 0;
                    for (CNFClause clause : clauses) {
                        if (clause.getVariables().contains(var)) {
                            sumCOG += COG[clauseIndex];
                            ++countVarClauses;
                        }
                        ++clauseIndex;
                    }
                    double varCOG = new Double(sumCOG / (double)countVarClauses);
                    var.attachData(varCOG);
                }
                Comparator<BooleanVariableInterface> comparator = new Comparator<BooleanVariableInterface>(){

                    @Override
                    public int compare(BooleanVariableInterface var1, BooleanVariableInterface var2) {
                        Double var1Score = (Double)var1.getAttachedData();
                        Double var2Score = (Double)var2.getAttachedData();
                        if (var1Score > var2Score) {
                            return 1;
                        }
                        if (var1Score < var2Score) {
                            return -1;
                        }
                        return 0;
                    }

                    public boolean equals(Comparator<BooleanVariableInterface> comparator) {
                        if (comparator == null) {
                            return false;
                        }
                        return comparator == this;
                    }
                };
                Arrays.sort(variables, comparator);
                variableMap = VariableOrderingHeuristic.variableOrderingAsHashMap(variables);
                span = cnf.calculateClauseSpan(variableMap);
                ++countSteps;
                if (span < minSpan) {
                    minSpan = span;
                    System.arraycopy(variables, 0, outputVariableOrdering, 0, countVars);
                    countUnsuccessfulSpanReductions = 0;
                    continue;
                }
                ++countUnsuccessfulSpanReductions;
            }
            if (minSpan >= runsMinSpan) continue;
            if (outputVariableOrdering != null) {
                varOrder = VariableOrderingHeuristic.variableOrderingAsStringVariableArray(outputVariableOrdering);
            }
            runsMinSpan = minSpan;
        }
        return varOrder;
    }
}

