/*
 * Decompiled with CFR 0.152.
 */
package splar.core.heuristics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import splar.core.constraints.CNFFormula;
import splar.core.fm.FeatureGroup;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureTreeNode;
import splar.core.heuristics.FTTraversalHeuristic;

public class FTAverageOrderTraversalHeuristic
extends FTTraversalHeuristic {
    public FTAverageOrderTraversalHeuristic(String name, FeatureModel featureModel) {
        super(name, featureModel);
    }

    @Override
    protected String[] runHeuristic(CNFFormula cnf) {
        List<String> variableOrder = this.recursiveRun(this.featureModel.getRoot());
        Iterator<String> it = variableOrder.iterator();
        while (it.hasNext()) {
            String nodeID = it.next();
            if (!nodeID.startsWith("*")) continue;
            it.remove();
        }
        return variableOrder.toArray(new String[0]);
    }

    protected List<String> recursiveRun(FeatureTreeNode node) {
        int childCount = node.getChildCount();
        ArrayList<String> nodeList = new ArrayList<String>();
        if (childCount == 0) {
            nodeList.add(node.getID());
            return nodeList;
        }
        LinkedHashMap<String, List<String>> nodeChildrenMap = new LinkedHashMap<String, List<String>>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            FeatureTreeNode childNode = (FeatureTreeNode)node.getChildAt(i);
            List<String> childList = this.recursiveRun(childNode);
            String nodeID = childNode.getID();
            if (childNode instanceof FeatureGroup) {
                nodeID = "*" + nodeID;
            }
            nodeChildrenMap.put(nodeID, childList);
        }
        childCount = nodeChildrenMap.size();
        if (childCount <= 2) {
            for (List childNodeList : nodeChildrenMap.values()) {
                nodeList.addAll(childNodeList);
            }
        } else {
            List<String> childNodesBalancedList = this.balanceWeights(nodeChildrenMap);
            for (String childNodeName : childNodesBalancedList) {
                nodeList.addAll((Collection)nodeChildrenMap.get(childNodeName));
            }
        }
        int childNodePosSum = 0;
        for (String childNodeName : nodeChildrenMap.keySet()) {
            childNodePosSum += nodeList.indexOf(childNodeName);
        }
        int nodePos = Math.round((float)childNodePosSum / (1.0f * (float)childCount));
        String nodeID = node.getID();
        if (node instanceof FeatureGroup) {
            nodeID = "*" + nodeID;
        }
        nodeList.add(nodePos, nodeID);
        return nodeList;
    }

    public List<String> balanceWeights(Map<String, List<String>> weightsMap) {
        Set<Map.Entry<String, List<String>>> weights = weightsMap.entrySet();
        Comparator<Object> c = new Comparator<Object>(){

            @Override
            public int compare(Object entry1, Object entry2) {
                Map.Entry nEntry1 = (Map.Entry)entry1;
                Map.Entry nEntry2 = (Map.Entry)entry2;
                if (((List)nEntry1.getValue()).size() > ((List)nEntry2.getValue()).size()) {
                    return 1;
                }
                if (((List)nEntry1.getValue()).size() < ((List)nEntry2.getValue()).size()) {
                    return -1;
                }
                return 0;
            }
        };
        Object[] entries = weights.toArray();
        Arrays.sort(entries, c);
        ArrayList<String> leftList = new ArrayList<String>();
        ArrayList rightList = new ArrayList();
        ArrayList<Map.Entry> entriesList = new ArrayList<Map.Entry>();
        for (Object entry : entries) {
            entriesList.add((Map.Entry)entry);
        }
        int sumLeft = 0;
        int sumRight = 0;
        while (entriesList.size() > 0) {
            Map.Entry maxEntry = (Map.Entry)entriesList.get(entriesList.size() - 1);
            entriesList.remove(entriesList.size() - 1);
            rightList.add(maxEntry.getKey());
            sumRight += ((List)maxEntry.getValue()).size();
            int curWeight = 0;
            int index = entriesList.size() - 1;
            while (entriesList.size() > 0 && curWeight < ((List)maxEntry.getValue()).size()) {
                Map.Entry curEntry = (Map.Entry)entriesList.get(index);
                curWeight += ((List)curEntry.getValue()).size();
                sumLeft += ((List)curEntry.getValue()).size();
                entriesList.remove(index);
                leftList.add((String)curEntry.getKey());
                --index;
            }
        }
        leftList.addAll(rightList);
        return leftList;
    }
}

