/*
 * Decompiled with CFR 0.152.
 */
package splar.core.heuristics;

import java.util.Set;
import java.util.Stack;
import splar.core.constraints.BooleanVariableInterface;
import splar.core.constraints.CNFFormula;
import splar.core.fm.FeatureGroup;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureTreeNode;
import splar.core.heuristics.FTTraversalHeuristic;

public class FTPreOrderTraversalHeuristic
extends FTTraversalHeuristic {
    public FTPreOrderTraversalHeuristic(String name, FeatureModel featureModel) {
        super(name, featureModel);
    }

    @Override
    public String[] runHeuristic(CNFFormula cnf) {
        String[] varOrder = new String[cnf.getVariables().size()];
        Set<BooleanVariableInterface> cnfVariables = cnf.getVariables();
        Stack<FeatureTreeNode> nodes = new Stack<FeatureTreeNode>();
        nodes.push(this.getFeatureModel().getRoot());
        int curIndex = 0;
        while (nodes.size() > 0) {
            FeatureTreeNode curNode = (FeatureTreeNode)nodes.pop();
            if (curNode == null) continue;
            if (!(curNode instanceof FeatureGroup) && cnfVariables.contains(curNode)) {
                varOrder[curIndex++] = curNode.getID();
            }
            FeatureTreeNode[] childNodes = this.orderChildNodes(curNode);
            for (int i = childNodes.length - 1; i >= 0; --i) {
                nodes.push(childNodes[i]);
            }
        }
        return varOrder;
    }

    protected FeatureTreeNode[] orderChildNodes(FeatureTreeNode node) {
        int count = node.getChildCount();
        FeatureTreeNode[] nodes = new FeatureTreeNode[count];
        for (int i = 0; i < count; ++i) {
            nodes[i] = (FeatureTreeNode)node.getChildAt(i);
        }
        return nodes;
    }
}

