/*
 * Decompiled with CFR 0.152.
 */
package splar.core.heuristics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import splar.core.constraints.CNFClause;
import splar.core.constraints.CNFLiteral;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureTreeNode;
import splar.core.heuristics.NodeCluster;
import splar.core.util.hypergraphs.Hyperedge;
import splar.core.util.hypergraphs.Hypergraph;
import splar.core.util.hypergraphs.Vertex;

class NodeClusterManager {
    private FeatureModel featureModel;

    public NodeClusterManager(FeatureModel featureModel) {
        this.featureModel = featureModel;
    }

    public NodeCluster[] processCluster(FeatureTreeNode node, List<CNFClause> clauses) {
        ArrayList<NodeCluster> nodeCluster = new ArrayList<NodeCluster>();
        if (clauses != null) {
            Hypergraph hyperGraph = new Hypergraph();
            for (int i = 0; i < node.getChildCount(); ++i) {
                FeatureTreeNode childNode = (FeatureTreeNode)node.getChildAt(i);
                Vertex vertex = new Vertex(childNode.getID());
                hyperGraph.addVertex(vertex);
                Hyperedge hyperedge = new Hyperedge();
                hyperedge.addVertex(vertex);
                hyperGraph.addHyperEdge(hyperedge);
            }
            for (CNFClause clause : clauses) {
                Hypergraph clauseHyperGraph = new Hypergraph();
                Hyperedge clauseHyperEdge = new Hyperedge();
                for (CNFLiteral literal : clause.getLiterals()) {
                    Vertex vertex = hyperGraph.getVertexByName(literal.getVariable().getID());
                    clauseHyperGraph.addVertex(vertex);
                    clauseHyperEdge.addVertex(vertex);
                }
                clauseHyperGraph.addHyperEdge(clauseHyperEdge);
                hyperGraph.merge(clauseHyperGraph);
            }
            for (Hyperedge hyperedge : hyperGraph.getHyperedges()) {
                NodeCluster cluster = new NodeCluster(this.featureModel);
                for (Vertex vertex : hyperedge.getVertices()) {
                    cluster.addNode(vertex.getName());
                }
                nodeCluster.add(cluster);
            }
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                FeatureTreeNode childNode = (FeatureTreeNode)node.getChildAt(i);
                NodeCluster cluster = new NodeCluster(this.featureModel);
                cluster.addNode(childNode.getID());
                nodeCluster.add(cluster);
            }
        }
        NodeCluster[] sortedNodeClusters = new NodeCluster[nodeCluster.size()];
        for (int index = 0; index < nodeCluster.size(); ++index) {
            sortedNodeClusters[index] = (NodeCluster)nodeCluster.get(index);
        }
        Comparator<NodeCluster> c = new Comparator<NodeCluster>(){

            @Override
            public int compare(NodeCluster cluster1, NodeCluster cluster2) {
                int size2;
                int size1 = cluster1.size();
                return size1 > (size2 = cluster2.size()) ? 1 : (size1 < size2 ? -1 : 0);
            }
        };
        Arrays.sort(sortedNodeClusters, c);
        return sortedNodeClusters;
    }
}

