/*
 * Decompiled with CFR 0.152.
 */
package splar.core.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class CombinationGenerator {
    private int[] a;
    private int n;
    private int r;
    private BigInteger numLeft;
    private BigInteger total;

    public CombinationGenerator(int n, int r) {
        if (r > n) {
            throw new IllegalArgumentException();
        }
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.n = n;
        this.r = r;
        this.a = new int[r];
        BigInteger nFact = CombinationGenerator.getFactorial(n);
        BigInteger rFact = CombinationGenerator.getFactorial(r);
        BigInteger nminusrFact = CombinationGenerator.getFactorial(n - r);
        this.total = nFact.divide(rFact.multiply(nminusrFact));
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < this.a.length; ++i) {
            this.a[i] = i;
        }
        this.numLeft = new BigInteger(this.total.toString());
    }

    public BigInteger getNumLeft() {
        return this.numLeft;
    }

    public boolean hasMore() {
        return this.numLeft.compareTo(BigInteger.ZERO) == 1;
    }

    public BigInteger getTotal() {
        return this.total;
    }

    private static BigInteger getFactorial(int n) {
        BigInteger fact = BigInteger.ONE;
        for (int i = n; i > 1; --i) {
            fact = fact.multiply(new BigInteger(Integer.toString(i)));
        }
        return fact;
    }

    public int[] getNext() {
        if (this.numLeft.equals(this.total)) {
            this.numLeft = this.numLeft.subtract(BigInteger.ONE);
            return this.a;
        }
        int i = this.r - 1;
        while (this.a[i] == this.n - this.r + i) {
            --i;
        }
        this.a[i] = this.a[i] + 1;
        for (int j = i + 1; j < this.r; ++j) {
            this.a[j] = this.a[i] + j - i;
        }
        this.numLeft = this.numLeft.subtract(BigInteger.ONE);
        return this.a;
    }

    public static List<List<Integer>> computeCombinations(List<List<Integer>> combinations, int n, int p) {
        CombinationGenerator.groupCombination(combinations, null, 0, 0, n, p);
        return combinations;
    }

    public static void groupCombination(List<List<Integer>> combinations, ArrayList<Integer> index, int level, int start, int n, int p) {
        if (level == 0 && index == null) {
            index = new ArrayList(p);
        }
        if (level == p) {
            ArrayList<Integer> theIndex = new ArrayList<Integer>();
            theIndex.addAll(index);
            combinations.add(theIndex);
        } else if (n - start + 2 >= p) {
            for (int i = start; i < n; ++i) {
                index.add(level, i);
                CombinationGenerator.groupCombination(combinations, index, level + 1, i + 1, n, p);
                index.remove(level);
            }
        }
    }
}

