/*
 * Decompiled with CFR 0.152.
 */
package splar.core.util.hypergraphs;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import splar.core.util.hypergraphs.Vertex;

public class Hyperedge
extends Vertex {
    private Set<Vertex> edges = new LinkedHashSet<Vertex>();
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public Hyperedge() {
        this("");
    }

    public Hyperedge(String name) {
        super(name);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void addVertex(Vertex vertex) {
        this.edges.add(vertex);
    }

    public void addAllHyperedgeVertices(Hyperedge edge) {
        this.edges.addAll(edge.getVertices());
    }

    public Set<Vertex> getVertices() {
        return this.edges;
    }

    public boolean containsVertex(Vertex vertex) {
        return this.edges.contains(vertex);
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public boolean equals(Object edge) {
        if (edge != null && edge instanceof Hyperedge) {
            Hyperedge hedge = (Hyperedge)edge;
            if (hedge.getName().trim().length() == 0 || this.getName().trim().length() == 0) {
                return edge == this;
            }
            return this.getName().equals(hedge.getName());
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer toString = new StringBuffer(100);
        if (this.getName().trim().length() > 0) {
            toString.append(this.getName());
            toString.append(":");
        }
        toString.append("(");
        Iterator<Vertex> it2 = this.edges.iterator();
        while (it2.hasNext()) {
            Vertex vertex = it2.next();
            toString.append(vertex);
            if (!it2.hasNext()) continue;
            toString.append(",");
        }
        toString.append(")");
        return toString.toString();
    }
}

