/*
 * Decompiled with CFR 0.152.
 */
package splar.core.util.hypergraphs;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import splar.core.util.hypergraphs.Hyperedge;
import splar.core.util.hypergraphs.Vertex;

public class Hypergraph {
    private Set<Vertex> vertices = new LinkedHashSet<Vertex>();
    private Collection<Hyperedge> hyperEdges = new Vector<Hyperedge>();

    public Set<Vertex> getVertices() {
        return this.vertices;
    }

    public Collection<Hyperedge> getHyperedges() {
        return this.hyperEdges;
    }

    public Vertex getVertexByName(String name) {
        for (Vertex v : this.vertices) {
            if (!v.getName().equals(name)) continue;
            return v;
        }
        return null;
    }

    public void addVertex(Vertex vertex) {
        this.vertices.add(vertex);
    }

    public void addVertices(Set<Vertex> vertices) {
        this.vertices.addAll(vertices);
    }

    public void addHyperEdge(Hyperedge hyperedge) {
        this.hyperEdges.add(hyperedge);
    }

    public void getHyperEdgesThatContainsVertex(Vertex vertex, Collection<Hyperedge> hyperEdgesSet) {
        for (Hyperedge curHyperEdge : this.hyperEdges) {
            if (!curHyperEdge.containsVertex(vertex) || hyperEdgesSet.contains(curHyperEdge)) continue;
            hyperEdgesSet.add(curHyperEdge);
        }
    }

    public Hyperedge mergeHyperedges(Collection<Hyperedge> hyperEdgesSet) {
        if (hyperEdgesSet.size() > 0) {
            Hyperedge mergedHyperedgesSet = new Hyperedge();
            for (Hyperedge curHyperEdge : hyperEdgesSet) {
                mergedHyperedgesSet.addAllHyperedgeVertices(curHyperEdge);
                this.hyperEdges.remove(curHyperEdge);
            }
            this.hyperEdges.add(mergedHyperedgesSet);
            return mergedHyperedgesSet;
        }
        return null;
    }

    public void merge(Hypergraph inputGraph) {
        for (Vertex vertex : inputGraph.vertices) {
            this.addVertex(vertex);
        }
        for (Hyperedge hyperEdge : inputGraph.hyperEdges) {
            Vector<Hyperedge> selectedHyperEdges = new Vector<Hyperedge>();
            for (Vertex vertex : hyperEdge.getVertices()) {
                this.getHyperEdgesThatContainsVertex(vertex, selectedHyperEdges);
            }
            selectedHyperEdges.add(hyperEdge);
            this.mergeHyperedges(selectedHyperEdges);
        }
    }

    public Hypergraph projection(Hypergraph projectedHypergraph) {
        Hypergraph resultantHypergraph = new Hypergraph();
        for (Hyperedge hyperEdge : this.hyperEdges) {
            resultantHypergraph.addVertex(hyperEdge);
        }
        for (Hyperedge hyperEdge : projectedHypergraph.getHyperedges()) {
            Hyperedge newHyperEdge = new Hyperedge();
            for (Vertex vertex : hyperEdge.getVertices()) {
                Hyperedge selectedHyperEdge = this.findHyperedgeContainingVertex(vertex, this.hyperEdges);
                if (selectedHyperEdge == null) continue;
                newHyperEdge.addVertex(selectedHyperEdge);
            }
            resultantHypergraph.addHyperEdge(newHyperEdge);
        }
        return resultantHypergraph;
    }

    private Hyperedge findHyperedgeContainingVertex(Vertex vertex, Collection<Hyperedge> hyperedges) {
        for (Hyperedge hyperEdge : hyperedges) {
            if (!hyperEdge.containsVertex(vertex)) continue;
            return hyperEdge;
        }
        return null;
    }

    public String hyperEdgesToString(Collection<Hyperedge> hyperEdges) {
        StringBuffer toString = new StringBuffer(100);
        toString.append("Hyperedges:\r\n");
        for (Hyperedge hyperEdge : hyperEdges) {
            toString.append("=> ");
            toString.append(hyperEdge);
            toString.append("\r\n");
        }
        return toString.toString();
    }

    public String toString() {
        StringBuffer toString = new StringBuffer(100);
        toString.append("Vertices: {");
        Iterator<Vertex> it = this.vertices.iterator();
        while (it.hasNext()) {
            Vertex vertex = it.next();
            toString.append(vertex);
            if (!it.hasNext()) continue;
            toString.append(",");
        }
        toString.append("}\r\n");
        toString.append(this.hyperEdgesToString(this.hyperEdges));
        return toString.toString();
    }
}

