/*
 * Decompiled with CFR 0.152.
 */
package splar.samples;

import java.util.HashMap;
import java.util.Map;
import splar.core.fm.XMLFeatureModel;
import splar.plugins.reasoners.sat.sat4j.FMReasoningWithSAT;

public class SATReasoningExample {
    public static void main(String[] args) {
        new SATReasoningExample().run();
    }

    public void run() {
        try {
            String featureModelPath = "c:\\users\\marcilio\\eclipse\\fmrlib\\resources\\fm_samples\\simple_bike_fm.xml";
            XMLFeatureModel featureModel = new XMLFeatureModel(featureModelPath, 10);
            featureModel.loadModel();
            int SATtimeout = 60000;
            FMReasoningWithSAT reasoner = new FMReasoningWithSAT("MiniSAT", featureModel, SATtimeout);
            reasoner.init();
            System.out.println("Feature model is " + (reasoner.isConsistent() ? "" : " NOT ") + "consistent!");
            HashMap<String, String> stats = new HashMap<String, String>();
            Map<String, Boolean[]> domainTable = reasoner.allValidDomains(stats);
            System.out.println("Domains ---------------------");
            int countCommon = 0;
            int countDead = 0;
            for (String featureId : domainTable.keySet()) {
                Boolean[] domain;
                System.out.print("- " + featureId + ": [");
                for (Boolean value : domain = domainTable.get(featureId)) {
                    System.out.print(value + " ");
                }
                System.out.print("]");
                if (domain.length == 1 && domain[0].booleanValue()) {
                    System.out.print(" (common)");
                    ++countCommon;
                } else if (domain.length == 1 && !domain[0].booleanValue()) {
                    System.out.print(" (dead)");
                    ++countDead;
                }
                System.out.println();
            }
            System.out.println("Stats ---------------------");
            System.out.println("- Total Common Features.: " + countCommon);
            System.out.println("- Total Dead Features...: " + countDead);
            System.out.println("- Running Time..........: " + (String)stats.get("processing-time"));
            System.out.println("- Number of SAT Checks..: " + (String)stats.get("sat-checks"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

