/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.orders;

import java.io.PrintWriter;
import java.util.LinkedList;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.orders.VarOrderHeap;

public class TabuListDecorator
implements IOrder {
    private final VarOrderHeap decorated;
    private final int tabuSize;
    private ILits voc;
    private int lastVar = -1;
    private final LinkedList<Integer> tabuList = new LinkedList();

    public TabuListDecorator(VarOrderHeap varOrderHeap) {
        this(varOrderHeap, 10);
    }

    public TabuListDecorator(VarOrderHeap varOrderHeap, int n) {
        this.decorated = varOrderHeap;
        this.tabuSize = n;
    }

    public void assignLiteral(int n) {
        this.decorated.assignLiteral(n);
    }

    public IPhaseSelectionStrategy getPhaseSelectionStrategy() {
        return this.decorated.getPhaseSelectionStrategy();
    }

    public void init() {
        this.decorated.init();
        this.lastVar = -1;
    }

    public void printStat(PrintWriter printWriter, String string) {
        printWriter.println(string + "tabu list size\t: " + this.tabuSize);
        this.decorated.printStat(printWriter, string);
    }

    public int select() {
        int n = this.decorated.select();
        if (n == -1) {
            int n2;
            do {
                if (!this.tabuList.isEmpty()) continue;
                return -1;
            } while (!this.voc.isUnassigned((n2 = this.tabuList.removeFirst().intValue()) << 1));
            return this.getPhaseSelectionStrategy().select(n2);
        }
        this.lastVar = n >> 1;
        return n;
    }

    public void setLits(ILits iLits) {
        this.decorated.setLits(iLits);
        this.voc = iLits;
    }

    public void setPhaseSelectionStrategy(IPhaseSelectionStrategy iPhaseSelectionStrategy) {
        this.decorated.setPhaseSelectionStrategy(iPhaseSelectionStrategy);
    }

    public void setVarDecay(double d) {
        this.decorated.setVarDecay(d);
    }

    public void undo(int n) {
        if (this.tabuList.size() == this.tabuSize) {
            int n2 = this.tabuList.removeFirst();
            this.decorated.undo(n2);
        }
        if (n == this.lastVar) {
            this.tabuList.add(new Integer(n));
            this.lastVar = -1;
        } else {
            this.decorated.undo(n);
        }
    }

    public void updateVar(int n) {
        this.decorated.updateVar(n);
    }

    public double varActivity(int n) {
        return this.decorated.varActivity(n);
    }

    public void varDecayActivity() {
        this.decorated.varDecayActivity();
    }

    public void updateVarAtDecisionLevel(int n) {
        this.decorated.updateVarAtDecisionLevel(n);
    }

    public String toString() {
        return this.decorated.toString() + " with tabu list of size " + this.tabuSize;
    }

    public double[] getVariableHeuristics() {
        return this.decorated.getVariableHeuristics();
    }
}

