/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.sat4j.specs.ISolverService;
import org.sat4j.specs.Lbool;
import org.sat4j.tools.SearchListenerAdapter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionTracing
extends SearchListenerAdapter<ISolverService> {
    private static final long serialVersionUID = 1L;
    private int counter;
    private final String filename;
    private PrintStream outPos;
    private PrintStream outNeg;
    private PrintStream outRestart;
    private int nVar;

    public DecisionTracing(String string) {
        this.filename = string;
    }

    private void updateWriter() {
        try {
            this.outPos = new PrintStream(new FileOutputStream(new StringBuffer().append(this.filename).append("-pos.dat").toString()));
            this.outNeg = new PrintStream(new FileOutputStream(new StringBuffer().append(this.filename).append("-neg.dat").toString()));
            this.outRestart = new PrintStream(new FileOutputStream(new StringBuffer().append(this.filename).append("-restart.dat").toString()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.outPos = System.out;
            this.outNeg = System.out;
            this.outRestart = System.out;
        }
        this.counter = 1;
    }

    @Override
    public void assuming(int n) {
        if (n > 0) {
            this.outPos.println(new StringBuffer().append(this.counter).append("\t").append(n).toString());
            this.outNeg.println(new StringBuffer().append("#").append(this.counter).append("\t").append("0").toString());
        } else {
            this.outNeg.println(new StringBuffer().append(this.counter).append("\t").append(-n).toString());
            this.outPos.println(new StringBuffer().append("#").append(this.counter).append("\t").append("0").toString());
        }
        this.outRestart.println(new StringBuffer().append("#").append(this.counter).append("\t").append("0").toString());
        ++this.counter;
    }

    @Override
    public void restarting() {
        this.outRestart.println(new StringBuffer().append(this.counter).append("\t").append(this.nVar).toString());
        this.outNeg.println(new StringBuffer().append("#").append(this.counter).append("\t").append("0").toString());
        this.outPos.println(new StringBuffer().append("#").append(this.counter).append("\t").append("0").toString());
    }

    @Override
    public void end(Lbool lbool) {
        this.outPos.close();
        this.outNeg.close();
        this.outRestart.close();
    }

    @Override
    public void start() {
        this.updateWriter();
    }

    @Override
    public void init(ISolverService iSolverService) {
        this.nVar = iSolverService.nVars();
    }
}

