/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.alg.KShortestPathsIterator;
import org.jgrapht.alg.RankingPathElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KShortestPaths<V, E> {
    private Graph<V, E> graph;
    private int nMaxHops;
    private int nPaths;
    private V startVertex;

    public KShortestPaths(Graph<V, E> graph, V v, int n) {
        this(graph, v, n, graph.vertexSet().size() - 1);
    }

    public KShortestPaths(Graph<V, E> graph, V v, int n, int n2) {
        this.assertKShortestPathsFinder(graph, v, n, n2);
        this.graph = graph;
        this.startVertex = v;
        this.nPaths = n;
        this.nMaxHops = n2;
    }

    public List<RankingPathElement<V, E>> getPathElements(V v) {
        this.assertGetPaths(v);
        KShortestPathsIterator<V, E> kShortestPathsIterator = new KShortestPathsIterator<V, E>(this.graph, this.startVertex, v, this.nPaths);
        for (int i = 1; i <= this.nMaxHops && kShortestPathsIterator.hasNext(); ++i) {
            kShortestPathsIterator.next();
        }
        return kShortestPathsIterator.getPathElements(v);
    }

    private void assertGetPaths(V v) {
        if (v == null) {
            throw new NullPointerException("endVertex is null");
        }
        if (v.equals(this.startVertex)) {
            throw new IllegalArgumentException("The end vertex is the same as the start vertex!");
        }
        if (!this.graph.vertexSet().contains(v)) {
            throw new IllegalArgumentException("Graph must contain the end vertex!");
        }
    }

    private void assertKShortestPathsFinder(Graph<V, E> graph, V v, int n, int n2) {
        if (graph == null) {
            throw new NullPointerException("graph is null");
        }
        if (v == null) {
            throw new NullPointerException("startVertex is null");
        }
        if (n <= 0) {
            throw new NullPointerException("nPaths is negative or 0");
        }
        if (n2 <= 0) {
            throw new NullPointerException("nMaxHops is negative or 0");
        }
    }
}

