package multiobj;

/*
 * Author : Christopher Henard (christopher.henard@uni.lu)
 * Date : 23/02/2013
 * Copyright 2012 University of Luxembourg – Interdisciplinary Centre for Security Reliability and Trust (SnT)
 * All rights reserved
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import java.util.Comparator;
import java.util.List;
import org.sat4j.specs.IVecInt;

public class Individual implements Comparable<Individual>{
    
    
    private List<IVecInt> prods;
    private double fitness, o1, o2, o3;
    private double pairs, maxpairs, cost, maxcost, nbprods;

    public void setMaxpairs(double maxsum) {
        this.maxpairs = maxsum;
    }

    public void setMaxcost(double maxcost) {
        this.maxcost = maxcost;
    }

    public void setNbprods(double nbprods) {
        this.nbprods = nbprods;
    }

    public void setPairs(double sum) {
        this.pairs = sum;
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public double getMaxpairs() {
        return maxpairs;
    }

    public double getMaxcost() {
        return maxcost;
    }

    public double getNbprods() {
        return nbprods;
    }

    public double getPairs() {
        return pairs;
    }

    public double getCost() {
        return cost;
    }

    public Individual(List<IVecInt> prods) {
        this.prods = prods;
        this.fitness = fitness;
    }

    public double getFitness() {
        return fitness;
    }

    public List<IVecInt> getProds() {
        return prods;
    }

    public double getO1() {
        return o1;
    }

    public void setO1(double o1) {
        this.o1 = o1;
    }

    public double getO2() {
        return o2;
    }

    public void setO2(double o2) {
        this.o2 = o2;
    }

    public double getO3() {
        return o3;
    }

    public void setO3(double o3) {
        this.o3 = o3;
    }
    
    

    public void setFitness(double fitness) {
        this.fitness = fitness;
    }

    public void setProds(List<IVecInt> prods) {
        this.prods = prods;
    }



    @Override
    public int compareTo(Individual o) {
        return Double.compare(fitness , o.fitness);
    }
    
    
}
