#include <algorithm>
#include <boost/algorithm/string.hpp>
#include <boost/math/special_functions/binomial.hpp>
#include <boost/date_time/posix_time/posix_time.hpp>
#include <boost/regex.hpp>
#include <boost/tokenizer.hpp>
#include <boost/filesystem.hpp>
#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <fstream>
#include <iostream>
#include <list>
#include <random>
#include <set>
#include <sstream>
#include <string>
#include <vector>


extern "C" {
#include "picosat.h"
}

#define SOLVER_INITIAL_RANDOM_PHASE 3



void mandatory_dead_features();
void random_product(std::set<int>& result);
double fitness_sum(std::vector<std::set<int> *> &products);
void print_products(std::vector<std::set<int> *>& products);
void print_product(std::set<int>& product);
void random_product_assume(std::set<int>& result, int assume);
void init_fm();
bool valid(std::set<int>* p, PicoSAT *solver);
void init_rand();
void delete_rand();

std::set<std::set<int >> fmConst;

std::set<std::set<int >> mutConst;
std::vector<std::set<int >> mutConstVec;



int nbProd;
int nMut;
int sampling_percentage;

std::set<int> mandatory, dead;
std::vector<int> useful;
std::string fm, mutDir;
std::vector<int> fm_vals;


PicoSAT ** solvers;
PicoSAT ** mutant_solvers_const_only;
PicoSAT ** mutant_solvers_const_only_negated;


void random_product_assume(std::set<int>& result, int assume) {
    result.clear();
    PicoSAT * picosat = picosat_init();
    picosat_set_global_default_phase(picosat, SOLVER_INITIAL_RANDOM_PHASE);
    picosat_set_seed(picosat, SOLVER_INITIAL_RANDOM_PHASE); // Any seed different of 0 will provide random products

    for (int i = 0; i < fm_vals.size(); i++) {
        picosat_add(picosat, fm_vals.at(i));
    }

    picosat_assume(picosat, assume);

    if (picosat_sat(picosat, -1) == PICOSAT_SATISFIABLE) {

        int max_idx = picosat_variables(picosat), i, lit, val;

        for (i = 1; i <= max_idx; i++) {

            val = picosat_deref(picosat, i);
            lit = (val > 0) ? i : -i;
            result.insert(lit);
        }
    }
    picosat_reset(picosat);
}

bool random_product_assumes(std::set<int>& result, std::set<int>& assume) {
    result.clear();
    PicoSAT * picosat = picosat_init();
    picosat_set_global_default_phase(picosat, SOLVER_INITIAL_RANDOM_PHASE);
    picosat_set_seed(picosat, SOLVER_INITIAL_RANDOM_PHASE); // Any seed different of 0 will provide random products

    for (int i = 0; i < fm_vals.size(); i++) {
        picosat_add(picosat, fm_vals.at(i));
    }

    std::set<int>::const_iterator iter;
    iter = assume.begin();
    while (iter != assume.end()) {



        //std::cout << " ->" << *iter << std::endl;;
        picosat_assume(picosat, *iter);
        iter++;
    }

    //std::cout << std::endl;

    bool b = picosat_sat(picosat, -1) == PICOSAT_SATISFIABLE;
    if (b) {

        int max_idx = picosat_variables(picosat), i, lit, val;

        for (i = 1; i <= max_idx; i++) {

            val = picosat_deref(picosat, i);
            lit = (val > 0) ? i : -i;
            result.insert(lit);
        }
    }
    picosat_reset(picosat);
    return b;
}

void print_products(std::vector<std::set<int> *>& products) {
    int size = products.size();
    for (int i = 0; i < size; i++) {

        print_product(*products.at(i));
    }
}


double fitness_sum(std::vector<std::set<int> *> &products) {


    double s = 0.0;
    int limit = products.size();
    for (int k = 0; k < nMut; k++) {



        PicoSAT *solver = solvers[k];
        for (int i = 0; i < limit; i++) {
            bool b = valid(products.at(i), solver);
            if (!b) {
                s++;
                break;
            }
        }
    }


    return s / nMut;

}

void mandatory_dead_features() {
    PicoSAT * picosat = picosat_init();

    for (int i = 0; i < fm_vals.size(); i++) {
        picosat_add(picosat, fm_vals.at(i));
    }


    int nf = picosat_variables(picosat);


    for (int i = 1; i <= nf; i++) {


        bool mand = false, isdead = false;
        picosat_assume(picosat, i);
        if (picosat_sat(picosat, -1) != PICOSAT_SATISFIABLE) {
            dead.insert(i);
            isdead = true;
        }

        picosat_assume(picosat, -i);

        if (picosat_sat(picosat, -1) != PICOSAT_SATISFIABLE) {
            mand = true;
            mandatory.insert(i);
        }

        if (!mand && !isdead) {
            useful.push_back(i);
            useful.push_back(-i);
        }
    }
    picosat_reset(picosat);
}



void print_product2(const std::set<int> product) {
    std::set<int>::const_iterator iter;
    iter = product.begin();
    while (iter != product.end()) {
        std::cout << *iter;
        iter++;

        if (iter != product.end())
            std::cout << " ";
    }
    std::cout << std::endl;
}

void print_constr(std::set<std::set<int >> &constr) {
    std::set<std::set<int> >::const_iterator iter;
    iter = constr.begin();
    while (iter != constr.end()) {
        print_product2(*iter);
        iter++;

        if (iter != constr.end())
            std::cout << " ";
    }
    std::cout << std::endl;
}

void print_product(std::set<int>& product) {
    std::set<int>::const_iterator iter;
    iter = product.begin();
    while (iter != product.end()) {
        std::cout << *iter;
        iter++;

        if (iter != product.end())
            std::cout << " ";
    }
    std::cout << std::endl;
}

void init_fm() {
    PicoSAT * picosat = picosat_init();
    picosat_set_global_default_phase(picosat, SOLVER_INITIAL_RANDOM_PHASE);
    picosat_set_seed(picosat, SOLVER_INITIAL_RANDOM_PHASE); // Any seed different of 0 will provide random products
    std::ifstream in;
    in.open(fm.c_str());
    std::string line;

    if (in.good() && in.is_open()) {
        do {
            std::getline(in, line);
            boost::trim(line);
        } while (in.good() && !in.eof() && line.at(0) != 'p');

        boost::char_separator<char> sep(" ");


        //        std::set<int> *constr = new std::set<int>();
        //        delete(constr);




        while (in.good() && !in.eof()) {
            std::set<int> constr;
            std::getline(in, line);
            boost::tokenizer<boost::char_separator<char> > tokens(line, sep);
            for (boost::tokenizer<boost::char_separator<char> >::iterator token = tokens.begin(); token != tokens.end(); ++token) {
                int l = atoi(token->c_str());
                picosat_add(picosat, l);
                fm_vals.push_back(l);
                if (l != 0)
                    constr.insert(l);
            }
            if (!constr.empty())
                fmConst.insert(constr);

        }

    }
    in.close();


    picosat_reset(picosat);
}

void delete_fms() {
    for (int i = 0; i < nMut; i++) {
        picosat_reset(solvers[i]);
    }
    delete[] solvers;
}

void init_fms() {


    boost::filesystem::path mutantsDir(mutDir);
    boost::filesystem::directory_iterator end_iter;

    nMut = 0;

    for (boost::filesystem::directory_iterator dir_iter(mutantsDir); dir_iter != end_iter; ++dir_iter) {
        nMut++;
    }



    solvers = new PicoSAT*[nMut];

    int i = 0;

    for (boost::filesystem::directory_iterator dir_iter(mutantsDir); dir_iter != end_iter; ++dir_iter) {
        solvers[i] = picosat_init();
        picosat_set_global_default_phase(solvers[i], SOLVER_INITIAL_RANDOM_PHASE);
        picosat_set_seed(solvers[i], SOLVER_INITIAL_RANDOM_PHASE);


        std::ifstream in;
        std::string file = (*dir_iter).path().string();
        in.open(file.c_str());
        std::string line;

        if (in.good() && in.is_open()) {
            do {
                std::getline(in, line);
                boost::trim(line);
            } while (in.good() && !in.eof() && line.at(0) != 'p');

            boost::char_separator<char> sep(" ");


            while (in.good() && !in.eof()) {

                std::set<int> constr;

                std::getline(in, line);
                boost::tokenizer<boost::char_separator<char> > tokens(line, sep);
                for (boost::tokenizer<boost::char_separator<char> >::iterator token = tokens.begin(); token != tokens.end(); ++token) {
                    int l = atoi(token->c_str());
                    picosat_add(solvers[i], l);
                    if (l != 0)
                        constr.insert(l);
                }
                if (!constr.empty() && fmConst.find(constr) == fmConst.end())
                    mutConst.insert(constr);
            }
        }
        i++;
    }

    //    for (int i = 0; i < nConstr; i++) {
    //        std::cout << i << " -> " << picosat_added_original_clauses(solvers[i]) << std::endl;
    //    }
    //    exit(0);
}

void init_fms2() {


    int n = mutConst.size();
    mutant_solvers_const_only = new PicoSAT*[n];
    mutant_solvers_const_only_negated = new PicoSAT*[n];

    int i = 0;

    std::set<std::set<int> >::const_iterator iter;
    iter = mutConst.begin();



    for (i = 0; i < n; i++) {

        mutant_solvers_const_only[i] = picosat_init();
        picosat_set_global_default_phase(mutant_solvers_const_only[i], SOLVER_INITIAL_RANDOM_PHASE);
        picosat_set_seed(mutant_solvers_const_only[i], SOLVER_INITIAL_RANDOM_PHASE);


        mutant_solvers_const_only_negated[i] = picosat_init();
        picosat_set_global_default_phase(mutant_solvers_const_only_negated[i], SOLVER_INITIAL_RANDOM_PHASE);
        picosat_set_seed(mutant_solvers_const_only_negated[i], SOLVER_INITIAL_RANDOM_PHASE);
        picosat_save_original_clauses(mutant_solvers_const_only_negated[i]);

        std::set<int> constr = *iter;

        mutConstVec.push_back(constr);


        std::set<int>::const_iterator iter2;
        iter2 = constr.begin();
        while (iter2 != constr.end()) {



            picosat_add(mutant_solvers_const_only[i], *iter2);

            picosat_add(mutant_solvers_const_only_negated[i], -*iter2);
            picosat_add(mutant_solvers_const_only_negated[i], 0);


            iter2++;
        }


        picosat_add(mutant_solvers_const_only[i], 0);
        iter++;

    }
}

bool random_product_constr_solver(std::set<int>& result, std::set<int>& constr, PicoSAT *solver) {
    result.clear();


    bool b = picosat_sat(solver, -1) == PICOSAT_SATISFIABLE;
    if (b) {
        int max_idx = picosat_variables(solver), i, lit, val;

        for (int i = 1; i <= max_idx; i++) {

            val = picosat_deref_partial(solver, i);
            int lit = (val > 0) ? i : -i;

            if (constr.find(lit) != constr.end() || constr.find(-lit) != constr.end())

                result.insert(lit);
        }
    }

    return b;
}

void random_product_const(std::vector<std::set<int> *> &sol, std::set<int>& result) {
    result.clear();

    bool ok = false;

    while (!ok) {


        //choose const

        double *fit = new double[mutConst.size()];
        double total = 0.0;
        ;

        for (int i = 0; i < sol.size(); i++) {
            std::set<int> * prod = sol.at(i);
            int s = 0;
            for (int k = 0; k < mutConst.size(); k++) {
                if (valid(prod, mutant_solvers_const_only[i]))
                    s++;
            }
            fit[i] = (double) s / (double) mutConst.size();
            total += fit[i];

        }

        // Get a floating point number in the interval 0.0 ... sumFitness**
        double randomNumber = (float(rand() % 10000) / 9999.0f) * total;

        // Translate this number to the corresponding member**
        int memberID = 0;
        double partialSum = 0.0f;

        while (randomNumber > partialSum) {
            partialSum += fit[memberID];
            memberID++;
        }


        if (memberID < 0)
            memberID == 0;
        if (memberID > mutConst.size() - 1)
            memberID = mutConst.size() - 1;

        //std::cout << "select " << memberID << std::endl;

        delete[] fit;

        std::set<int> neg_constrr_sol;
        ok = random_product_constr_solver(neg_constrr_sol, mutConstVec[memberID], mutant_solvers_const_only_negated[memberID]);


        ok = random_product_assumes(result, neg_constrr_sol);




    }



}

void random_product(std::set<int>& result) {
    result.clear();



    PicoSAT * picosat = picosat_init();
    picosat_set_global_default_phase(picosat, SOLVER_INITIAL_RANDOM_PHASE);
    picosat_set_seed(picosat, SOLVER_INITIAL_RANDOM_PHASE); // Any seed different of 0 will provide random products



    for (int i = 0; i < fm_vals.size(); i++) {
        picosat_add(picosat, fm_vals.at(i));
    }

    if (picosat_sat(picosat, -1) == PICOSAT_SATISFIABLE) {
        int max_idx = picosat_variables(picosat), i, lit, val;

        for (i = 1; i <= max_idx; i++) {

            val = picosat_deref(picosat, i);
            lit = (val > 0) ? i : -i;
            result.insert(lit);
        }
    }

    picosat_reset(picosat);
}

bool valid(std::set<int>* p, PicoSAT *solver) {



    std::set<int>::const_iterator iter;
    iter = p->begin();
    while (iter != p->end()) {
        picosat_assume(solver, *iter);
        iter++;
    }



    if (picosat_sat(solver, -1) == PICOSAT_SATISFIABLE) {

        return true;
    } else
        return false;

}



int select_remove_index(std::vector<std::set<int> *>& sol) {

    double *fit = new double[sol.size()];
    double total = 0.0;
    ;

    for (int i = 0; i < sol.size(); i++) {
        std::set<int> * prod = sol.at(i);
        int s = 0;
        for (int k = 0; k < mutConst.size(); k++) {
            if (!valid(prod, mutant_solvers_const_only[i]))
                s++;
        }
        fit[i] = 1 - (double) s / (double) mutConst.size();
        total += fit[i];
        //std::cout << "prod " << i << " kills " << s << "/" << mutConst.size() << std::endl;
    }

    // Get a floating point number in the interval 0.0 ... sumFitness**
    double randomNumber = (float(rand() % 10000) / 9999.0f) * total;

    // Translate this number to the corresponding member**
    int memberID = 0;
    double partialSum = 0.0f;

    while (randomNumber > partialSum) {
        partialSum += fit[memberID];
        memberID++;
    }


    if (memberID < 0)
        memberID == 0;
    if (memberID > sol.size() - 1)
        memberID = sol.size() - 1;

    //std::cout << "select " << memberID << std::endl;

    delete[] fit;

    return memberID;
}

void approach(int maxRun, int max_rand_same_fit) {


    boost::posix_time::ptime lastTime = boost::posix_time::second_clock::local_time(), startTime = boost::posix_time::second_clock::local_time(), currentTime;


    std::vector<std::set<int> *> soll;
    int soll_size = 1; //rand() % (nMut / 2) + 1;




    for (int k = 0; k < soll_size; k++) {
        std::set<int> *s = new std::set<int>;
        random_product(*s);
        soll.push_back(s);
    }



    double fit = fitness_sum(soll);

    //std::cout << soll_size << " " << fit << std::endl;


    std::cout << "#[run] size fitness" << std::endl;

    int run = 0;
    while (run < maxRun) {


        // 0 -> remove

        int r = rand() % 2;
        if (r == 0) {


            //0 -> remove rand
            //1 -> add rand
            r = rand() % 2;
            //std::cout << r << std::endl;

            int removeIndex;

            if (r == 0)
                removeIndex = rand() % (soll_size);
            else
                removeIndex = select_remove_index(soll);
            std::set<int> *product = soll.at(removeIndex);
            soll.erase(soll.begin() + removeIndex);
            double newFit = fitness_sum(soll);



            if (newFit >= fit) {
                delete(product);
                soll_size--;
            } else {
                soll.push_back(product);
            }
        } else {

            r = rand() % 2;

            //0 = add random
            //1 = guided add

            if (r == 0) {
                //std::cout << "add!!!"<< std::endl;
                std::set<int> *s = new std::set<int>;
                random_product(*s);
                soll.push_back(s);
                double newFit = fitness_sum(soll);
                if (newFit > fit) {
                    //std::cout << "better!!!!" << std::endl;
                    fit = newFit;
                    soll_size++;
                } else {
                    soll.pop_back();
                    delete(s);
                }
            } else {
                std::set<int> *s = new std::set<int>;
                random_product_const(soll, *s);
                soll.push_back(s);
                double newFit = fitness_sum(soll);
                if (newFit > fit) {
                    //std::cout << "better!!!!" << std::endl;
                    fit = newFit;
                    soll_size++;
                } else {
                    soll.pop_back();
                    delete(s);
                }
            }
        }



        std::cout << run << " " << soll.size() << " " << fit << " " << std::endl;

        run++;
    }

    currentTime = boost::posix_time::second_clock::local_time();
    boost::posix_time::time_duration diff = currentTime - lastTime;
    std::cout << "APPROACH_TIME_MS " << diff.total_milliseconds() << std::endl;
    
    lastTime = boost::posix_time::second_clock::local_time();
    


    //rand same size

    std::vector<std::set<int> *> rand_soll;
    int rand_soll_size = soll_size;


    for (int k = 0; k < rand_soll_size; k++) {
        std::set<int> *s = new std::set<int>;
        random_product(*s);
        rand_soll.push_back(s);
    }


    double rand_fit = fitness_sum(rand_soll);

    //std::cout << "#RAND_SAME_SIZE size fit" << std::endl;
    std::cout << "RAND_SAME_SIZE " << rand_soll_size << " " << rand_fit << std::endl;

    
     currentTime = boost::posix_time::second_clock::local_time();
    diff = currentTime - lastTime;
    std::cout << "RAND_SAME_SIZE_TIME_MS " << diff.total_milliseconds() << std::endl;
    

    //rand same fitness

    lastTime = boost::posix_time::second_clock::local_time();
    
    std::vector<std::set<int> *> rand_soll2;

    while (fitness_sum(rand_soll2) < fit && rand_soll2.size() < max_rand_same_fit) {
        std::set<int> *s = new std::set<int>;
        random_product(*s);
        rand_soll2.push_back(s);
    }


    //std::cout << "#RAND_SAME_FIT size fit" << std::endl;
    std::cout << "RAND_SAME_FIT " << rand_soll2.size() << " " << fit << std::endl;

    
    currentTime = boost::posix_time::second_clock::local_time();
    diff = currentTime - lastTime;
    std::cout << "RAND_SAME_FIT_TIME_MS " << diff.total_milliseconds() << std::endl;
    

    exit(0);

}

int main(int argc, char** argv) {
    if (argc < 2){
        std::cout << "Usage: ./ssbse14 dimacsFM mutantsPath nbRuns maxConfigForRandomSameFitness" << std::endl;
        exit(1);
    }
    
    srand(time(NULL));

    fm = std::string(argv[1]);
    mutDir = std::string(argv[2]);
    int run = atoi(argv[3]);
    int max_rand_same_fit = atoi(argv[4]);



    //    fm = "/home/chris/tse_revision/real_fm_small_splcat/CounterStrikeSimpleFeatureModel.dimacs";
    //    mutDir = "/home/chris/counter_muts";

    //
    //    fm = std::string(argv[2]);
    //    mutDir = std::string(argv[3]);

    init_fm();
    init_fms();
    init_fms2();


    //print_constr(fmConst);

    std::set<int> prod;

    //std::cout << "===" << nMut << std::endl;
    //print_constr(mutConst);

    approach(run, max_rand_same_fit);

    exit(0);

}

