/*
 * Decompiled with CFR 0.152.
 */
package spl;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.orders.RandomLiteralSelectionStrategy;
import org.sat4j.minisat.orders.RandomWalkDecorator;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.reader.DimacsReader;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.ModelIterator;
import spl.fm.FeaturesPair;
import spl.fm.Product;
import spl.techniques.DistancesUtil;
import spl.techniques.RandomTechnique;
import spl.techniques.SimilarityTechnique;
import spl.techniques.ga.GA;
import splar.core.fm.FeatureModel;
import splar.core.fm.XMLFeatureModel;
import splar.core.heuristics.FTPreOrderSortedECTraversalHeuristic;
import splar.core.heuristics.VariableOrderingHeuristic;
import splar.core.heuristics.VariableOrderingHeuristicsManager;
import splar.plugins.reasoners.bdd.javabdd.FMReasoningWithBDD;
import splar.plugins.reasoners.bdd.javabdd.ReasoningWithBDD;
import splar.plugins.reasoners.sat.sat4j.FMReasoningWithSAT;
import splar.plugins.reasoners.sat.sat4j.ReasoningWithSAT;

public class SPL {
    private static Random randomGenerator = new Random();
    private FeatureModel fm;
    private ReasoningWithSAT reasonerSAT;
    private ISolver solverIterator;
    private ISolver dimacsSolver;
    private final IOrder order = new RandomWalkDecorator(new VarOrderHeap(new RandomLiteralSelectionStrategy()), 1.0);
    private CommandLineParser parser;
    private static SPL instance = null;
    private final int SATtimeout = 1000;
    private final long iteratorTimeout = 150000L;
    private boolean dimacs;
    private String dimacsFile;
    private boolean predictable;

    protected SPL() {
    }

    public static SPL getInstance() {
        if (instance == null) {
            instance = new SPL();
        }
        return instance;
    }

    public final void parseArgs(String[] args) {
        try {
            this.parser = new CommandLineParser(args, "SPL");
            if (args.length == 0) {
                throw new ParameterException("No arguments");
            }
            this.parser.parseArgs();
            String command = this.parser.getCommandName();
            if (command.equals("prio_solver_products")) {
                this.computePrioritizationSolverProducts(this.parser.getCommandPrioritizationSolverProducts().fmFile, this.parser.getCommandPrioritizationSolverProducts().outputFile, this.parser.getCommandPrioritizationSolverProducts().runs, this.parser.getCommandPrioritizationSolverProducts().validPairsFile, this.parser.getCommandPrioritizationSolverProducts().predictable);
            } else if (command.equals("average_data_files")) {
                if (this.parser.getCommandAverageDataFiles().outputDirectory == null) {
                    this.computeAverageDataFiles(this.parser.getCommandAverageDataFiles().inputDirectory, this.parser.getCommandAverageDataFiles().inputDirectory, this.parser.getCommandAverageDataFiles().noNorm);
                } else {
                    this.computeAverageDataFiles(this.parser.getCommandAverageDataFiles().inputDirectory, this.parser.getCommandAverageDataFiles().outputDirectory, this.parser.getCommandAverageDataFiles().noNorm);
                }
            } else if (command.equals("prio_splcat_products")) {
                this.computePrioritizationSPLCATProducts(this.parser.getCommandPrioritizationSPLCATProducts().csvFile, this.parser.getCommandPrioritizationSPLCATProducts().fmFile, this.parser.getCommandPrioritizationSPLCATProducts().outputFile, this.parser.getCommandPrioritizationSPLCATProducts().runs, this.parser.getCommandPrioritizationSPLCATProducts().validPairsFile);
            } else if (command.equals("prio_splcat_solver_products")) {
                this.computePrioritizationSPLCATSolverProducts(this.parser.getCommandPrioritizationSPLCATAndSolverProducts().csvFile, this.parser.getCommandPrioritizationSPLCATAndSolverProducts().fmFile, this.parser.getCommandPrioritizationSPLCATAndSolverProducts().outputFile, this.parser.getCommandPrioritizationSPLCATAndSolverProducts().runs, this.parser.getCommandPrioritizationSPLCATAndSolverProducts().validPairsFile, this.parser.commandPrioritizationSPLCATSolverProducts.predictable);
            } else if (command.equals("generate_prods_ga")) {
                this.generateProductsWithGA(this.parser.getCommandGenerateGA().fmFile, this.parser.getCommandGenerateGA().csvFile, this.parser.getCommandGenerateGA().outputFile, this.parser.getCommandGenerateGA().nbProds, this.parser.getCommandGenerateGA().runs, this.parser.getCommandGenerateGA().timeAllowed, this.parser.getCommandGenerateGA().validPairsFile, this.parser.getCommandGenerateGA().dimacs, this.parser.getCommandGenerateGA().noCoverage, this.parser.getCommandGenerateGA().onlyGA);
            } else if (command.equals("normalize_data_files")) {
                this.normalizeDataFile(this.parser.getCommandNormalizeDataFiles().input);
            } else if (command.equals("compute_valid_pairs")) {
                this.computeValidPairsToFile(this.parser.getCommandComputePairs().fmFile, this.parser.getCommandComputePairs().dimacs, this.parser.getCommandComputePairs().nbParts, this.parser.getCommandComputePairs().part);
            } else if (command.endsWith("compute_stats")) {
                this.computeStats(this.parser.getCommandComputeStats().fmFile, this.parser.getCommandComputeStats().dimacs);
            }
        }
        catch (ParameterException ex) {
            System.out.println("ERROR: " + ex.getMessage());
            this.parser.printUsage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void computePrioritizationSPLCATProducts(String splcatFile, String fmFile, String outputDir, int runs, String validPairsFile) throws Exception {
        int i;
        File output = new File(outputDir);
        if (!output.isDirectory()) {
            throw new ParameterException("Output directory specified is incorrect");
        }
        if (runs < 1) {
            throw new ParameterException("Number of runs specified incorrect");
        }
        File splcatCSV = new File(splcatFile);
        if (!splcatCSV.exists()) {
            throw new ParameterException("The specified SPLCAT file does not exist");
        }
        if (!outputDir.endsWith("/")) {
            outputDir = outputDir + "/";
        }
        if (validPairsFile != null && !new File(validPairsFile).exists()) {
            throw new ParameterException("The specified valid pairs file does not exist");
        }
        if (!new File(fmFile).exists()) {
            throw new ParameterException("The specified FM (xml) file does not exist");
        }
        this.fm = this.loadFeatureModel(fmFile);
        this.fm.loadModel();
        this.reasonerSAT = new FMReasoningWithSAT("MiniSAT", this.fm, 1000);
        this.reasonerSAT.init();
        String[] features = this.reasonerSAT.getVarIndex2NameMap();
        ArrayList<Integer> featuresList = new ArrayList<Integer>();
        HashMap<Integer, String> featuresMap = new HashMap<Integer, String>();
        HashMap<String, Integer> featuresMapRev = new HashMap<String, Integer>();
        this.computeFeatures(this.reasonerSAT, featuresMap, featuresMapRev, featuresList, false, null);
        String splcatFileName = splcatCSV.getName();
        List<Product> splcatProducts = this.loadProductsFromCSVFile(splcatCSV, featuresMapRev);
        int productsSize = splcatProducts.size();
        Set<FeaturesPair> validPairs = validPairsFile != null ? this.loadPairs(validPairsFile) : this.computePairsCoveredByProducts(splcatProducts);
        SimilarityTechnique simJaccardGreedy = new SimilarityTechnique(1, 2);
        SimilarityTechnique simJaccardOpti = new SimilarityTechnique(1, 3);
        RandomTechnique random = new RandomTechnique();
        double[] coverageValuesOriginal = new double[productsSize];
        double[] coverageValuesRand = new double[productsSize];
        double[] fitnessValuesRand = new double[productsSize];
        double[] coverageValuesSimGreedy = new double[productsSize];
        double[] coverageValuesSimOpti = new double[productsSize];
        this.computeProductsCoverage(splcatProducts, validPairs);
        for (int j = 0; j < productsSize; ++j) {
            int n = j;
            coverageValuesOriginal[n] = coverageValuesOriginal[n] + splcatProducts.get(j).getCoverage();
        }
        double[] fitnessValuesOriginal = this.computeFitnessSums(splcatProducts, 1);
        this.shuffle(splcatProducts);
        for (i = 0; i < runs; ++i) {
            List<Product> randomProducts = random.prioritize(splcatProducts);
            this.computeProductsCoverage(randomProducts, validPairs);
            for (int j = 0; j < randomProducts.size(); ++j) {
                int n = j;
                coverageValuesRand[n] = coverageValuesRand[n] + randomProducts.get(j).getCoverage();
            }
            double[] fitnessRand = this.computeFitnessSums(randomProducts, 1);
            for (int j = 0; j < fitnessRand.length; ++j) {
                int n = j;
                fitnessValuesRand[n] = fitnessValuesRand[n] + fitnessRand[j];
            }
        }
        i = 0;
        while (i < coverageValuesRand.length) {
            int n = i;
            coverageValuesRand[n] = coverageValuesRand[n] / (double)runs;
            int n2 = i++;
            fitnessValuesRand[n2] = fitnessValuesRand[n2] / (double)runs;
        }
        List<Product> simGreedyPrioritized = simJaccardGreedy.prioritize(splcatProducts);
        this.computeProductsCoverage(simGreedyPrioritized, validPairs);
        for (int j = 0; j < simGreedyPrioritized.size(); ++j) {
            int n = j;
            coverageValuesSimGreedy[n] = coverageValuesSimGreedy[n] + simGreedyPrioritized.get(j).getCoverage();
        }
        double[] fitnessValuesSimGreedy = this.computeFitnessSums(simGreedyPrioritized, 1);
        List<Product> simOptiPrioritized = simJaccardOpti.prioritize(splcatProducts);
        this.computeProductsCoverage(simOptiPrioritized, validPairs);
        for (int j = 0; j < simOptiPrioritized.size(); ++j) {
            int n = j;
            coverageValuesSimOpti[n] = coverageValuesSimOpti[n] + simOptiPrioritized.get(j).getCoverage();
        }
        double[] fitnessValuesSimOpti = this.computeFitnessSums(simOptiPrioritized, 1);
        this.writeCoverageAndFitnessValuesToFile(outputDir + splcatFileName + "_SPLCATProducts-OriginalOrder.dat", coverageValuesOriginal, fitnessValuesOriginal);
        this.writeCoverageAndFitnessValuesToFile(outputDir + splcatFileName + "_SPLCATProducts-Random-" + runs + "runs.dat", coverageValuesRand, fitnessValuesRand);
        this.writeCoverageAndFitnessValuesToFile(outputDir + splcatFileName + "_SPLCATProducts-SimJaccardGreedy.dat", coverageValuesSimGreedy, fitnessValuesSimGreedy);
        this.writeCoverageAndFitnessValuesToFile(outputDir + splcatFileName + "_SPLCATProducts-SimJaccardOpti.dat", coverageValuesSimOpti, fitnessValuesSimOpti);
    }

    public static Product getJaccardWorstProduct(List<Product> prods) {
        int i;
        double dMin = 0.0;
        Product worst = prods.get(0);
        for (i = 1; i < prods.size(); ++i) {
            dMin += DistancesUtil.getJaccardDistance(worst, prods.get(i));
        }
        for (i = 1; i < prods.size(); ++i) {
            double dist = 0.0;
            Product p = prods.get(i);
            for (int j = 0; j < prods.size(); ++j) {
                dist += DistancesUtil.getJaccardDistance(p, prods.get(j));
            }
            if (!(dist < dMin)) continue;
            dMin = dist;
            worst = p;
        }
        return worst;
    }

    public void computeStats(String fmFile, boolean dimacs) throws Exception {
        if (!new File(fmFile).exists()) {
            throw new ParameterException("The specified FM file does not exist");
        }
        if (!dimacs) {
            this.fm = this.loadFeatureModel(fmFile);
            this.fm.loadModel();
            new FTPreOrderSortedECTraversalHeuristic("Pre-CL-MinSpan", this.fm, 20);
            VariableOrderingHeuristic heuristic = VariableOrderingHeuristicsManager.createHeuristicsManager().getHeuristic("Pre-CL-MinSpan");
            FMReasoningWithBDD reasonerBDD = new FMReasoningWithBDD(this.fm, heuristic, 50000, 50000, 60000L, "pre-order");
            ((ReasoningWithBDD)reasonerBDD).init();
            this.reasonerSAT = new FMReasoningWithSAT("MiniSAT", this.fm, 1000);
            this.reasonerSAT.init();
            System.out.println("#Configs: " + reasonerBDD.countValidConfigurations());
            System.out.println("#Constraints: " + this.reasonerSAT.getSolver().nConstraints());
            System.out.println("#Features: " + this.reasonerSAT.getSolver().nVars());
        } else {
            this.dimacsSolver = SolverFactory.instance().createSolverByName("MiniSAT");
            this.dimacsSolver.setTimeout(1000);
            DimacsReader dr = new DimacsReader(this.dimacsSolver);
            dr.parseInstance(new FileReader(fmFile));
            System.out.println("#Constraints: " + this.dimacsSolver.nConstraints());
            System.out.println("#Features: " + this.dimacsSolver.nVars());
        }
    }

    public void generateProductsWithGA(String fmFile, String splcatFile, String outputDir, int nbProds, int runs, long timeAllowed, String validPairsFile, boolean dimacs, boolean noCoverage, boolean onlyGA) throws Exception {
        int i;
        File output = new File(outputDir);
        if (!output.isDirectory()) {
            throw new ParameterException("Output directory specified is incorrect");
        }
        if (runs < 1) {
            throw new ParameterException("Number of runs specified incorrect");
        }
        if (!outputDir.endsWith("/")) {
            outputDir = outputDir + "/";
        }
        if (!new File(fmFile).exists()) {
            throw new ParameterException("The specified FM file does not exist");
        }
        if (validPairsFile != null && !new File(validPairsFile).exists()) {
            throw new ParameterException("The specified valid pairs file does not exist");
        }
        if (nbProds < 0 && splcatFile == null) {
            throw new ParameterException("If -nbRuns < 0 then the csv file is mandatory!");
        }
        File splcatCSV = null;
        if (splcatFile != null && !(splcatCSV = new File(splcatFile)).exists()) {
            throw new ParameterException("The specified SPLCAT file does not exist");
        }
        this.predictable = false;
        this.dimacs = dimacs;
        this.dimacsFile = fmFile;
        if (!dimacs) {
            this.fm = this.loadFeatureModel(fmFile);
            this.fm.loadModel();
            this.reasonerSAT = new FMReasoningWithSAT("MiniSAT", this.fm, 1000);
            this.reasonerSAT.init();
        } else {
            this.dimacsSolver = SolverFactory.instance().createSolverByName("MiniSAT");
            this.dimacsSolver.setTimeout(1000);
            DimacsReader dr = new DimacsReader(this.dimacsSolver);
            dr.parseInstance(new FileReader(fmFile));
        }
        ArrayList<Integer> featuresList = new ArrayList<Integer>();
        HashMap<Integer, String> featuresMap = new HashMap<Integer, String>();
        HashMap<String, Integer> featuresMapRev = new HashMap<String, Integer>();
        if (!dimacs) {
            this.computeFeatures(this.reasonerSAT, featuresMap, featuresMapRev, featuresList, false, null);
        } else {
            this.computeFeatures(null, featuresMap, featuresMapRev, featuresList, true, fmFile);
        }
        System.out.println(featuresMapRev.size() + " features");
        Set<FeaturesPair> validPairs = null;
        if (!noCoverage && validPairsFile != null) {
            System.out.println("Loading valid pairs from the file...");
            validPairs = this.loadPairs(validPairsFile);
        }
        String sNbProds = "" + nbProds;
        if (nbProds < 0) {
            List<Product> splcatProducts = this.loadProductsFromCSVFile(splcatCSV, featuresMapRev);
            nbProds = splcatProducts.size();
            sNbProds = "SPLCAT";
            if (!noCoverage && validPairs == null) {
                validPairs = this.computePairsCoveredByProducts(splcatProducts);
            }
        }
        if (!noCoverage) {
            if (validPairs == null) {
                if (!dimacs) {
                    validPairs = this.computeValidPairs(featuresMap, featuresList, null, false, null, 1, 1);
                } else {
                    this.computeValidPairs(featuresMap, featuresList, fmFile + ".validpairs", true, this.dimacsSolver, 1, 1);
                }
            }
            System.out.println(validPairs.size() + " valid pairs.");
        }
        System.out.println(nbProds + " products to generate, " + runs + " runs");
        double[] coverageValuesUnpredictable = new double[nbProds];
        double[] fitnessValuesUnpredictable = new double[nbProds];
        double[] coverageValuesUnpredictablePrioritized = new double[nbProds];
        double[] fitnessValuesUnpredictablePrioritized = new double[nbProds];
        double[] coverageValuesSimpleGA = new double[nbProds];
        double[] fitnessValuesSimpleGA = new double[nbProds];
        if (!dimacs) {
            this.reasonerSAT.init();
            ((Solver)this.reasonerSAT.getSolver()).setOrder(this.order);
            this.solverIterator = new ModelIterator(this.reasonerSAT.getSolver());
            this.solverIterator.setTimeoutMs(150000L);
        } else {
            ((Solver)this.dimacsSolver).setOrder(this.order);
            this.solverIterator = new ModelIterator(this.dimacsSolver);
            this.solverIterator.setTimeoutMs(150000L);
        }
        GA ga = new GA(timeAllowed);
        String fmFileName = new File(fmFile).getName();
        System.out.println("Starting the runs...");
        for (i = 0; i < runs; ++i) {
            System.out.println("run " + (i + 1));
            double[] runCoverageUnpredictable = null;
            double[] fitnessUnpredictable = null;
            double[] runCoverageUnpredictablePrioritized = null;
            double[] fitnessUnpredictablePrioritized = null;
            List<Product> unpredictableProducts = null;
            List<Product> simOptiPrioritizedUnpredictable = null;
            if (!onlyGA) {
                double cov;
                int j;
                System.out.println("Unpredictable...");
                unpredictableProducts = this.getUnpredictableProducts(nbProds);
                if (!noCoverage) {
                    System.out.println("done, coverage...");
                } else {
                    System.out.println("done.");
                }
                this.shuffle(unpredictableProducts);
                if (!noCoverage) {
                    this.computeProductsCoverage(unpredictableProducts, validPairs);
                    runCoverageUnpredictable = new double[coverageValuesUnpredictable.length];
                    for (j = 0; j < nbProds; ++j) {
                        cov = unpredictableProducts.get(j).getCoverage();
                        int n = j;
                        coverageValuesUnpredictable[n] = coverageValuesUnpredictable[n] + cov;
                        runCoverageUnpredictable[j] = cov;
                    }
                    fitnessUnpredictable = this.computeFitnessSums(unpredictableProducts, 1);
                    for (j = 0; j < fitnessUnpredictable.length; ++j) {
                        int n = j;
                        fitnessValuesUnpredictable[n] = fitnessValuesUnpredictable[n] + fitnessUnpredictable[j];
                    }
                }
                System.out.println("unpredictable prioritized...");
                simOptiPrioritizedUnpredictable = new SimilarityTechnique(1, 3).prioritize(unpredictableProducts);
                if (!noCoverage) {
                    System.out.println("done, coverage...");
                } else {
                    System.out.println("done.");
                }
                if (!noCoverage) {
                    this.computeProductsCoverage(simOptiPrioritizedUnpredictable, validPairs);
                    runCoverageUnpredictablePrioritized = new double[coverageValuesUnpredictablePrioritized.length];
                    for (j = 0; j < nbProds; ++j) {
                        cov = simOptiPrioritizedUnpredictable.get(j).getCoverage();
                        int n = j;
                        coverageValuesUnpredictablePrioritized[n] = coverageValuesUnpredictablePrioritized[n] + cov;
                        runCoverageUnpredictablePrioritized[j] = cov;
                    }
                    fitnessUnpredictablePrioritized = this.computeFitnessSums(simOptiPrioritizedUnpredictable, 1);
                    for (j = 0; j < fitnessValuesUnpredictablePrioritized.length; ++j) {
                        int n = j;
                        fitnessValuesUnpredictablePrioritized[n] = fitnessValuesUnpredictablePrioritized[n] + fitnessUnpredictablePrioritized[j];
                    }
                }
            }
            System.out.println("Simple GA...");
            List<Product> gaSimpleRes = ga.runSimpleGA(nbProds, 0).getProducts();
            if (!noCoverage) {
                System.out.println("done, coverage...");
            } else {
                System.out.println("done.");
            }
            double[] runCoverageGA = null;
            double[] fitnessSimpleGA = null;
            if (!noCoverage) {
                int j;
                this.computeProductsCoverage(gaSimpleRes, validPairs);
                runCoverageGA = new double[coverageValuesSimpleGA.length];
                for (j = 0; j < nbProds; ++j) {
                    double cov = gaSimpleRes.get(j).getCoverage();
                    int n = j;
                    coverageValuesSimpleGA[n] = coverageValuesSimpleGA[n] + cov;
                    runCoverageGA[j] = cov;
                }
                fitnessSimpleGA = this.computeFitnessSums(gaSimpleRes, 1);
                for (j = 0; j < fitnessValuesSimpleGA.length; ++j) {
                    int n = j;
                    fitnessValuesSimpleGA[n] = fitnessValuesSimpleGA[n] + fitnessSimpleGA[j];
                }
            }
            if (!noCoverage) {
                if (!onlyGA) {
                    this.writeCoverageAndFitnessValuesToFile(outputDir + fmFileName + "_GA-UnpredictableProducts-" + sNbProds + "prods-" + timeAllowed + "ms-run" + (i + 1) + ".dat", runCoverageUnpredictable, fitnessUnpredictable);
                    this.writeCoverageAndFitnessValuesToFile(outputDir + fmFileName + "_GA-UnpredictableProductsPrioritized-" + sNbProds + "prods-" + timeAllowed + "ms-run" + (i + 1) + ".dat", runCoverageUnpredictablePrioritized, fitnessUnpredictablePrioritized);
                }
                this.writeCoverageAndFitnessValuesToFile(outputDir + fmFileName + "_GA-SimpleGAProducts-" + sNbProds + "prods-" + timeAllowed + "ms-run" + (i + 1) + ".dat", runCoverageGA, fitnessSimpleGA);
            }
            if (!onlyGA) {
                this.writeProductsToFile(outputDir + fmFileName + "_GA-UnpredictableProducts-" + sNbProds + "prods-" + timeAllowed + "ms-" + "run" + (i + 1) + ".products.csv", unpredictableProducts, featuresMap, featuresList);
                this.writeProductsToFile(outputDir + fmFileName + "_GA-UnpredictablePrioritized-" + sNbProds + "prods-" + timeAllowed + "ms-" + "run" + (i + 1) + ".products.csv", simOptiPrioritizedUnpredictable, featuresMap, featuresList);
            }
            this.writeProductsToFile(outputDir + fmFileName + "_GA-SimpleGAProducts-" + sNbProds + "prods-" + timeAllowed + "ms-" + "run" + (i + 1) + ".products.csv", gaSimpleRes, featuresMap, featuresList);
        }
        if (!noCoverage) {
            i = 0;
            while (i < nbProds) {
                if (!onlyGA) {
                    int n = i;
                    coverageValuesUnpredictable[n] = coverageValuesUnpredictable[n] / (double)runs;
                    int n2 = i;
                    coverageValuesUnpredictablePrioritized[n2] = coverageValuesUnpredictablePrioritized[n2] / (double)runs;
                    int n3 = i;
                    fitnessValuesUnpredictable[n3] = fitnessValuesUnpredictable[n3] / (double)runs;
                    int n4 = i;
                    fitnessValuesUnpredictablePrioritized[n4] = fitnessValuesUnpredictablePrioritized[n4] / (double)runs;
                }
                int n = i;
                coverageValuesSimpleGA[n] = coverageValuesSimpleGA[n] / (double)runs;
                int n5 = i++;
                fitnessValuesSimpleGA[n5] = fitnessValuesSimpleGA[n5] / (double)runs;
            }
        }
        if (!noCoverage) {
            if (!onlyGA) {
                this.writeCoverageAndFitnessValuesToFile(outputDir + fmFileName + "_GA-UnpredictableProducts-" + sNbProds + "prods-" + timeAllowed + "ms-" + runs + "runs.dat", coverageValuesUnpredictable, fitnessValuesUnpredictable);
            }
            this.writeCoverageAndFitnessValuesToFile(outputDir + fmFileName + "_GA-UnpredictableProductsPrioritized-" + sNbProds + "prods-" + timeAllowed + "ms-" + runs + "runs.dat", coverageValuesUnpredictablePrioritized, fitnessValuesUnpredictablePrioritized);
            this.writeCoverageAndFitnessValuesToFile(outputDir + fmFileName + "_GA-SimpleGAProducts-" + sNbProds + "prods-" + timeAllowed + "ms-" + runs + "runs.dat", coverageValuesSimpleGA, fitnessValuesSimpleGA);
        }
    }

    public void computePrioritizationSPLCATSolverProducts(String splcatFile, String fmFile, String outputDir, int runs, String validPairsFile, boolean predictable) throws Exception {
        int i;
        File output = new File(outputDir);
        if (!output.isDirectory()) {
            throw new ParameterException("Output directory specified is incorrect");
        }
        if (runs < 1) {
            throw new ParameterException("Number of runs specified incorrect");
        }
        File splcatCSV = new File(splcatFile);
        if (!splcatCSV.exists()) {
            throw new ParameterException("The specified SPLCAT file does not exist");
        }
        if (!outputDir.endsWith("/")) {
            outputDir = outputDir + "/";
        }
        if (!new File(fmFile).exists()) {
            throw new ParameterException("The specified FM (xml) file does not exist");
        }
        if (validPairsFile != null && !new File(validPairsFile).exists()) {
            throw new ParameterException("The specified valid pairs file does not exist");
        }
        if (!outputDir.endsWith("/")) {
            outputDir = outputDir + "/";
        }
        this.fm = this.loadFeatureModel(fmFile);
        this.fm.loadModel();
        this.reasonerSAT = new FMReasoningWithSAT("MiniSAT", this.fm, 1000);
        this.reasonerSAT.init();
        this.predictable = predictable;
        String[] features = this.reasonerSAT.getVarIndex2NameMap();
        ArrayList<Integer> featuresList = new ArrayList<Integer>();
        HashMap<Integer, String> featuresMap = new HashMap<Integer, String>();
        HashMap<String, Integer> featuresMapRev = new HashMap<String, Integer>();
        this.computeFeatures(this.reasonerSAT, featuresMap, featuresMapRev, featuresList, false, null);
        String splcatFileName = splcatCSV.getName();
        List<Product> splcatProducts = this.loadProductsFromCSVFile(splcatCSV, featuresMapRev);
        int splcatProductsSize = splcatProducts.size();
        int productsSize = splcatProducts.size() * 2;
        SimilarityTechnique simJaccardGreedy = new SimilarityTechnique(1, 2);
        SimilarityTechnique simJaccardOpti = new SimilarityTechnique(1, 3);
        RandomTechnique random = new RandomTechnique();
        double[] coverageValuesSolver = new double[productsSize];
        double[] fitnessValuesSolver = new double[productsSize];
        double[] coverageValuesSimGreedy = new double[productsSize];
        double[] fitnessValuesSimGreedy = new double[productsSize];
        double[] coverageValuesSimOpti = new double[productsSize];
        double[] fitnessValuesSimOpti = new double[productsSize];
        this.shuffle(splcatProducts);
        this.reasonerSAT.init();
        if (!predictable) {
            ((Solver)this.reasonerSAT.getSolver()).setOrder(this.order);
        }
        this.solverIterator = new ModelIterator(this.reasonerSAT.getSolver());
        this.solverIterator.setTimeoutMs(150000L);
        Set<FeaturesPair> validPairs = validPairsFile != null ? this.loadPairs(validPairsFile) : this.computePairsCoveredByProducts(splcatProducts);
        for (i = 0; i < runs; ++i) {
            List<Product> solverProducts = !predictable ? this.getUnpredictableProducts(splcatProductsSize) : this.getPredictableProducts(splcatProductsSize, features.length);
            ArrayList<Product> allProducts = new ArrayList<Product>(splcatProducts);
            allProducts.addAll(solverProducts);
            this.shuffle(allProducts);
            List<Product> solverPrioritized = random.prioritize(allProducts);
            this.computeProductsCoverage(solverPrioritized, validPairs);
            for (int j = 0; j < solverPrioritized.size(); ++j) {
                int n = j;
                coverageValuesSolver[n] = coverageValuesSolver[n] + solverPrioritized.get(j).getCoverage();
            }
            double[] fitnessSolver = this.computeFitnessSums(solverPrioritized, 1);
            for (int j = 0; j < fitnessSolver.length; ++j) {
                int n = j;
                fitnessValuesSolver[n] = fitnessValuesSolver[n] + fitnessSolver[j];
            }
            List<Product> simGreedyPrioritized = simJaccardGreedy.prioritize(allProducts);
            this.computeProductsCoverage(simGreedyPrioritized, validPairs);
            for (int j = 0; j < simGreedyPrioritized.size(); ++j) {
                int n = j;
                coverageValuesSimGreedy[n] = coverageValuesSimGreedy[n] + simGreedyPrioritized.get(j).getCoverage();
            }
            double[] fitnessSimGreedy = this.computeFitnessSums(simGreedyPrioritized, 1);
            for (int j = 0; j < fitnessSimGreedy.length; ++j) {
                int n = j;
                fitnessValuesSimGreedy[n] = fitnessValuesSimGreedy[n] + fitnessSimGreedy[j];
            }
            List<Product> simOptiPrioritized = simJaccardOpti.prioritize(allProducts);
            this.computeProductsCoverage(simOptiPrioritized, validPairs);
            for (int j = 0; j < simOptiPrioritized.size(); ++j) {
                int n = j;
                coverageValuesSimOpti[n] = coverageValuesSimOpti[n] + simOptiPrioritized.get(j).getCoverage();
            }
            double[] fitnessSimOpti = this.computeFitnessSums(simOptiPrioritized, 1);
            for (int j = 0; j < fitnessSimOpti.length; ++j) {
                int n = j;
                fitnessValuesSimOpti[n] = fitnessValuesSimOpti[n] + fitnessSimOpti[j];
            }
        }
        i = 0;
        while (i < coverageValuesSolver.length) {
            int n = i;
            coverageValuesSolver[n] = coverageValuesSolver[n] / (double)runs;
            int n2 = i;
            coverageValuesSimGreedy[n2] = coverageValuesSimGreedy[n2] / (double)runs;
            int n3 = i;
            coverageValuesSimOpti[n3] = coverageValuesSimOpti[n3] / (double)runs;
            int n4 = i;
            fitnessValuesSolver[n4] = fitnessValuesSolver[n4] / (double)runs;
            int n5 = i;
            fitnessValuesSimGreedy[n5] = fitnessValuesSimGreedy[n5] / (double)runs;
            int n6 = i++;
            fitnessValuesSimOpti[n6] = fitnessValuesSimOpti[n6] / (double)runs;
        }
        String sSolver = predictable ? "Predictable-" : "Unpredictable-";
        this.writeCoverageAndFitnessValuesToFile(outputDir + splcatFileName + "_SPLCATProductsAndSolver-" + sSolver + runs + "runs.dat", coverageValuesSolver, fitnessValuesSolver);
        this.writeCoverageAndFitnessValuesToFile(outputDir + splcatFileName + "_SPLCATProductsAndSolver-SimJaccardGreedy-" + runs + "runs.dat", coverageValuesSimGreedy, fitnessValuesSimGreedy);
        this.writeCoverageAndFitnessValuesToFile(outputDir + splcatFileName + "_SPLCATProductsAndSolver-SimJaccardOpti-" + runs + "runs.dat", coverageValuesSimOpti, fitnessValuesSimOpti);
    }

    public void computePrioritizationSolverProducts(String fmFile, String outputDir, int runs, String validPairsFile, boolean predictable) throws Exception {
        int i;
        File output = new File(outputDir);
        if (!output.isDirectory()) {
            throw new ParameterException("Output directory specified is incorrect");
        }
        if (runs < 1) {
            throw new ParameterException("Number of runs specified incorrect");
        }
        if (!new File(fmFile).exists()) {
            throw new ParameterException("The specified FM file does not exist");
        }
        if (!outputDir.endsWith("/")) {
            outputDir = outputDir + "/";
        }
        if (validPairsFile != null && !new File(validPairsFile).exists()) {
            throw new ParameterException("The specified valid pairs file does not exist");
        }
        String fmFileName = new File(fmFile).getName();
        this.fm = this.loadFeatureModel(fmFile);
        this.fm.loadModel();
        this.reasonerSAT = new FMReasoningWithSAT("MiniSAT", this.fm, 1000);
        this.reasonerSAT.init();
        String[] features = this.reasonerSAT.getVarIndex2NameMap();
        ArrayList<Integer> featuresList = new ArrayList<Integer>();
        HashMap<Integer, String> featuresMap = new HashMap<Integer, String>();
        HashMap<String, Integer> featuresMapRev = new HashMap<String, Integer>();
        this.computeFeatures(this.reasonerSAT, featuresMap, featuresMapRev, featuresList, false, null);
        this.reasonerSAT.init();
        this.predictable = predictable;
        Set<FeaturesPair> validPairs = validPairsFile != null ? this.loadPairs(validPairsFile) : this.computeValidPairs(featuresMap, featuresList, null, false, null, 1, 1);
        int featuresCount = features.length;
        int productsSize = featuresCount / 2;
        double[] coverageValuesSolver = new double[productsSize];
        double[] fitnessValuesSolver = new double[productsSize];
        double[] coverageValuesSimGreedy = new double[productsSize];
        double[] fitnessValuesSimGreedy = new double[productsSize];
        double[] coverageValuesSimOpti = new double[productsSize];
        double[] fitnessValuesSimOpti = new double[productsSize];
        SimilarityTechnique simJaccardGreedy = new SimilarityTechnique(1, 2);
        SimilarityTechnique simJaccardOpti = new SimilarityTechnique(1, 3);
        this.reasonerSAT.init();
        if (!predictable) {
            ((Solver)this.reasonerSAT.getSolver()).setOrder(this.order);
        }
        this.solverIterator = new ModelIterator(this.reasonerSAT.getSolver());
        this.solverIterator.setTimeoutMs(150000L);
        for (i = 0; i < runs; ++i) {
            List<Product> solverProducts = !predictable ? this.getUnpredictableProducts(productsSize) : this.getPredictableProducts(productsSize, features.length);
            this.shuffle(solverProducts);
            this.computeProductsCoverage(solverProducts, validPairs);
            for (int j = 0; j < solverProducts.size(); ++j) {
                int n = j;
                coverageValuesSolver[n] = coverageValuesSolver[n] + solverProducts.get(j).getCoverage();
            }
            double[] fitnessSolver = this.computeFitnessSums(solverProducts, 1);
            for (int j = 0; j < fitnessSolver.length; ++j) {
                int n = j;
                fitnessValuesSolver[n] = fitnessValuesSolver[n] + fitnessSolver[j];
            }
            List<Product> simGreedyPrioritized = simJaccardGreedy.prioritize(solverProducts);
            this.computeProductsCoverage(simGreedyPrioritized, validPairs);
            for (int j = 0; j < simGreedyPrioritized.size(); ++j) {
                int n = j;
                coverageValuesSimGreedy[n] = coverageValuesSimGreedy[n] + simGreedyPrioritized.get(j).getCoverage();
            }
            double[] fitnessSimGreedy = this.computeFitnessSums(simGreedyPrioritized, 1);
            for (int j = 0; j < fitnessSimGreedy.length; ++j) {
                int n = j;
                fitnessValuesSimGreedy[n] = fitnessValuesSimGreedy[n] + fitnessSimGreedy[j];
            }
            List<Product> simOptiPrioritized = simJaccardOpti.prioritize(solverProducts);
            this.computeProductsCoverage(simOptiPrioritized, validPairs);
            for (int j = 0; j < simOptiPrioritized.size(); ++j) {
                int n = j;
                coverageValuesSimOpti[n] = coverageValuesSimOpti[n] + simOptiPrioritized.get(j).getCoverage();
            }
            double[] fitnessSimOpti = this.computeFitnessSums(simOptiPrioritized, 1);
            for (int j = 0; j < fitnessSimOpti.length; ++j) {
                int n = j;
                fitnessValuesSimOpti[n] = fitnessValuesSimOpti[n] + fitnessSimOpti[j];
            }
        }
        i = 0;
        while (i < coverageValuesSolver.length) {
            int n = i;
            coverageValuesSolver[n] = coverageValuesSolver[n] / (double)runs;
            int n2 = i;
            coverageValuesSimGreedy[n2] = coverageValuesSimGreedy[n2] / (double)runs;
            int n3 = i;
            coverageValuesSimOpti[n3] = coverageValuesSimOpti[n3] / (double)runs;
            int n4 = i;
            fitnessValuesSolver[n4] = fitnessValuesSolver[n4] / (double)runs;
            int n5 = i;
            fitnessValuesSimGreedy[n5] = fitnessValuesSimGreedy[n5] / (double)runs;
            int n6 = i++;
            fitnessValuesSimOpti[n6] = fitnessValuesSimOpti[n6] / (double)runs;
        }
        String sSolver = predictable ? "Predictable-" : "Unpredictable-";
        this.writeCoverageAndFitnessValuesToFile(outputDir + fmFileName + "_ProductsSolver-" + sSolver + runs + "runs.dat", coverageValuesSolver, fitnessValuesSolver);
        this.writeCoverageAndFitnessValuesToFile(outputDir + fmFileName + "_ProductsSolver-SimJaccardGreedy-" + runs + "runs.dat", coverageValuesSimGreedy, fitnessValuesSimGreedy);
        this.writeCoverageAndFitnessValuesToFile(outputDir + fmFileName + "_ProductsSolver-SimJaccardOpti-" + runs + "runs.dat", coverageValuesSimOpti, fitnessValuesSimOpti);
    }

    public FeatureModel loadFeatureModel(String fmFile) {
        return new XMLFeatureModel(fmFile, 10);
    }

    public List<Product> getUnpredictableProducts(int count) throws Exception {
        ArrayList<Product> products = new ArrayList<Product>(count);
        while (products.size() < count) {
            try {
                if (this.solverIterator.isSatisfiable()) {
                    Product product = this.toProduct(this.solverIterator.model());
                    if (products.contains(product)) continue;
                    products.add(product);
                    continue;
                }
                if (!this.dimacs) {
                    this.reasonerSAT.init();
                    if (!this.predictable) {
                        ((Solver)this.reasonerSAT.getSolver()).setOrder(this.order);
                    }
                    this.solverIterator = new ModelIterator(this.reasonerSAT.getSolver());
                    this.solverIterator.setTimeoutMs(150000L);
                    continue;
                }
                this.dimacsSolver = SolverFactory.instance().createSolverByName("MiniSAT");
                this.dimacsSolver.setTimeout(1000);
                DimacsReader dr = new DimacsReader(this.dimacsSolver);
                dr.parseInstance(new FileReader(this.dimacsFile));
                if (!this.predictable) {
                    ((Solver)this.dimacsSolver).setOrder(this.order);
                }
                this.solverIterator = new ModelIterator(this.dimacsSolver);
                this.solverIterator.setTimeoutMs(150000L);
            }
            catch (TimeoutException timeoutException) {}
        }
        return products;
    }

    public Product getUnpredictableProduct() throws Exception {
        Product product = null;
        while (product == null) {
            try {
                if (this.solverIterator.isSatisfiable()) {
                    product = this.toProduct(this.solverIterator.model());
                    continue;
                }
                if (!this.dimacs) {
                    this.reasonerSAT.init();
                    if (!this.predictable) {
                        ((Solver)this.reasonerSAT.getSolver()).setOrder(this.order);
                    }
                    this.solverIterator = new ModelIterator(this.reasonerSAT.getSolver());
                    this.solverIterator.setTimeoutMs(150000L);
                    continue;
                }
                this.dimacsSolver = SolverFactory.instance().createSolverByName("MiniSAT");
                this.dimacsSolver.setTimeout(1000);
                DimacsReader dr = new DimacsReader(this.dimacsSolver);
                dr.parseInstance(new FileReader(this.dimacsFile));
                if (!this.predictable) {
                    ((Solver)this.dimacsSolver).setOrder(this.order);
                }
                this.solverIterator = new ModelIterator(this.dimacsSolver);
                this.solverIterator.setTimeoutMs(150000L);
            }
            catch (TimeoutException timeoutException) {}
        }
        return product;
    }

    public List<Product> getPredictableProducts(int count, int numberOfFeatures) throws Exception {
        ArrayList<Product> products = new ArrayList<Product>(count);
        while (products.size() < count) {
            try {
                if (this.solverIterator.isSatisfiable()) {
                    Product product = this.toProduct(this.solverIterator.model());
                    if (randomGenerator.nextInt(numberOfFeatures) != numberOfFeatures - 1 || products.contains(product)) continue;
                    products.add(product);
                    continue;
                }
                if (!this.dimacs) {
                    this.reasonerSAT.init();
                    if (!this.predictable) {
                        ((Solver)this.reasonerSAT.getSolver()).setOrder(this.order);
                    }
                    this.solverIterator = new ModelIterator(this.reasonerSAT.getSolver());
                    this.solverIterator.setTimeoutMs(150000L);
                    continue;
                }
                this.dimacsSolver = SolverFactory.instance().createSolverByName("MiniSAT");
                this.dimacsSolver.setTimeout(1000);
                DimacsReader dr = new DimacsReader(this.dimacsSolver);
                dr.parseInstance(new FileReader(this.dimacsFile));
                if (!this.predictable) {
                    ((Solver)this.dimacsSolver).setOrder(this.order);
                }
                this.solverIterator = new ModelIterator(this.dimacsSolver);
                this.solverIterator.setTimeoutMs(150000L);
            }
            catch (TimeoutException e) {}
        }
        return products;
    }

    public Set<FeaturesPair> computePairsCoveredByProducts(List<Product> products) {
        HashSet<FeaturesPair> coveredPairs = new HashSet<FeaturesPair>();
        for (Product product : products) {
            Set<FeaturesPair> productPairs = product.computeCoveredPairs();
            coveredPairs.addAll(productPairs);
        }
        return coveredPairs;
    }

    public void computeProductsCoverage(List<Product> products, Set<FeaturesPair> pairs) {
        double pairsSize = pairs.size();
        HashSet<FeaturesPair> pairsCopy = new HashSet<FeaturesPair>(pairs);
        boolean n = true;
        for (Product product : products) {
            int initialSize = pairsCopy.size();
            Set<FeaturesPair> productPairs = product.computeCoveredPairs();
            pairsCopy.removeAll(productPairs);
            double removed = initialSize - pairsCopy.size();
            double coverage = removed / pairsSize * 100.0;
            product.setCoverage(coverage);
        }
        pairsCopy = null;
    }

    public void shuffle(List<Product> products) {
        ArrayList<Product> productsCopy = new ArrayList<Product>(products);
        int done = 0;
        while (done < products.size()) {
            int index = randomGenerator.nextInt(productsCopy.size());
            products.set(done++, (Product)productsCopy.get(index));
            productsCopy.remove(index);
        }
    }

    public void writeDimacsProductToFile(String outFile, Product product) throws Exception {
        BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
        for (Integer i : product) {
            out.write(Integer.toString(i));
            out.newLine();
        }
        out.close();
    }

    public void writeProductsToFile(String outFile, List<Product> products, Map<Integer, String> featuresMap, List<Integer> featuresList) throws Exception {
        BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
        out.write("Feature\\Product;");
        for (int i = 0; i < products.size(); ++i) {
            out.write("" + i + ";");
        }
        out.newLine();
        int featuresCount = featuresList.size() / 2;
        for (int i = 1; i <= featuresCount; ++i) {
            out.write(featuresMap.get(i) + ";");
            for (Product p : products) {
                for (Integer n : p) {
                    if (Math.abs(n) != i) continue;
                    if (n > 0) {
                        out.write("X;");
                        continue;
                    }
                    out.write("-;");
                }
            }
            out.newLine();
        }
        out.close();
    }

    public boolean isValidProduct(Product product, Map<Integer, String> featuresMap, List<Integer> featuresList) throws Exception {
        VecInt prod = new VecInt(product.size());
        for (Integer s : product) {
            if (s < 0) {
                prod.push(-this.reasonerSAT.getVariableIndex(featuresMap.get(featuresList.get(-s.intValue() - 1))).intValue());
                continue;
            }
            prod.push(this.reasonerSAT.getVariableIndex(featuresMap.get(featuresList.get(s - 1))));
        }
        return this.reasonerSAT.getSolver().isSatisfiable(prod);
    }

    public boolean isValidPair(FeaturesPair pair, Map<Integer, String> featuresMap, List<Integer> featuresList, boolean dimacs, ISolver dimacsSolver) throws Exception {
        VecInt prod = new VecInt(2);
        int f1 = pair.getX();
        int f2 = pair.getY();
        if (!dimacs) {
            if (f1 < 0) {
                prod.push(-this.reasonerSAT.getVariableIndex(featuresMap.get(featuresList.get(-f1 - 1))).intValue());
            } else {
                prod.push(this.reasonerSAT.getVariableIndex(featuresMap.get(featuresList.get(f1 - 1))));
            }
            if (f2 < 0) {
                prod.push(-this.reasonerSAT.getVariableIndex(featuresMap.get(featuresList.get(-f2 - 1))).intValue());
            } else {
                prod.push(this.reasonerSAT.getVariableIndex(featuresMap.get(featuresList.get(f2 - 1))));
            }
            return this.reasonerSAT.getSolver().isSatisfiable(prod);
        }
        prod.push(f1);
        prod.push(f2);
        return dimacsSolver.isSatisfiable(prod);
    }

    private Set<FeaturesPair> computeValidPairs(Map<Integer, String> featuresMap, List<Integer> featuresList, String outFile, boolean dimacs, ISolver dimacsSolver, int nbParts, int part) throws Exception {
        if (part > nbParts || nbParts < 1) {
            throw new ParameterException("Invalid parts parameters");
        }
        BufferedWriter out = null;
        if (outFile != null) {
            out = nbParts == 1 ? new BufferedWriter(new FileWriter(outFile)) : new BufferedWriter(new FileWriter(outFile + ".part" + part));
        }
        HashSet<FeaturesPair> pairs = null;
        if (outFile == null) {
            pairs = new HashSet<FeaturesPair>();
            pairs.clear();
        }
        int size = featuresList.size();
        if (nbParts != 1) {
            int combSize = size * (size - 1) / 2;
            int tick = combSize / nbParts;
            int iStart = 0;
            if (part == 1) {
                iStart = 0;
            } else {
                for (int i = 1; i < part; ++i) {
                    iStart += tick;
                }
            }
            int iEnd = 0;
            iEnd = part == nbParts ? combSize - 1 : iStart + tick - 1;
            int done = 0;
            int n = 0;
            long start = System.currentTimeMillis();
            for (int i = 0; i < size; ++i) {
                for (int j = i + 1; j < size; ++j) {
                    if (System.currentTimeMillis() - start > 30000L) {
                        System.out.println(done + "/" + tick);
                        start = System.currentTimeMillis();
                    }
                    if (n >= iStart && n <= iEnd) {
                        ++done;
                        int left = featuresList.get(i);
                        int right = featuresList.get(j);
                        if (Math.abs(left) != Math.abs(right)) {
                            FeaturesPair pair = new FeaturesPair(left, right);
                            boolean validPair = dimacs ? this.isValidPair(pair, null, null, true, dimacsSolver) : this.isValidPair(pair, featuresMap, featuresList, false, null);
                            if (validPair) {
                                if (outFile != null) {
                                    out.write(pair.getX() + ";" + pair.getY());
                                    out.newLine();
                                } else {
                                    pairs.add(pair);
                                }
                            }
                        }
                    }
                    ++n;
                }
            }
        } else {
            for (int i = 0; i < size; ++i) {
                int left = featuresList.get(i);
                for (int j = i + 1; j < size; ++j) {
                    int right = featuresList.get(j);
                    if (Math.abs(left) == Math.abs(right)) continue;
                    FeaturesPair pair = new FeaturesPair(left, right);
                    boolean validPair = dimacs ? this.isValidPair(pair, null, null, true, dimacsSolver) : this.isValidPair(pair, featuresMap, featuresList, false, null);
                    if (!validPair) continue;
                    if (outFile != null) {
                        out.write(pair.getX() + ";" + pair.getY());
                        out.newLine();
                        continue;
                    }
                    pairs.add(pair);
                }
            }
        }
        if (outFile != null) {
            out.close();
            return null;
        }
        return pairs;
    }

    public void computeFeatures(ReasoningWithSAT reasonerSAT, Map<Integer, String> featuresMap, Map<String, Integer> featuresMapRev, List<Integer> featuresList, boolean dimacs, String dimacsFile) throws Exception {
        if (!dimacs) {
            String[] features = reasonerSAT.getVarIndex2NameMap();
            for (int i = 0; i < features.length; ++i) {
                String feature = features[i];
                int n = i + 1;
                featuresList.add(n);
                featuresMap.put(n, feature);
                featuresMapRev.put(feature, n);
            }
        } else {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(dimacsFile));
            int n = 0;
            while ((line = in.readLine()) != null && line.startsWith("c")) {
                StringTokenizer st = new StringTokenizer(line.trim(), " ");
                st.nextToken();
                String sFeature = st.nextToken().replace('$', ' ').trim();
                int feature = Integer.parseInt(sFeature);
                if (++n != feature) {
                    throw new Exception("Incorrect dimacs file, missing feature number " + n + " ?");
                }
                String featureName = st.nextToken();
                featuresList.add(feature);
                featuresMap.put(feature, featureName);
                featuresMapRev.put(featureName, feature);
            }
            in.close();
        }
        int featuresCount = featuresList.size();
        for (int n = 1; n <= featuresCount; ++n) {
            featuresList.add(-n);
        }
    }

    public void writeCoverageAndFitnessValuesToFile(String outFile, double[] coverageValues, double[] fitnessSums) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
        out.write("#coverage of pairs (in %, starting from 0 products selected);Fitness func");
        out.newLine();
        out.write("0;0");
        out.newLine();
        double s = 0.0;
        for (int i = 0; i < coverageValues.length; ++i) {
            out.write(Double.toString(s += coverageValues[i]) + ";" + Double.toString(fitnessSums[i]));
            out.newLine();
        }
        out.close();
    }

    public void normalizeDataFile(String inputDir) throws Exception {
        File[] datFiles;
        File inDir = new File(inputDir);
        if (!inDir.exists()) {
            throw new ParameterException("Input directory does not exist");
        }
        for (File file : datFiles = inDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".dat") && !name.toLowerCase().contains("norm");
            }
        })) {
            String line;
            int count = this.countUncommentedLines(file);
            double[] coverageValues = new double[count];
            double[] fitnessValues = new double[count];
            BufferedReader in = new BufferedReader(new FileReader(file));
            int i = 0;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                StringTokenizer st = new StringTokenizer(line, ";");
                coverageValues[i] = Double.parseDouble(st.nextToken().trim());
                fitnessValues[i] = Double.parseDouble(st.nextToken().trim());
                ++i;
            }
            in.close();
            double[] normalizedCoverageValues = new double[101];
            double[] normalizedFitnessValues = new double[101];
            for (int j = 0; j < normalizedCoverageValues.length; ++j) {
                int prodIndex = (int)((double)j / 100.0 * (double)(coverageValues.length - 1));
                normalizedCoverageValues[j] = coverageValues[prodIndex];
                normalizedFitnessValues[j] = fitnessValues[prodIndex] / fitnessValues[fitnessValues.length - 1] * 100.0;
            }
            String outFile = file.toString().replace(".dat", "-Norm.dat");
            BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
            out.write("#coverage of pairs (in %, starting from 0% of products selected (normalized));Fitness func (normalized)");
            out.newLine();
            for (int k = 0; k < normalizedCoverageValues.length; ++k) {
                out.write(Double.toString(normalizedCoverageValues[k]) + ";" + Double.toString(normalizedFitnessValues[k]));
                out.newLine();
            }
            out.close();
        }
    }

    public Product toProduct(int[] vector) {
        Product product = new Product();
        for (int i : vector) {
            product.add(i);
        }
        return product;
    }

    public void computeAverageDataFiles(String inputDir, String outputDir, final boolean noNorm) throws Exception {
        File inDir = new File(inputDir);
        if (!inDir.exists()) {
            throw new ParameterException("Input directory does not exist");
        }
        if (outputDir.equals("Same as input")) {
            outputDir = inputDir;
        }
        if (!new File(outputDir).exists()) {
            throw new ParameterException("Output directory does not exist");
        }
        File[] datFiles = inDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (!noNorm) {
                    return name.endsWith("-Norm.dat");
                }
                return name.endsWith(".dat") && !name.toLowerCase().contains("norm");
            }
        });
        HashSet<String> types = new HashSet<String>();
        for (File file : datFiles) {
            String sFile = file.toString();
            String type = sFile.substring(sFile.lastIndexOf("_") + 1, sFile.length());
            types.add(type);
        }
        for (final String type : types) {
            double[] fitnessValues;
            double[] coverageValues;
            datFiles = inDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(type);
                }
            });
            int n = 0;
            if (!noNorm) {
                coverageValues = new double[101];
                fitnessValues = new double[101];
            } else {
                int count = this.minUncommentedLinesCount(datFiles);
                coverageValues = new double[count];
                fitnessValues = new double[count];
            }
            String firstLine = "";
            for (File dat : datFiles) {
                String line;
                int i = 0;
                BufferedReader in = new BufferedReader(new FileReader(dat));
                while ((line = in.readLine()) != null && i < coverageValues.length) {
                    if ((line = line.trim()).isEmpty()) continue;
                    if (line.startsWith("#")) {
                        firstLine = line;
                        continue;
                    }
                    StringTokenizer tokenizer = new StringTokenizer(line, ";");
                    double cov = Double.parseDouble(tokenizer.nextToken());
                    double fit = Double.parseDouble(tokenizer.nextToken());
                    int n2 = i;
                    coverageValues[n2] = coverageValues[n2] + cov;
                    int n3 = i++;
                    fitnessValues[n3] = fitnessValues[n3] + fit;
                }
                in.close();
                ++n;
            }
            int i = 0;
            while (i < coverageValues.length) {
                int n4 = i;
                coverageValues[n4] = coverageValues[n4] / (double)n;
                int n5 = i++;
                fitnessValues[n5] = fitnessValues[n5] / (double)n;
            }
            String outFile = outputDir;
            if (!outFile.endsWith("/")) {
                outFile = outFile + "/";
            }
            outFile = outFile + "AVG_ON_ALL_" + type;
            BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
            out.write(firstLine);
            out.newLine();
            for (int i2 = 0; i2 < coverageValues.length; ++i2) {
                out.write(Double.toString(coverageValues[i2]) + ";" + Double.toString(fitnessValues[i2]));
                out.newLine();
            }
            out.close();
        }
    }

    public int countUncommentedLines(File file) throws Exception {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(file));
        int n = 0;
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            ++n;
        }
        in.close();
        return n;
    }

    public int minUncommentedLinesCount(File[] files) throws Exception {
        int min = this.countUncommentedLines(files[0]);
        for (int i = 1; i < files.length; ++i) {
            int count = this.countUncommentedLines(files[i]);
            if (count >= min) continue;
            min = count;
        }
        return min;
    }

    public List<Product> loadProductsFromCSVFile(File csvFile, Map<String, Integer> featuresMapRev) throws Exception {
        String line;
        ArrayList<Product> products = new ArrayList<Product>();
        BufferedReader in = new BufferedReader(new FileReader(csvFile));
        boolean firstLine = true;
        ArrayList<String> features = null;
        if (featuresMapRev != null) {
            features = new ArrayList<String>();
        }
        while ((line = in.readLine()) != null) {
            StringTokenizer tokenizer = new StringTokenizer(line, ";");
            if (firstLine) {
                if (featuresMapRev != null) {
                    while (tokenizer.hasMoreTokens()) {
                        features.add(tokenizer.nextToken().trim());
                    }
                }
                firstLine = false;
                continue;
            }
            Product product = new Product();
            int count = featuresMapRev != null ? 0 : 1;
            while (tokenizer.hasMoreTokens()) {
                if (tokenizer.nextToken().equals("X")) {
                    if (featuresMapRev != null) {
                        product.add(featuresMapRev.get(features.get(count)));
                    } else {
                        product.add(count);
                    }
                } else if (featuresMapRev != null) {
                    product.add(-featuresMapRev.get(features.get(count)).intValue());
                } else {
                    product.add(-count);
                }
                ++count;
            }
            products.add(product);
        }
        return products;
    }

    public double[] computeFitnessSums(List<Product> products, int distanceMethod) {
        int size = products.size();
        double[][] distancesMatrix = new double[size][size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (j <= i) continue;
                distancesMatrix[i][j] = DistancesUtil.getJaccardDistance(products.get(i), products.get(j));
            }
        }
        double[] fitnessSums = new double[size];
        for (int n = size - 1; n >= 0; --n) {
            fitnessSums[n] = SimilarityTechnique.getJaccardFitnessSum(distancesMatrix, n + 1);
        }
        return fitnessSums;
    }

    public void computeValidPairsToFile(String fmFile, boolean dimacs, int nbParts, int part) throws Exception {
        if (!new File(fmFile).exists()) {
            throw new ParameterException("The specified FM file does not exist");
        }
        int timeoutS = 300;
        ArrayList<Integer> featuresList = new ArrayList<Integer>();
        HashMap<Integer, String> featuresMap = new HashMap<Integer, String>();
        HashMap<String, Integer> featuresMapRev = new HashMap<String, Integer>();
        if (!dimacs) {
            this.fm = this.loadFeatureModel(fmFile);
            this.fm.loadModel();
            this.reasonerSAT = new FMReasoningWithSAT("MiniSAT", this.fm, timeoutS);
            this.reasonerSAT.init();
            this.reasonerSAT.getSolver().setTimeout(timeoutS);
            this.computeFeatures(this.reasonerSAT, featuresMap, featuresMapRev, featuresList, false, null);
            this.computeValidPairs(featuresMap, featuresList, fmFile + ".validpairs", false, null, nbParts, part);
        } else {
            this.computeFeatures(null, featuresMap, featuresMapRev, featuresList, true, fmFile);
            this.dimacsSolver = SolverFactory.instance().createSolverByName("MiniSAT");
            this.dimacsSolver.setTimeout(timeoutS);
            DimacsReader dr = new DimacsReader(this.dimacsSolver);
            dr.parseInstance(new FileReader(fmFile));
            this.computeValidPairs(featuresMap, featuresList, fmFile + ".validpairs", true, this.dimacsSolver, nbParts, part);
        }
    }

    public Set<FeaturesPair> loadPairs(String pairsFile) throws Exception {
        String line;
        if (!new File(pairsFile).exists()) {
            throw new ParameterException("The specified FM file does not exist");
        }
        LineNumberReader lnr = new LineNumberReader(new FileReader(pairsFile));
        lnr.skip(Long.MAX_VALUE);
        ArrayList<FeaturesPair> pairs = new ArrayList<FeaturesPair>(lnr.getLineNumber());
        BufferedReader in = new BufferedReader(new FileReader(pairsFile));
        while ((line = in.readLine()) != null) {
            if (line.isEmpty()) continue;
            StringTokenizer st = new StringTokenizer(line, ";");
            FeaturesPair pair = new FeaturesPair(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
            pairs.add(pair);
        }
        in.close();
        HashSet<FeaturesPair> pairsSet = new HashSet<FeaturesPair>(pairs);
        return pairsSet;
    }

    public static void main(String[] args) {
        SPL.getInstance().parseArgs(args);
    }

    private class CommandLineParser {
        private JCommander jCommander;
        private PrioritizationSolverProducts commandPrioritizationSolverProducts;
        private AverageDataFiles commandAverageDataFiles;
        private PrioritizationSPLCATProducts commandPrioritizationSPLCATProducts;
        private PrioritizationSPLCATSolverProducts commandPrioritizationSPLCATSolverProducts;
        private NormalizeDataFiles commandNormalizeDataFiles;
        private GenerateGA commandGenerateGA;
        private ComputePairs commandComputePairs;
        private ComputeStats commandComputeStats;
        private String[] args;
        public static final String PRIORITIZATION_SOLVER_PRODUCTS = "prio_solver_products";
        public static final String AVERAGE_NORMALIZED_DATA_FILES = "average_data_files";
        public static final String PRIORITIZATION_SPLCAT_PRODUCTS = "prio_splcat_products";
        public static final String PRIORITIZATION_SPLCAT_SOLVER_PRODUCTS = "prio_splcat_solver_products";
        public static final String NORMALIZE_DATA_FILES = "normalize_data_files";
        public static final String GENERATE_GA = "generate_prods_ga";
        public static final String COMPUTE_PAIRS = "compute_valid_pairs";
        public static final String COMPUTE_STATS = "compute_stats";

        public CommandLineParser(String[] args, String programName) {
            this.args = args;
            this.commandPrioritizationSolverProducts = new PrioritizationSolverProducts();
            this.commandAverageDataFiles = new AverageDataFiles();
            this.commandPrioritizationSPLCATProducts = new PrioritizationSPLCATProducts();
            this.commandPrioritizationSPLCATSolverProducts = new PrioritizationSPLCATSolverProducts();
            this.commandNormalizeDataFiles = new NormalizeDataFiles();
            this.commandGenerateGA = new GenerateGA();
            this.commandComputePairs = new ComputePairs();
            this.commandComputeStats = new ComputeStats();
            this.jCommander = new JCommander();
            this.jCommander.addCommand(PRIORITIZATION_SPLCAT_PRODUCTS, this.commandPrioritizationSPLCATProducts);
            this.jCommander.addCommand(PRIORITIZATION_SOLVER_PRODUCTS, this.commandPrioritizationSolverProducts);
            this.jCommander.addCommand(PRIORITIZATION_SPLCAT_SOLVER_PRODUCTS, this.commandPrioritizationSPLCATSolverProducts);
            this.jCommander.addCommand(AVERAGE_NORMALIZED_DATA_FILES, this.commandAverageDataFiles);
            this.jCommander.addCommand(NORMALIZE_DATA_FILES, this.commandNormalizeDataFiles);
            this.jCommander.addCommand(GENERATE_GA, this.commandGenerateGA);
            this.jCommander.addCommand(COMPUTE_PAIRS, this.commandComputePairs);
            this.jCommander.addCommand(COMPUTE_STATS, this.commandComputeStats);
            this.jCommander.setProgramName("java -jar " + programName + ".jar");
        }

        public void parseArgs() {
            this.jCommander.parse(this.args);
        }

        public void printUsage() {
            this.jCommander.usage();
        }

        public String getCommandName() {
            return this.jCommander.getParsedCommand();
        }

        public PrioritizationSolverProducts getCommandPrioritizationSolverProducts() {
            return this.commandPrioritizationSolverProducts;
        }

        public AverageDataFiles getCommandAverageDataFiles() {
            return this.commandAverageDataFiles;
        }

        public PrioritizationSPLCATProducts getCommandPrioritizationSPLCATProducts() {
            return this.commandPrioritizationSPLCATProducts;
        }

        public PrioritizationSPLCATSolverProducts getCommandPrioritizationSPLCATAndSolverProducts() {
            return this.commandPrioritizationSPLCATSolverProducts;
        }

        public NormalizeDataFiles getCommandNormalizeDataFiles() {
            return this.commandNormalizeDataFiles;
        }

        public GenerateGA getCommandGenerateGA() {
            return this.commandGenerateGA;
        }

        public ComputePairs getCommandComputePairs() {
            return this.commandComputePairs;
        }

        public ComputeStats getCommandComputeStats() {
            return this.commandComputeStats;
        }

        @Parameters(commandDescription="Generate products using the GA")
        private class GenerateGA {
            @Parameter(names={"-csv"}, description="CSV file output from SPLCAT tool. This argument is optional, see -nbProds option")
            private String csvFile;
            @Parameter(names={"-fm"}, description="Feature model (SPLOT format)", required=true)
            private String fmFile;
            @Parameter(names={"-o"}, description="Output directory", required=true)
            private String outputFile;
            @Parameter(names={"-runs"}, description="Number of runs to average")
            private int runs = 10;
            @Parameter(names={"-nbProds"}, description="Number of products to generate. If negative, then the same number as the SPLCAT output will be used. In this case, the -csv option is required")
            private int nbProds = 10;
            @Parameter(names={"-timeAllowedMS"}, description="Time allowed for the GA in ms")
            private long timeAllowed = 60000L;
            @Parameter(names={"-p"}, description="Valid pairs file")
            private String validPairsFile;
            @Parameter(names={"-dimacs"}, description="Specify if the FM is a dimacs one")
            private boolean dimacs = false;
            @Parameter(names={"-noCoverage"}, description="Do not compute the coverage (only generate the products)")
            private boolean noCoverage = false;
            @Parameter(names={"-onlyGA"}, description="Run only the GA approach")
            private boolean onlyGA = false;

            private GenerateGA() {
            }
        }

        @Parameters(commandDescription="Compute some statistics for a FM ")
        private class ComputeStats {
            @Parameter(names={"-fm"}, description="Feature model (Dimacs or SPLOT format)", required=true)
            private String fmFile;
            @Parameter(names={"-dimacs"}, description="Specify if the FM is a dimacs one")
            private boolean dimacs = false;

            private ComputeStats() {
            }
        }

        @Parameters(commandDescription="Compute the valid pairs to a file for a XML FM ")
        private class ComputePairs {
            @Parameter(names={"-fm"}, description="Feature model (Dimacs or SPLOT format)", required=true)
            private String fmFile;
            @Parameter(names={"-dimacs"}, description="Specify if the FM is a dimacs one")
            private boolean dimacs = false;
            @Parameter(names={"-parts"}, description="Specify the number of parts")
            private int nbParts = 1;
            @Parameter(names={"-part"}, description="Specify which part should be considered. Only if nbParts > 1")
            private int part = 1;

            private ComputePairs() {
            }
        }

        @Parameters(commandDescription="Compute the normalized version of the data files present specified in the directory")
        private class NormalizeDataFiles {
            @Parameter(names={"-i"}, description="Directory containing data file to normalize", required=true)
            private String input;

            private NormalizeDataFiles() {
            }
        }

        @Parameters(commandDescription="Compute the average between the data files specified in the directory")
        private class AverageDataFiles {
            @Parameter(names={"-i"}, description="Directory containing .dat files", required=true)
            private String inputDirectory;
            @Parameter(names={"-o"}, description="Output directory")
            private String outputDirectory = "Same as input";
            @Parameter(names={"-noNorm"}, description="Don't work on normalized data files. The minimum length data file will be used")
            private boolean noNorm = false;

            private AverageDataFiles() {
            }
        }

        @Parameters(commandDescription="Computes the values of the prioritization techniques and fitness function using a set of products from the solver. The number of products generated will be equal to #features/2")
        private class PrioritizationSolverProducts {
            @Parameter(names={"-fm"}, description="Feature model (SPLOT format)", required=true)
            private String fmFile;
            @Parameter(names={"-o"}, description="Output directory", required=true)
            private String outputFile;
            @Parameter(names={"-runs"}, description="Number of runs to average")
            private int runs = 10;
            @Parameter(names={"-p"}, description="Valid pairs file")
            private String validPairsFile;
            @Parameter(names={"-predictable"}, description="Use the predictable products for the solver")
            private boolean predictable = false;

            private PrioritizationSolverProducts() {
            }
        }

        @Parameters(commandDescription="Computes the values of the prioritization techniques and fitness function using the set of valid products from SPLCAT + additional products from the solver. ")
        private class PrioritizationSPLCATSolverProducts {
            @Parameter(names={"-csv"}, description="CSV file output from SPLCAT tool", required=true)
            private String csvFile;
            @Parameter(names={"-fm"}, description="Feature model (SPLOT format)", required=true)
            private String fmFile;
            @Parameter(names={"-o"}, description="Output directory", required=true)
            private String outputFile;
            @Parameter(names={"-runs"}, description="Number of runs to average")
            private int runs = 10;
            @Parameter(names={"-p"}, description="Valid pairs file")
            private String validPairsFile;
            @Parameter(names={"-predictable"}, description="Use the predictable products for the solver")
            private boolean predictable = false;

            private PrioritizationSPLCATSolverProducts() {
            }
        }

        @Parameters(commandDescription="Computes the values of the prioritization techniques and fitness function using the set of valid products from SPLCAT. ")
        private class PrioritizationSPLCATProducts {
            @Parameter(names={"-csv"}, description="CSV file output from SPLCAT tool", required=true)
            private String csvFile;
            @Parameter(names={"-fm"}, description="Feature model (SPLOT format)", required=true)
            private String fmFile;
            @Parameter(names={"-o"}, description="Output directory", required=true)
            private String outputFile;
            @Parameter(names={"-runs"}, description="Number of runs to average the random technique")
            private int runs = 10;
            @Parameter(names={"-p"}, description="Valid pairs file")
            private String validPairsFile;

            private PrioritizationSPLCATProducts() {
            }
        }
    }
}

