/*
 * Decompiled with CFR 0.152.
 */
package spl.techniques;

import java.util.ArrayList;
import java.util.List;
import spl.fm.Product;
import spl.techniques.DistancesUtil;
import spl.techniques.PrioritizationTechnique;

public class SimilarityTechnique
implements PrioritizationTechnique {
    public static final int JACCARD_DISTANCE = 1;
    public static final int GREEDY_SEARCH = 2;
    public static final int NEAR_OPTIMAL_SEARCH = 3;
    private int distanceMethod;
    private int searchMethod;
    private double lastFitnessComputed;

    public SimilarityTechnique(int distanceMethod, int searchMethod) {
        this.distanceMethod = distanceMethod;
        this.searchMethod = searchMethod;
        this.lastFitnessComputed = -1.0;
    }

    public double getLastFitnessComputed() {
        return this.lastFitnessComputed;
    }

    public void setLastFitnessComputed(double lastFitnessComputed) {
        this.lastFitnessComputed = lastFitnessComputed;
    }

    @Override
    public List<Product> prioritize(List<Product> products) {
        int size = products.size();
        ArrayList<Product> prioritizedProducts = new ArrayList<Product>(size);
        ArrayList<Product> productsCopy = new ArrayList<Product>(products);
        double[][] distancesMatrix = new double[size][size];
        this.lastFitnessComputed = 0.0;
        for (int i = 0; i < distancesMatrix.length; ++i) {
            block8: for (int j = 0; j < distancesMatrix.length; ++j) {
                distancesMatrix[i][j] = -1.0;
                if (j <= i) continue;
                switch (this.distanceMethod) {
                    case 1: {
                        double dist = DistancesUtil.getJaccardDistance((Product)productsCopy.get(i), (Product)productsCopy.get(j));
                        this.lastFitnessComputed += dist;
                        distancesMatrix[i][j] = dist;
                        continue block8;
                    }
                }
            }
        }
        switch (this.searchMethod) {
            case 2: {
                while (!productsCopy.isEmpty()) {
                    if (productsCopy.size() != 1) {
                        double dmax = -1.0;
                        int toAddIIndex = -1;
                        int toAddJIndex = -1;
                        for (int i = 0; i < distancesMatrix.length; ++i) {
                            for (int j = 0; j < distancesMatrix.length; ++j) {
                                if (j <= i || !(distancesMatrix[i][j] > dmax)) continue;
                                dmax = distancesMatrix[i][j];
                                toAddIIndex = i;
                                toAddJIndex = j;
                            }
                        }
                        Product pi = products.get(toAddIIndex);
                        Product pj = products.get(toAddJIndex);
                        prioritizedProducts.add(pi);
                        prioritizedProducts.add(pj);
                        productsCopy.remove(pi);
                        productsCopy.remove(pj);
                        for (int i = 0; i < distancesMatrix.length; ++i) {
                            distancesMatrix[toAddJIndex][i] = -1.0;
                            distancesMatrix[i][toAddJIndex] = -1.0;
                            distancesMatrix[i][toAddIIndex] = -1.0;
                            distancesMatrix[toAddIIndex][i] = -1.0;
                        }
                        continue;
                    }
                    prioritizedProducts.add((Product)productsCopy.get(0));
                    productsCopy.clear();
                }
                break;
            }
            case 3: {
                ArrayList<Integer> possibleIndices = new ArrayList<Integer>();
                ArrayList<Integer> doneIndices = new ArrayList<Integer>();
                for (int i = 0; i < size; ++i) {
                    possibleIndices.add(i);
                }
                double maxDistance = -1.0;
                int toAddIIndex = -1;
                int toAddJIndex = -1;
                for (int i = 0; i < distancesMatrix.length; ++i) {
                    for (int j = 0; j < distancesMatrix.length; ++j) {
                        if (j <= i || !(distancesMatrix[i][j] > maxDistance)) continue;
                        maxDistance = distancesMatrix[i][j];
                        toAddIIndex = i;
                        toAddJIndex = j;
                    }
                }
                Product pi = products.get(toAddIIndex);
                Product pj = products.get(toAddJIndex);
                prioritizedProducts.add(pi);
                prioritizedProducts.add(pj);
                productsCopy.remove(pi);
                productsCopy.remove(pj);
                possibleIndices.remove((Object)toAddIIndex);
                possibleIndices.remove((Object)toAddJIndex);
                doneIndices.add(toAddIIndex);
                doneIndices.add(toAddJIndex);
                while (!productsCopy.isEmpty()) {
                    if (possibleIndices.size() > 1) {
                        double maxDist = -1.0;
                        int toAdd = -1;
                        for (Integer i : possibleIndices) {
                            double distance = 0.0;
                            for (Integer j : doneIndices) {
                                distance += j > i ? distancesMatrix[i][j] : distancesMatrix[j][i];
                            }
                            if (!(distance > maxDist)) continue;
                            maxDist = distance;
                            toAdd = i;
                        }
                        Product p = products.get(toAdd);
                        prioritizedProducts.add(p);
                        productsCopy.remove(p);
                        possibleIndices.remove((Object)toAdd);
                        doneIndices.add(toAdd);
                        continue;
                    }
                    prioritizedProducts.add(products.get((Integer)possibleIndices.get(0)));
                    productsCopy.clear();
                }
                break;
            }
        }
        return prioritizedProducts;
    }

    public static double getJaccardFitnessSum(double[][] distancesMatrix, int max) {
        double sum = 0.0;
        for (int i = 0; i < max; ++i) {
            for (int j = 0; j < max; ++j) {
                if (j <= i) continue;
                sum += distancesMatrix[i][j];
            }
        }
        return sum;
    }

    public static double getJaccardFitnessSum(List<Product> products) {
        double sum = 0.0;
        int size = products.size();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (j <= i) continue;
                sum += DistancesUtil.getJaccardDistance(products.get(i), products.get(j));
            }
        }
        return sum;
    }
}

